/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.gui;

import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.odsx.OdsxRelationEditorInterface;
import com.highqsoft.odsx.gui.OdsxFatherRelationEditor;
import com.highqsoft.odsx.gui.OdsxMultiRelationEditor;
import com.highqsoft.odsx.gui.OdsxSelector;
import com.highqsoft.odsx.gui.OdsxSingleRelationEditor;
import com.highqsoft.odsx.gui.UnhandledRelationException;
import java.awt.BorderLayout;
import java.awt.Container;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.asam.ods.AoException;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.InstanceElement;
import org.asam.ods.RelationRange;
import org.asam.ods.T_LONGLONG;

public class OdsxRelationEditor
extends JPanel
implements OdsxRelationEditorInterface {
    static Icon[] BALLS = new Icon[]{new ImageIcon(FwkIconFile.getIcon((String)"green-ball").getImage()), new ImageIcon(FwkIconFile.getIcon((String)"red-ball").getImage())};
    static Icon LOAD = new ImageIcon(FwkIconFile.getIcon((String)"load").getImage());
    static final int RATE = 20;
    static final String CHECKER_CARD = "CHECKER";
    static final String BLINKER_CARD = "BLINKER";
    static final String LOAD_CARD = "LOAD";
    ApplicationElement aeObj;
    ApplicationElement relAeObj;
    InstanceElement ieObj;
    ApplicationRelation aeRel;
    int relationHandle;
    int[] cardinality;
    OdsxSelector selector;
    JLabel iconLabel;
    ButtonGroup buttonGroup = null;

    public OdsxRelationEditor(InstanceElement ieObj, ApplicationRelation aeRel, ButtonGroup buttonGroup) throws AoException, UnhandledRelationException {
        this(ieObj, ieObj.getApplicationElement(), aeRel, buttonGroup);
    }

    public OdsxRelationEditor(InstanceElement ieObj, ApplicationElement aeObj, ApplicationRelation aeRel, ButtonGroup buttonGroup) throws AoException, UnhandledRelationException {
        this.aeObj = aeObj;
        this.aeRel = aeRel;
        this.ieObj = ieObj;
        this.buttonGroup = buttonGroup;
        this.create();
    }

    public OdsxRelationEditor(ApplicationElement aeObj, ApplicationRelation aeRel, ButtonGroup buttonGroup) throws AoException, UnhandledRelationException {
        this.aeObj = aeObj;
        this.aeRel = aeRel;
        this.buttonGroup = buttonGroup;
        this.ieObj = null;
        this.create();
    }

    protected void finalize() throws Throwable {
        this.aeObj = null;
        this.relAeObj = null;
        this.ieObj = null;
        this.aeRel = null;
        super.finalize();
    }

    protected void create() throws AoException, UnhandledRelationException {
        this.analizeRelation();
        if (this.relationHandle == 0) {
            this.selector = new OdsxFatherRelationEditor(this.ieObj, this.aeObj, this.aeRel, this.relationHandle, this.iconLabel, this.buttonGroup);
        } else if (this.relationHandle == 3) {
            this.selector = this.cardinality[0] == 1 ? new OdsxSingleRelationEditor(this.ieObj, this.aeObj, this.aeRel, this.relationHandle, this.iconLabel) : new OdsxMultiRelationEditor(this.ieObj, this.aeObj, this.aeRel, this.relationHandle, this.iconLabel);
        } else if (this.relationHandle == 2) {
            this.selector = this.cardinality[1] == 1 ? new OdsxSingleRelationEditor(this.ieObj, this.aeObj, this.aeRel, this.relationHandle, this.iconLabel) : new OdsxMultiRelationEditor(this.ieObj, this.aeObj, this.aeRel, this.relationHandle, this.iconLabel);
        } else {
            throw new UnhandledRelationException();
        }
        this.setLayout(new BorderLayout());
        this.add("Center", (Container)((Object)this.selector));
    }

    protected void analizeRelation() throws AoException, UnhandledRelationException {
        RelationRange range = this.aeRel.getRelationRange();
        RelationRange invRange = this.aeRel.getInverseRelationRange();
        this.cardinality = new int[]{invRange.max == -1 ? Integer.MAX_VALUE : (int)invRange.max, range.max == -1 ? Integer.MAX_VALUE : (int)range.max};
        int type = this.aeRel.getRelationType().value();
        int ship = this.aeRel.getRelationship().value();
        this.iconLabel = new JLabel();
        block0 : switch (type) {
            case 0: {
                switch (ship) {
                    case 0: {
                        this.relationHandle = ship;
                        this.iconLabel.setIcon((Icon)FwkIconFile.getIcon((String)"Icon.RelFather"));
                        break block0;
                    }
                }
                throw new UnhandledRelationException("Relationship._CHILD [" + this.cardinality[0] + "," + this.cardinality[1] + "]");
            }
            case 1: {
                switch (ship) {
                    case 3: {
                        this.relationHandle = ship;
                        this.iconLabel.setIcon((Icon)FwkIconFile.getIcon((String)"Icon.RelFrom"));
                        break block0;
                    }
                    case 2: {
                        this.relationHandle = ship;
                        this.iconLabel.setIcon((Icon)FwkIconFile.getIcon((String)"Icon.RelTo"));
                        break block0;
                    }
                }
                throw new UnhandledRelationException();
            }
        }
    }

    public JLabel getTypeLabel() {
        return this.iconLabel;
    }

    public T_LONGLONG[] getSelectedIds() {
        return this.selector.getSelectedIds();
    }

    public ApplicationRelation getRelation() {
        return ((OdsxRelationEditorInterface)((Object)this.selector)).getRelation();
    }

    public ApplicationElement getApplicationElement() {
        return ((OdsxRelationEditorInterface)((Object)this.selector)).getApplicationElement();
    }

    public ApplicationElement getRelatedApplicationElement() {
        return ((OdsxRelationEditorInterface)((Object)this.selector)).getRelatedApplicationElement();
    }

    public InstanceElement getInstanceElement() {
        return ((OdsxRelationEditorInterface)((Object)this.selector)).getInstanceElement();
    }

    public boolean hasChanges() {
        return this.selector.hasChanges();
    }

    public void reset() {
        this.selector.reset();
    }

    public void applySettings() throws Exception {
        this.selector.applySettings();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.pack();
        frame.getContentPane().add(new Blinker());
        frame.setVisible(true);
    }

    public static class Blinker
    extends JLabel {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (Blinker.this.running) {
                    Blinker.this.setIcon(BALLS[Blinker.this.idx]);
                    Blinker.this.idx = (Blinker.this.idx + 1) % 2;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Throwable t) {
                        Blinker.this.running = false;
                    }
                }
            }
        });
        boolean running = true;
        int idx = 1;

        public Blinker() {
            super(BALLS[0]);
            this.thread.setPriority(10);
            this.addAncestorListener(new AncestorListener(){

                public void ancestorAdded(AncestorEvent event) {
                }

                public void ancestorMoved(AncestorEvent event) {
                }

                public void ancestorRemoved(AncestorEvent event) {
                    Blinker.this.running = false;
                }
            });
        }

        public void setVisible(boolean flag) {
            this.running = flag;
            if (flag) {
                this.thread.start();
            }
            super.setVisible(flag);
        }
    }
}

