/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.gui;

import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.interfaces.odsx.OdsxRelationEditorInterface;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxSelectHelper;
import com.highqsoft.odsx.gui.OdsxRelationEditor;
import com.highqsoft.odsx.gui.OdsxSelector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.asam.ods.AoException;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.T_LONGLONG;

public class OdsxSingleRelationEditor
extends JPanel
implements OdsxRelationEditorInterface,
OdsxSelector {
    int infoIdx;
    JPanel iconPanel;
    CardLayout iconLayout;
    JComboBox box;
    JCheckBox checker;
    InstanceElement infoIe;
    Thread thread;
    boolean enabled;
    boolean ready;
    ApplicationElement relAeObj;
    ApplicationElement aeObj;
    ApplicationRelation aeRel;
    InstanceElement ieObj;
    int relationHandle;
    JLabel iconLabel;

    public OdsxSingleRelationEditor(InstanceElement ieObj, ApplicationElement aeObj, ApplicationRelation aeRel, int relationHandle, JLabel iconLabel) throws AoException {
        super(new BorderLayout());
        this.ieObj = ieObj;
        this.aeObj = aeObj;
        this.aeRel = aeRel;
        this.relationHandle = relationHandle;
        this.iconLabel = iconLabel;
        this.iconLayout = new CardLayout();
        this.iconPanel = new JPanel(this.iconLayout);
        this.ready = false;
        this.enabled = false;
        this.infoIdx = -1;
        this.checker = new JCheckBox();
        this.checker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (OdsxSingleRelationEditor.this.ready) {
                    OdsxSingleRelationEditor.this.box.setEnabled(OdsxSingleRelationEditor.this.checker.isSelected());
                } else {
                    OdsxSingleRelationEditor.this.box.setEnabled(false);
                }
            }
        });
        this.checker.setSelected(this.enabled);
        JLabel blinker = new JLabel(OdsxRelationEditor.BALLS[1]);
        JButton loadButton = new JButton(OdsxRelationEditor.LOAD);
        loadButton.setToolTipText(FwkPropertyBus.getProperty((String)"OdsxRelationEditor.Text.Load"));
        loadButton.setBorder(null);
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                OdsxSingleRelationEditor.this.iconLayout.show(OdsxSingleRelationEditor.this.iconPanel, "BLINKER");
                OdsxSingleRelationEditor.this.thread.start();
            }
        });
        this.iconPanel.add((Component)this.checker, "CHECKER");
        this.iconPanel.add((Component)blinker, "BLINKER");
        this.iconPanel.add((Component)loadButton, "LOAD");
        this.iconLayout.show(this.iconPanel, "LOAD");
        this.add("West", this.iconPanel);
        T_LONGLONG aeId = aeObj.getId();
        this.relAeObj = aeRel.getElem1();
        T_LONGLONG infoId = this.relAeObj.getId();
        if (infoId.low == aeId.low && infoId.high == aeId.high) {
            this.relAeObj = aeRel.getElem2();
        }
        this.box = new JComboBox();
        this.box.setEnabled(this.enabled);
        this.add("Center", this.box);
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    InstanceElementIterator it;
                    OdsxSelectHelper.NameId[] ieArr = OdsxSelectHelper.getInstanceIds(OdsxSingleRelationEditor.this.relAeObj, "*", true);
                    int size = ieArr.length;
                    OdsxSingleRelationEditor.this.box.removeAllItems();
                    for (int i = 0; i < size; ++i) {
                        OdsxSingleRelationEditor.this.box.addItem(ieArr[i]);
                    }
                    if (OdsxSingleRelationEditor.this.ieObj != null && (it = OdsxSingleRelationEditor.this.ieObj.getRelatedInstances(OdsxSingleRelationEditor.this.aeRel, "*")).getCount() > 0) {
                        OdsxSingleRelationEditor.this.infoIe = it.nextOne();
                        it.destroy();
                        T_LONGLONG infoId = OdsxSingleRelationEditor.this.infoIe.getId();
                        for (int i = 0; i < size; ++i) {
                            if (infoId.low != ieArr[i].id.low || infoId.high != ieArr[i].id.high) continue;
                            OdsxSingleRelationEditor.this.infoIdx = i;
                        }
                        OdsxSingleRelationEditor.this.enabled = true;
                    }
                    OdsxSingleRelationEditor.this.ready = true;
                }
                catch (AoException aoe) {
                    System.err.println(OdsxHelper.aoExceptionToString(aoe));
                    aoe.printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                OdsxSingleRelationEditor.this.add("Center", OdsxSingleRelationEditor.this.box);
                OdsxSingleRelationEditor.this.box.setEnabled(OdsxSingleRelationEditor.this.enabled);
                OdsxSingleRelationEditor.this.checker.setSelected(OdsxSingleRelationEditor.this.enabled);
                if (OdsxSingleRelationEditor.this.infoIdx >= 0) {
                    OdsxSingleRelationEditor.this.box.setSelectedIndex(OdsxSingleRelationEditor.this.infoIdx);
                }
                OdsxSingleRelationEditor.this.iconLayout.show(OdsxSingleRelationEditor.this.iconPanel, "CHECKER");
                OdsxSingleRelationEditor.this.revalidate();
            }
        });
        this.thread.setPriority(1);
        this.iconLayout.show(this.iconPanel, "BLINKER");
        this.thread.start();
    }

    public boolean hasChanges() {
        return this.ready && (this.enabled != this.checker.isSelected() || this.infoIdx != this.box.getSelectedIndex());
    }

    public void reset() {
        if (this.ready) {
            this.checker.setSelected(this.enabled);
            if (this.infoIdx >= 0) {
                this.box.setSelectedIndex(this.infoIdx);
            } else {
                this.box.setSelectedIndex(0);
            }
            this.box.setEnabled(this.enabled);
        }
    }

    public T_LONGLONG[] getSelectedIds() {
        T_LONGLONG[] ret = new T_LONGLONG[]{};
        OdsxSelectHelper.NameId nameId = (OdsxSelectHelper.NameId)this.box.getSelectedItem();
        if (nameId != null) {
            ret = new T_LONGLONG[]{nameId.id};
        }
        return ret;
    }

    public void applySettings() throws Exception {
        if (this.hasChanges()) {
            if (this.checker.isSelected()) {
                T_LONGLONG[] ids = this.getSelectedIds();
                if (ids.length > 0) {
                    try {
                        if (this.infoIe != null) {
                            this.ieObj.removeRelation(this.aeRel, this.infoIe);
                        }
                        InstanceElement newInfo = this.relAeObj.getInstanceById(ids[0]);
                        this.ieObj.createRelation(this.aeRel, newInfo);
                        this.infoIe = newInfo;
                    }
                    catch (AoException aoe) {
                        throw new Exception(OdsxHelper.aoExceptionToString(aoe) + "[" + this.aeRel.getRelationName() + "]", aoe);
                    }
                }
            } else {
                try {
                    if (this.infoIe != null) {
                        this.ieObj.removeRelation(this.aeRel, this.infoIe);
                    }
                }
                catch (AoException aoe) {
                    throw new Exception(OdsxHelper.aoExceptionToString(aoe) + "[" + this.aeRel.getRelationName() + "]", aoe);
                }
            }
        }
    }

    public ApplicationElement getApplicationElement() {
        return this.aeObj;
    }

    public InstanceElement getInstanceElement() {
        return this.ieObj;
    }

    public ApplicationElement getRelatedApplicationElement() {
        return this.relAeObj;
    }

    public ApplicationRelation getRelation() {
        return this.aeRel;
    }

    public JLabel getTypeLabel() {
        return this.iconLabel;
    }
}

