/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hql;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkInfoBusConsumer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.odsx.hql.CommandInterface;
import com.highqsoft.odsx.hql.HQL;
import com.highqsoft.odsx.hql.OdsxResultSetInterface;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class Cmd
extends FwkInfoBusConsumer
implements CommandInterface {
    public static final String version = "$Revision: 1.3 $";
    protected FwkCommand fwkCommand = new FwkCommand();
    protected String[] params;
    protected FwkPropertyGroup keys;
    protected String commandString;
    protected long timeNeeded = 0L;
    protected OdsxResultSetInterface result;
    protected HQL hql;
    protected int streamOpened = 0;
    public static final int OPEN_OUT = 1;
    public static final int OPEN_ERR = 2;
    public static final int APPEND_OUT = 4;
    public static final int APPEND_ERR = 8;
    protected static int counter = 0;

    public String getVersion() {
        return version;
    }

    public Cmd() {
        super("com.highqsoft.odsx.hql.Cmd[" + counter++ + "]@" + FwkDataBus.BUSNAME, FwkContainer.getFwkMimeType((Class)OdsxResultSetInterface.class));
        String className = this.getClass().getName();
        int idx = className.lastIndexOf(46);
        this.commandString = className = className.substring(idx + 1, className.length());
        this.setTextKey("HQL.Text." + className);
        this.setIconKey("Icon." + className);
        this.setCommandName(className);
        this.setAuthor("Andreas Hofmann");
        this.setBuild(version);
        String prop = "HQL.Help." + className;
        String description = FwkPropertyBus.getProperty((String)prop, (String)null);
        if (description == null) {
            description = "There is no help available.\nPlease use the property " + prop + " to define the help text.";
        }
        this.setDescription(description);
        this.setHelpID(this.getClass().getName());
        this.hql = null;
        this.result = null;
        this.params = null;
    }

    public Cmd(FwkControllerInterface controller) {
        this();
        this.setController(controller);
    }

    public boolean parseParams(String pString) {
        this.commandString = this.getName() + " " + pString;
        this.keys = new FwkPropertyGroup();
        this.params = HQL.parseParams(pString, this.keys);
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i].equals(">")) {
                if (this.hql.openStream(">", this.params[i + 1])) {
                    this.streamOpened |= 1;
                }
                this.params[i + 1] = "";
                continue;
            }
            if (this.params[i].equals(">>")) {
                if (this.hql.openStream(">>", this.params[i + 1])) {
                    this.streamOpened |= 4;
                }
                this.params[i + 1] = "";
                continue;
            }
            if (this.params[i].equals("2>")) {
                if (this.hql.openStream("2>", this.params[i + 1])) {
                    this.streamOpened |= 2;
                }
                this.params[i + 1] = "";
                continue;
            }
            if (this.params[i].equals("2>>")) {
                if (this.hql.openStream("2>>", this.params[i + 1])) {
                    this.streamOpened |= 8;
                }
                this.params[i + 1] = "";
                continue;
            }
            if (this.params[i].equals("")) continue;
            vec.add(this.params[i]);
        }
        this.params = vec.toArray(new String[vec.size()]);
        this.result = null;
        return true;
    }

    public String commandString() {
        return this.commandString;
    }

    public void release() {
        if ((this.streamOpened & 1) != 0) {
            this.hql.closeStream(">");
            this.streamOpened &= 0xFFFFFFFE;
        }
        if ((this.streamOpened & 4) != 0) {
            this.hql.closeStream(">>");
            this.streamOpened &= 0xFFFFFFFB;
        }
        if ((this.streamOpened & 2) != 0) {
            this.hql.closeStream("2>");
            this.streamOpened &= 0xFFFFFFFD;
        }
        if ((this.streamOpened & 8) != 0) {
            this.hql.closeStream("2>>");
            this.streamOpened &= 0xFFFFFFF7;
        }
        if (this.result != null) {
            OdsxResultSetInterface tmp = this.result;
            this.result = null;
            tmp.release();
        }
    }

    public void setInterpreter(HQL hql) {
        this.hql = hql;
    }

    public boolean execute() {
        this.initializeExecution();
        return true;
    }

    public boolean initializeExecution() {
        boolean ret;
        boolean bl = ret = this.result != null;
        if (!ret) {
            this.timeNeeded = -1L * System.currentTimeMillis();
        }
        return ret;
    }

    public void terminateExecution() {
        if (this.timeNeeded < 0L) {
            this.timeNeeded = System.currentTimeMillis() + this.timeNeeded;
        }
    }

    public long timeNeeded() {
        return this.timeNeeded;
    }

    public synchronized boolean execute(EventObject ev) {
        return this.execute();
    }

    public void setText(String text) {
        this.fwkCommand.setText(text);
    }

    public String getText() {
        return this.fwkCommand.getText();
    }

    public void setTextKey(String textKey) {
        this.fwkCommand.setTextKey(textKey);
    }

    public String getTextKey() {
        return this.fwkCommand.getTextKey();
    }

    public void setCommandName(String commandName) {
        this.fwkCommand.setCommandName(commandName);
    }

    public String getCommandName() {
        return this.fwkCommand.getCommandName();
    }

    public void setMnemonic(int mnemonic) {
        this.fwkCommand.setMnemonic(mnemonic);
    }

    public Object getProperty(String key) {
        return this.fwkCommand.getProperty(key);
    }

    public Iterator getProperties() {
        return this.fwkCommand.getProperties();
    }

    public int getMnemonic() {
        return this.fwkCommand.getMnemonic();
    }

    public void setHelpID(String helpID) {
        this.fwkCommand.setHelpID(helpID);
    }

    public String getHelpID() {
        return this.fwkCommand.getHelpID();
    }

    public void setIconKey(String iconKey) {
        this.fwkCommand.setIconKey(iconKey);
    }

    public String getIconKey() {
        return this.fwkCommand.getIconKey();
    }

    public void setIcon(FwkIconInterface icon) {
        this.fwkCommand.setIcon(icon);
    }

    public FwkIconInterface getIcon() {
        return this.fwkCommand.getIcon();
    }

    public void setMenuEventEnabled(boolean flag) {
        this.fwkCommand.setMenuEventEnabled(flag);
    }

    public boolean getMenuEventEnabled() {
        return this.fwkCommand.getMenuEventEnabled();
    }

    public boolean menuSelect(MenuEvent event, int reason) {
        return this.menuSelect(event, reason);
    }

    public void setProperty(String key, Object value) {
        this.fwkCommand.setProperty(key, value);
    }

    public void setToolTipText(String toolTipText) {
        this.fwkCommand.setToolTipText(toolTipText);
    }

    public String getToolTipText() {
        return this.fwkCommand.getToolTipText();
    }

    public void setToolTipKey(String toolTipKey) {
        this.fwkCommand.setToolTipKey(toolTipKey);
    }

    public String getToolTipKey() {
        return this.fwkCommand.getToolTipText();
    }

    public boolean getVisibility() {
        return this.fwkCommand.getVisibility();
    }

    public void setVisibility(boolean flag) {
        this.fwkCommand.setVisibility(flag);
    }

    public boolean getSensitivity() {
        return this.fwkCommand.getSensitivity();
    }

    public void setSensitivity(boolean flag) {
        this.fwkCommand.setSensitivity(flag);
    }

    public boolean getSeparator() {
        return this.fwkCommand.getSeparator();
    }

    public void setSeparator(boolean flag) {
        this.fwkCommand.setSeparator(flag);
    }

    public boolean getToggle() {
        return this.fwkCommand.getToggle();
    }

    public void setToggle(boolean flag) {
        this.fwkCommand.setToggle(flag);
    }

    public boolean getToggleState() {
        return this.fwkCommand.getToggleState();
    }

    public void setToggleState(boolean flag) {
        this.fwkCommand.setToggleState(flag);
    }

    public boolean getRadioGroupState() {
        return this.fwkCommand.getRadioGroupState();
    }

    public void setRadioGroupState(boolean flag) {
        this.fwkCommand.setRadioGroupState(flag);
    }

    public void setToolBarEnabled(boolean flag) {
        this.fwkCommand.setToolBarEnabled(flag);
    }

    public boolean getToolBarEnabled() {
        return this.fwkCommand.getToolBarEnabled();
    }

    public void setAsParent() {
        this.fwkCommand.setAsParent();
    }

    public boolean isParent() {
        return this.fwkCommand.isParent();
    }

    public boolean hasActionListeners() {
        return this.fwkCommand.hasActionListeners();
    }

    public boolean hasMenuListeners() {
        return this.fwkCommand.hasMenuListeners();
    }

    public void register(Object obj) {
        this.fwkCommand.register(obj);
    }

    public void unregister(Object obj) {
        this.fwkCommand.unregister(obj);
    }

    public int registrySize() {
        return this.registrySize();
    }

    public Enumeration registeredObjects() {
        return this.registeredObjects();
    }

    public FwkArrayInterface getActionListenerArray() {
        return this.fwkCommand.getActionListenerArray();
    }

    public FwkArrayInterface getMenuListenerArray() {
        return this.fwkCommand.getMenuListenerArray();
    }

    public void addActionListener(ActionListener actionListener) {
        this.fwkCommand.addActionListener(actionListener);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.fwkCommand.addMenuListener(menuListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fwkCommand.removeActionListener(actionListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.fwkCommand.removeMenuListener(menuListener);
    }

    public void setButtonClass(Class clazz) {
        this.fwkCommand.setButtonClass(clazz);
    }

    public Class getButtonClass() {
        return this.fwkCommand.getButtonClass();
    }

    public void setMenuItemClass(Class clazz) {
        this.fwkCommand.setMenuItemClass(clazz);
    }

    public Class getMenuItemClass() {
        return this.fwkCommand.getMenuItemClass();
    }

    public OdsxResultSetInterface getResult() {
        return this.result;
    }
}

