/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hql;

import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.fwk.util.StringUtilities;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.OdsxApplicationElement;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxInstanceElement;
import com.highqsoft.odsx.OdsxPresentableElement;
import com.highqsoft.odsx.OdsxSessionElement;
import com.highqsoft.odsx.hql.Cmd;
import com.highqsoft.odsx.hql.CommandInterface;
import com.highqsoft.odsx.hql.OdsxResultSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.InstanceElement;
import org.asam.ods.T_LONGLONG;

public class CmdDescribe
extends Cmd {
    public static final String version = "$Revision: 1.3 $";
    public static final int DT_UNKNOWN = 0;
    public static final int DT_SESSION = 1;
    public static final int DT_COMMAND = 2;
    public static final HashMap table = new HashMap();
    String pattern;
    int type;
    protected static String help;

    public String getVersion() {
        return version;
    }

    public CmdDescribe() {
        this.setDescription(help);
        this.setCreationDate("$Date: 2005/07/01 09:46:02 $");
        this.setName("Describe");
    }

    public boolean parseParams(String par) {
        super.parseParams(par);
        this.type = 0;
        this.pattern = "*";
        if (this.params[0].toUpperCase().equals("SESSION")) {
            this.type = 1;
            if (this.params.length >= 2) {
                this.pattern = this.params[1];
            }
        } else if (this.params[0].toUpperCase().equals("COMMAND")) {
            this.type = 2;
            if (this.params.length >= 2) {
                this.pattern = this.params[1];
            }
        }
        return true;
    }

    public boolean execute() {
        super.execute();
        String resName = null;
        if (this.result == null) {
            Vector<String> col = new Vector<String>();
            switch (this.type) {
                case 2: {
                    resName = "Command " + this.pattern;
                    Enumeration enumeration = this.hql.getInterpreterCommands();
                    while (enumeration.hasMoreElements()) {
                        String key = (String)enumeration.nextElement();
                        if (!Pattern.match((String)key, (String)this.pattern, (boolean)true)) continue;
                        try {
                            FwkDescription cmd = (FwkDescription)this.hql.createCommand(key);
                            if (col.size() > 1) {
                                col.add(" ");
                                col.add("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                                col.add(" ");
                            }
                            col.add("Command: " + cmd.getName() + " " + cmd.getCopyright());
                            col.add("Author: " + cmd.getAuthor() + " " + cmd.getCompany());
                            col.add("Version: " + cmd.getVersion() + " " + cmd.getCreationDate());
                            col.add("support at: " + cmd.getSupportEMail());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    break;
                }
                case 1: {
                    resName = "Session " + this.pattern;
                    Iterator iterator = this.hql.listSessions();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        if (!Pattern.match((String)key, (String)this.pattern, (boolean)false)) continue;
                        OdsxSessionInterface session = this.hql.getSession(key);
                        OdsxSessionElement se = new OdsxSessionElement(session.getSession());
                        String val = se.getPresentationString(null, null);
                        String[] valArr = StringUtilities.split((String)val, (String)"\n", (boolean)false);
                        int size = valArr.length;
                        if (col.size() > 1) {
                            col.add(" ");
                            col.add("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                            col.add(" ");
                        }
                        for (int i = 0; i < size; ++i) {
                            col.add(valArr[i].replace('\t', ' '));
                        }
                        col.add(" ");
                        col.add("Authentication " + session.getAuthentication());
                        col.add("ServiceOptions " + session.getServiceOptions());
                        col.add("SessionOptions " + session.getSessionOptions());
                    }
                    break;
                }
                default: {
                    if (this.params.length > 0) {
                        this.describeSessionElement();
                        break;
                    }
                    resName = "describe ?";
                    if (OdsxHelper.deLang) {
                        col.add("Benutzen Sie das Kommando <help describe>, um mehr Information zu erhalten.");
                        break;
                    }
                    col.add("Use the command <help describe> to get more information about this command.");
                }
            }
            if (resName != null) {
                this.result = new OdsxResultSet(resName, (CommandInterface)this, col);
            }
        }
        this.terminateExecution();
        if (this.result != null) {
            this.hql.publishResultSet(this.result);
        }
        return true;
    }

    protected void describeSessionElement() {
        int size = this.params.length;
        StringBuffer title = new StringBuffer();
        if (size == 0) {
            return;
        }
        Vector using = (Vector)this.keys.get((Object)"USING");
        OdsxSessionInterface session = using == null ? this.hql.getLastUsedSession() : this.hql.getSession((String)using.get(0));
        ApplicationStructure asObj = null;
        try {
            asObj = session.getSession().getApplicationStructure();
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot load ApplicationStructure.");
        }
        Vector<OdsxPresentableElement> pElems = new Vector<OdsxPresentableElement>();
        Vector<String> col = new Vector<String>();
        if (asObj != null) {
            for (int i = 0; i < size; ++i) {
                String elem = this.params[i];
                if (i > 0) {
                    title.append(" / ").append(elem);
                } else {
                    title.append(elem);
                }
                InstanceElement ieObj = this.getInstance(asObj, elem);
                if (ieObj == null) {
                    ApplicationElement[] aeObj = this.getApplicationElement(asObj, elem);
                    if (aeObj == null || aeObj.length <= 0) continue;
                    int aeSize = aeObj.length;
                    for (int ae = 0; ae < aeSize; ++ae) {
                        pElems.add(new OdsxApplicationElement(aeObj[ae]));
                    }
                    continue;
                }
                try {
                    pElems.add(new OdsxInstanceElement(ieObj));
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        size = pElems.size();
        for (int i = 0; i < size; ++i) {
            OdsxPresentableElement item = (OdsxPresentableElement)pElems.get(i);
            if (item == null) continue;
            String[] arr = StringUtilities.split((String)item.getPresentationString(null, null), (String)"\n", (boolean)false);
            int len = arr.length;
            if (col.size() > 1) {
                col.add(" ");
                col.add("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                col.add(" ");
            }
            for (int j = 0; j < len; ++j) {
                col.add(arr[j].replace('\t', ' '));
            }
        }
        if (col.size() > 0) {
            this.result = new OdsxResultSet(title.toString(), (CommandInterface)this, col);
        }
    }

    protected InstanceElement getInstance(ApplicationStructure asObj, String pattern) {
        InstanceElement ret = null;
        try {
            ret = asObj.getInstanceByAsamPath(pattern);
        }
        catch (Throwable tIEPath) {
            // empty catch block
        }
        if (ret == null && pattern.toUpperCase().startsWith("IE.")) {
            ret = this.getInstance(asObj, pattern.substring(3, pattern.length()));
        }
        return ret;
    }

    protected ApplicationElement[] getApplicationElement(ApplicationStructure asObj, String pattern) {
        ApplicationElement[] ret = null;
        try {
            ret = new ApplicationElement[]{asObj.getElementByName(pattern)};
        }
        catch (Throwable tAEName) {
            try {
                ret = new ApplicationElement[]{asObj.getElementById(new T_LONGLONG(0, Integer.parseInt(pattern)))};
            }
            catch (Throwable tAEID) {
                // empty catch block
            }
        }
        if (ret == null) {
            if (pattern.toUpperCase().startsWith("AE.")) {
                ret = this.getApplicationElement(asObj, pattern.substring(3, pattern.length()));
            } else if (pattern.toUpperCase().startsWith("BE.")) {
                ret = this.getApplicationElementByBaseType(asObj, pattern.substring(3, pattern.length()));
            }
        }
        return ret;
    }

    protected ApplicationElement[] getApplicationElementByBaseType(ApplicationStructure asObj, String pattern) {
        ApplicationElement[] ret = null;
        try {
            ret = asObj.getElementsByBaseType(pattern);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return ret;
    }

    static {
        table.put("SESSION", new Integer(1));
        table.put("COMMAND", new Integer(2));
        help = FwkPropertyBus.getProperty((String)"HQL.Help.CmdDescribe", (String)null);
        if (help == null) {
            help = OdsxHelper.deLang ? "Session   | Zeigt die Session Parameter an.\nCommand   | Zeigt die Kommands an.\n" : "Session   | Display session parameters.\nCommand   | Display commands.";
        }
    }
}

