/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hql;

import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.interfaces.odsx.OdsxTableModelInterface;
import com.highqsoft.ods.AoService;
import com.highqsoft.ods.AoServiceFactory;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxTableHelper;
import com.highqsoft.odsx.hql.Cmd;
import com.highqsoft.odsx.hql.CommandInterface;
import com.highqsoft.odsx.hql.OdsxResultSet;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.asam.ods.AoException;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationStructure;

public class CmdList
extends Cmd {
    public static final String version = "$Revision: 1.4 $";
    public static final int LT_UNKNOWN = 0;
    public static final int LT_SERVICES = 1;
    public static final int LT_COMPONENTS = 2;
    public static final int LT_COMMANDS = 3;
    public static final int LT_SESSIONS = 4;
    public static final int LT_APPLICATIONELEMENT = 5;
    public static final HashMap table = new HashMap();
    boolean ordered = false;
    boolean ascending = true;
    String pattern;
    int type;
    protected static String help;

    public String getVersion() {
        return version;
    }

    public CmdList() {
        this.setDescription(help);
        this.setCreationDate("$Date: 2005/07/01 09:46:02 $");
        this.setName("List");
    }

    public boolean parseParams(String par) {
        super.parseParams(par);
        this.ordered = false;
        this.ascending = true;
        this.type = 0;
        this.pattern = (String)this.keys.get((Object)"PATTERN");
        if (this.pattern == null) {
            this.pattern = "*";
        }
        if (this.keys.get((Object)"ASC") != null) {
            this.ordered = true;
            this.ascending = true;
        } else if (this.keys.get((Object)"DESC") != null) {
            this.ordered = true;
            this.ascending = false;
        }
        if (this.params != null && this.params.length != 0) {
            int size = this.params.length;
            for (int i = 0; i < size; ++i) {
                String tok = this.params[i].trim();
                String upper = tok.toUpperCase();
                if (i <= 1 && upper.startsWith("SER")) {
                    this.type = 1;
                    continue;
                }
                if (i <= 1 && upper.startsWith("COMP")) {
                    this.type = 2;
                    continue;
                }
                if (i <= 1 && upper.startsWith("SES")) {
                    this.type = 4;
                    continue;
                }
                if (i <= 1 && upper.startsWith("COMM")) {
                    this.type = 3;
                    continue;
                }
                if (i <= 1 && upper.startsWith("APP")) {
                    this.type = 5;
                    if (this.params.length - 1 <= i) continue;
                    this.pattern = this.params[i + 1];
                    continue;
                }
                if (i != 0) continue;
                if ("SERVICES".startsWith(upper)) {
                    this.type = 1;
                    continue;
                }
                if ("COMPONENTS".startsWith(upper)) {
                    this.type = 2;
                    continue;
                }
                if ("COMMANDS".startsWith(upper)) {
                    this.type = 3;
                    continue;
                }
                if (!"APPLICATIONELEMENT".startsWith(upper)) continue;
                this.type = 5;
            }
        }
        this.result = null;
        return true;
    }

    public boolean execute() {
        super.execute();
        if (this.result == null) {
            String key;
            Iterator it = this.keys.keySet().iterator();
            String opt = "";
            if (it.hasNext()) {
                key = (String)it.next();
                opt = key + "=" + this.keys.get((Object)key);
            }
            while (it.hasNext()) {
                key = (String)it.next();
                opt = ", " + key + "=" + this.keys.get((Object)key);
            }
            String resName = null;
            Vector<Object> col = new Vector<Object>();
            switch (this.type) {
                case 1: {
                    resName = "Services";
                    try {
                        AoService aoService = AoServiceFactory.newService((String)"com.highqsoft.ods.athos.AoService", (String)opt);
                        String[] list = aoService.listServices(this.pattern);
                        for (int i = 0; i < list.length; ++i) {
                            col.add(list[i]);
                        }
                        break;
                    }
                    catch (Throwable t) {
                        break;
                    }
                }
                case 2: {
                    resName = "Components";
                    try {
                        String[] plumNames = AoServiceFactory.listPlugableComponents();
                        for (int i = 0; i < plumNames.length; ++i) {
                            col.add(plumNames[i]);
                        }
                        break;
                    }
                    catch (Throwable t) {
                        break;
                    }
                }
                case 3: {
                    resName = "Commands";
                    Enumeration enumeration = this.hql.getInterpreterCommands();
                    while (enumeration.hasMoreElements()) {
                        key = enumeration.nextElement().toString();
                        if (!Pattern.match((String)key, (String)this.pattern, (boolean)false)) continue;
                        col.add(key);
                    }
                    break;
                }
                case 4: {
                    resName = "Sessions";
                    Iterator iterator = this.hql.listSessions();
                    while (iterator.hasNext()) {
                        key = (String)iterator.next();
                        if (!Pattern.match((String)key, (String)this.pattern, (boolean)false)) continue;
                        col.add(key);
                    }
                    break;
                }
                case 5: {
                    resName = "ApplicationElement";
                    try {
                        OdsxSessionInterface session = this.hql.getLastUsedSession();
                        ApplicationStructure asObj = session.getSession().getApplicationStructure();
                        ApplicationElement[] aeObj = this.pattern.toUpperCase().startsWith("BE.") ? asObj.getElementsByBaseType(this.pattern.substring(3, this.pattern.length())) : asObj.getElements(this.pattern);
                        for (int i = 0; i < aeObj.length; ++i) {
                            col.add("InstanceElements of ApplicationElement " + aeObj[i].getName());
                            OdsxTableModelInterface model = OdsxTableHelper.createApplicationElementTable(aeObj[i], true);
                            String[] arr = model.toString().split("\n");
                            for (int s = 0; s < arr.length; ++s) {
                                col.add(arr[s]);
                            }
                        }
                        break;
                    }
                    catch (AoException aoe) {
                        col.add(aoe.reason);
                        break;
                    }
                    catch (Throwable t) {
                        col.add(t.getClass().getName());
                        col.add(t.getMessage());
                        break;
                    }
                }
                default: {
                    resName = "List ?";
                    if (OdsxHelper.deLang) {
                        col.add("Benutzen Sie das Kommando <help list>, um mehr Information zu erhalten.");
                        break;
                    }
                    col.add("Use the command <help list> to get more information about this command.");
                }
            }
            if (resName != null) {
                if (this.ordered) {
                    if (col.size() > 0) {
                        int size = col.size();
                        Object[] arr = col.toArray(new String[col.size()]);
                        Arrays.sort(arr);
                        if (this.ascending) {
                            this.result = new OdsxResultSet(resName, (CommandInterface)this, (String[])arr);
                        } else {
                            int count = 0;
                            for (int i = size - 1; i >= 0; --i) {
                                col.set(count++, arr[i]);
                            }
                            this.result = new OdsxResultSet(resName, (CommandInterface)this, col);
                        }
                    } else {
                        this.result = new OdsxResultSet(resName, (CommandInterface)this, (String[])null);
                    }
                } else {
                    this.result = new OdsxResultSet(resName, (CommandInterface)this, col);
                }
            }
        }
        this.terminateExecution();
        if (this.result != null) {
            this.hql.publishResultSet(this.result);
        }
        return true;
    }

    static {
        table.put("SERVICES", new Integer(1));
        table.put("SESSIONS", new Integer(4));
        table.put("COMPONENTS", new Integer(2));
        table.put("COMMANDS", new Integer(3));
        table.put("APPLICATIONELEMENT", new Integer(5));
        help = FwkPropertyBus.getProperty((String)"HQL.Help.CmdList", (String)null);
        if (help == null) {
            StringBuffer buf = new StringBuffer();
            if (OdsxHelper.deLang) {
                buf.append("Sessions             | Listet alle ge\u00f6ffneten ODS Sessions\n");
                buf.append("                     | Als zus\u00e4tzlichen Parameter kann ein casesensitiver Wildcard-Pattern angegeben werden.\n");
                buf.append("Services             | Listet alle zur Verf\u00fcgung stehenden ODS Services\n");
                buf.append("                     | Als zus\u00e4tzlichen Parameter kann ein casesensitiver Wildcard-Pattern angegeben werden.\n");
                buf.append("Components           | Listet alle zur Verf\u00fcgung stehenden Service Komponenten\n");
                buf.append("                     | Als zus\u00e4tzlichen Parameter kann ein casesensitiver Wildcard-Pattern angegeben werden.\n");
                buf.append("Commands             | Listet alle zur Verf\u00fcgung stehenden Interpreter Befehle\n");
                buf.append("                     | Als zus\u00e4tzlichen Parameter kann ein casesensitiver Wildcard-Pattern angegeben werden.\n");
                buf.append("ApplicationElement   | Listet alle zum ApplicationsElement geh\u00f6rigen Instance auf.\n");
                buf.append("                     | Als zus\u00e4tzlichen Parameter wird der Name eines ApplicationsElementes erwartet.\n");
                buf.append("ASC                  | Als aufsteigende Liste ausgeben(default).\n");
                buf.append("DES                  | Als absteigende Liste ausgeben.\n");
                buf.append("Beispiel             | list [asc,des] services [*ATF*];");
            } else {
                buf.append("Services             | Lists all available ODS services\n");
                buf.append("                     | It is possible to specify an additional casesensitive wildcard pattern.\n");
                buf.append("Components           | Lists all available plugable components\n");
                buf.append("                     | It is possible to specify an additional casesensitive wildcard pattern.\n");
                buf.append("Commands             | Lists all available interpreter commands\n");
                buf.append("                     | It is possible to specify an additional casesensitive wildcard pattern.\n");
                buf.append("ApplicationElement   | Lists all Instances belong to the given ApplicationElement.\n");
                buf.append("                     | The name of the application element is required as addionally parameter.\n");
                buf.append("ASC                  | List as ascending list(default).\n");
                buf.append("DES                  | List as descending list.\n");
                buf.append("Example              | list [asc,des] services [*ATF*];");
            }
            help = buf.toString();
        }
    }
}

