/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hql;

import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.fwk.util.StringUtilities;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.hql.Cmd;
import com.highqsoft.odsx.hql.CommandInterface;
import com.highqsoft.odsx.hql.OdsxResultSet;
import com.highqsoft.odsx.hql.OdsxResultSetInterface;
import com.highqsoft.odsx.hql.ResultColumn;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.asam.ods.AIDName;
import org.asam.ods.AIDNameUnitId;
import org.asam.ods.AIDNameValueUnitId;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplElemAccess;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.BaseAttribute;
import org.asam.ods.BaseElement;
import org.asam.ods.DataType;
import org.asam.ods.ElemId;
import org.asam.ods.ElemResultSet;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.NameValueUnit;
import org.asam.ods.QueryStructure;
import org.asam.ods.SelOpcode;
import org.asam.ods.SelOperator;
import org.asam.ods.SelOrder;
import org.asam.ods.SelValue;
import org.asam.ods.TS_Union;
import org.asam.ods.TS_UnionSeq;
import org.asam.ods.TS_Value;
import org.asam.ods.T_COMPLEX;
import org.asam.ods.T_DCOMPLEX;
import org.asam.ods.T_LONGLONG;

public class CmdSelect
extends Cmd {
    public static final String version = "$Revision: 1.10 $";
    public static final String SELECT = "SELECT";
    public static final String FROM = "FROM";
    public static final String WHERE = "WHERE";
    public static final String USING = "USING";
    public static final String REFTO = "REFTO";
    protected static final String BRACES = "(){}";
    protected static final String OPENBRACES = "({[";
    protected static final String CLOSEBRACES = ")}]";
    protected static final String OPERATORS = "<>=!&|";
    protected static final HashMap operatorList = new HashMap();
    protected static final HashMap operatorInvList = new HashMap();
    protected static final String DELIMITER = " \t\n\r'\",";
    protected static String help;
    protected String lastToken;
    protected String upperToken;

    public String getVersion() {
        return version;
    }

    public CmdSelect() {
        this.setDescription(help);
        this.setCreationDate("$Date: 2007/06/28 06:50:10 $");
        this.setName("Select");
    }

    protected String getToken(StringTokenizer st) {
        this.lastToken = st.nextToken();
        this.upperToken = this.lastToken.toUpperCase();
        return this.lastToken;
    }

    public FwkPropertyGroup parse(String statement) {
        FwkPropertyGroup ret = new FwkPropertyGroup();
        StringTokenizer st = new StringTokenizer(statement, " \t\n\r'\",<>=!&|(){}", true);
        while (st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (!this.upperToken.equals(SELECT)) continue;
            this.parseSelect(st, ret);
        }
        return ret;
    }

    protected void parseSelect(StringTokenizer st, FwkPropertyGroup map) {
        Vector<String> ret = new Vector<String>();
        while (st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (this.upperToken.equals(FROM)) {
                this.parseFrom(st, map);
                continue;
            }
            if (this.upperToken.equals(WHERE)) {
                this.parseWhere(st, map);
                continue;
            }
            if (this.upperToken.equals(REFTO)) {
                this.parseRefTo(st, map);
                continue;
            }
            if (this.upperToken.equals(USING)) {
                this.parseUsing(st, map);
                continue;
            }
            if (this.lastToken.charAt(0) == '\'' || this.lastToken.charAt(0) == '\"') {
                ret.add(this.parseString(st));
                continue;
            }
            if (DELIMITER.indexOf(this.lastToken) >= 0 || BRACES.indexOf(this.lastToken) >= 0) continue;
            ret.add(this.lastToken);
        }
        if (ret.size() > 0) {
            map.put((Object)SELECT, ret);
        }
    }

    protected void parseFrom(StringTokenizer st, FwkPropertyGroup map) {
        Vector<String> ret = new Vector<String>();
        while (st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (this.upperToken.equals(WHERE)) {
                this.parseWhere(st, map);
                continue;
            }
            if (this.upperToken.equals(REFTO)) {
                this.parseRefTo(st, map);
                continue;
            }
            if (this.upperToken.equals(USING)) {
                this.parseUsing(st, map);
                continue;
            }
            if (this.lastToken.charAt(0) == '\'' || this.lastToken.charAt(0) == '\"') {
                ret.add(this.parseString(st));
                continue;
            }
            if (this.upperToken.equals(">") || this.upperToken.equals("2>") || this.upperToken.equals(">>") || this.upperToken.equals("2>>")) {
                if (ret.size() > 0 && ret.get(ret.size() - 1).equals("2")) {
                    ret.remove(ret.size() - 1);
                    this.parseStream(st, "2" + this.upperToken, map);
                    continue;
                }
                if (ret.size() > 0 && ret.get(ret.size() - 1).equals("1")) {
                    ret.remove(ret.size() - 1);
                    this.parseStream(st, this.upperToken, map);
                    continue;
                }
                this.parseStream(st, this.upperToken, map);
                continue;
            }
            if (DELIMITER.indexOf(this.lastToken) >= 0 || BRACES.indexOf(this.lastToken) >= 0) continue;
            ret.add(this.lastToken);
        }
        if (ret.size() > 0) {
            map.put((Object)FROM, ret);
        }
    }

    protected void parseUsing(StringTokenizer st, FwkPropertyGroup map) {
        Vector<String> ret = new Vector<String>();
        while (st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (this.upperToken.equals(WHERE)) {
                this.parseWhere(st, map);
                continue;
            }
            if (this.upperToken.equals(">") || this.upperToken.equals("2>") || this.upperToken.equals(">>") || this.upperToken.equals("2>>")) {
                if (ret.size() > 0 && ret.get(ret.size() - 1).equals("2")) {
                    ret.remove(ret.size() - 1);
                    this.parseStream(st, "2" + this.upperToken, map);
                    continue;
                }
                if (ret.size() > 0 && ret.get(ret.size() - 1).equals("1")) {
                    ret.remove(ret.size() - 1);
                    this.parseStream(st, this.upperToken, map);
                    continue;
                }
                this.parseStream(st, this.upperToken, map);
                continue;
            }
            if (this.lastToken.charAt(0) == '\'' || this.lastToken.charAt(0) == '\"') {
                ret.add(this.parseString(st));
                continue;
            }
            if (DELIMITER.indexOf(this.lastToken) >= 0 || BRACES.indexOf(this.lastToken) >= 0) continue;
            ret.add(this.lastToken);
        }
        if (ret.size() > 0) {
            map.put((Object)USING, ret);
        }
    }

    protected void parseRefTo(StringTokenizer st, FwkPropertyGroup map) {
        Vector<String> ret = new Vector<String>();
        while (st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            char firstChar = this.lastToken.charAt(0);
            if (this.upperToken.equals(WHERE)) {
                this.parseWhere(st, map);
                continue;
            }
            if (this.upperToken.equals(USING)) {
                this.parseUsing(st, map);
                continue;
            }
            if (firstChar == '\'' || firstChar == '\"') {
                ret.add(this.parseString(st));
                continue;
            }
            if (OPENBRACES.indexOf(this.lastToken.charAt(0)) >= 0) {
                ret.add(this.parseBraces(st));
                continue;
            }
            if (this.upperToken.equals(">") || this.upperToken.equals("2>") || this.upperToken.equals(">>") || this.upperToken.equals("2>>")) {
                if (ret.size() > 0 && ret.get(ret.size() - 1).equals("2")) {
                    ret.remove(ret.size() - 1);
                    this.parseStream(st, "2" + this.upperToken, map);
                    continue;
                }
                if (ret.size() > 0 && ret.get(ret.size() - 1).equals("1")) {
                    ret.remove(ret.size() - 1);
                    this.parseStream(st, this.upperToken, map);
                    continue;
                }
                this.parseStream(st, this.upperToken, map);
                continue;
            }
            if (DELIMITER.indexOf(this.lastToken) >= 0 || BRACES.indexOf(this.lastToken) >= 0) continue;
            ret.add(this.lastToken);
        }
        if (ret.size() > 0) {
            map.put((Object)REFTO, ret);
        }
    }

    protected void parseStream(StringTokenizer st, String key, FwkPropertyGroup map) {
        Vector<String> ret = new Vector<String>();
        boolean stop = false;
        while (!stop && st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (Character.isWhitespace(this.lastToken.charAt(0))) continue;
            if (this.lastToken.charAt(0) == '\'' || this.lastToken.charAt(0) == '\"') {
                ret.add(this.parseString(st));
                continue;
            }
            if (this.lastToken.charAt(0) != '>' && this.lastToken.charAt(0) != '|') {
                ret.add(this.lastToken);
                stop = true;
                continue;
            }
            key = key + this.lastToken;
        }
        if (ret.size() > 0) {
            map.put((Object)key, ret);
        } else {
            this.hql.err.println("output stream missing.");
        }
    }

    protected void parseWhere(StringTokenizer st, FwkPropertyGroup map) {
        Vector ret = this.parseConditions(st);
        if (ret.size() > 0) {
            String val = (String)ret.get(ret.size() - 2);
            if (val.compareToIgnoreCase(USING) == 0) {
                Vector using = new Vector();
                using.add(ret.get(ret.size() - 1));
                map.put((Object)USING, using);
                ret.remove(ret.size() - 1);
                ret.remove(ret.size() - 1);
            }
            map.put((Object)WHERE, (Object)ret);
        }
    }

    public Vector parseConditions(StringTokenizer st) {
        Vector<Object> ret = new Vector<Object>();
        int openbrace = 0;
        int startChar = 32;
        if (this.lastToken.charAt(0) == '(') {
            openbrace = 1;
        }
        block12: while (st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (this.lastToken.charAt(0) == '\'' || this.lastToken.charAt(0) == '\"') {
                ret.add(this.parseString(st));
                continue;
            }
            if (this.lastToken.length() == 1) {
                if (DELIMITER.indexOf(this.lastToken) >= 0) continue;
                switch (this.lastToken.charAt(0)) {
                    case '{': {
                        if (ret.size() != 0) continue block12;
                        startChar = 123;
                        continue block12;
                    }
                    case '}': {
                        if (startChar != 123) continue block12;
                        if (openbrace != 0) {
                            if (openbrace > 0) {
                                throw new RuntimeException("Error: Too much open braces in where clause.");
                            }
                            throw new RuntimeException("Error: Too much close braces in where clause.");
                        }
                        return ret;
                    }
                    case '(': {
                        ret.add(this.parseConditions(st));
                        continue block12;
                    }
                    case ')': {
                        if (--openbrace != 0) {
                            if (openbrace > 0) {
                                throw new RuntimeException("Error: Too much open braces in where clause.");
                            }
                            throw new RuntimeException("Error: Too much close braces in where clause.");
                        }
                        return ret;
                    }
                    case '&': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block12;
                    }
                    case '|': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block12;
                    }
                    case '<': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block12;
                    }
                    case '>': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block12;
                    }
                    case '=': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block12;
                    }
                    case '!': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block12;
                    }
                }
                ret.add(this.lastToken);
                continue;
            }
            if (this.upperToken.equals("IN")) {
                if (ret.size() > 0) {
                    String s = (String)ret.get(ret.size() - 1);
                    if (s.equals("!")) {
                        ret.set(ret.size() - 1, "!IN");
                        continue;
                    }
                    ret.add("IN");
                    continue;
                }
                ret.add("IN");
                continue;
            }
            ret.add(this.lastToken);
        }
        if (openbrace != 0) {
            if (openbrace > 0) {
                throw new RuntimeException("Error: Too much open braces in where clause.");
            }
            throw new RuntimeException("Error: Too much close braces in where clause.");
        }
        return ret;
    }

    protected String parseString(StringTokenizer st) {
        StringBuffer ret = new StringBuffer();
        char startToken = this.lastToken.charAt(0);
        boolean stop = false;
        while (!stop && st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (this.lastToken.charAt(0) != startToken) {
                ret = ret.append(this.lastToken);
                continue;
            }
            if (ret.length() > 0) {
                if (ret.charAt(ret.length() - 1) != '\\') {
                    stop = true;
                    continue;
                }
                ret = ret.replace(ret.length() - 1, ret.length(), this.lastToken);
                continue;
            }
            stop = true;
        }
        return ret.toString();
    }

    protected String parseBraces(StringTokenizer st) {
        boolean stop;
        StringBuffer ret = new StringBuffer();
        char startToken = this.lastToken.charAt(0);
        int idx = OPENBRACES.indexOf(startToken);
        char stopToken = CLOSEBRACES.charAt(idx);
        boolean bl = stop = stopToken == '\u0000';
        while (!stop && st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            stop = this.lastToken.charAt(0) == stopToken;
            if (stop) continue;
            idx = OPENBRACES.indexOf(this.lastToken.charAt(0));
            if (idx >= 0) {
                ret.append(OPENBRACES.charAt(idx));
                ret.append(this.parseBraces(st));
                ret.append(CLOSEBRACES.charAt(idx));
                continue;
            }
            ret = ret.append(this.lastToken);
        }
        return ret.toString();
    }

    public boolean handleParsedOperator(Vector vec, String upperToken) {
        boolean ret = false;
        if (vec.size() > 0) {
            if (vec.get(vec.size() - 1) instanceof String) {
                String s = (String)vec.get(vec.size() - 1);
                if ((s = s + upperToken).equals(">=") || s.equals("<=") || s.equals("==") || s.equals("!=") || s.equals("&&") || s.equals("!IN") || s.equals("||")) {
                    vec.set(vec.size() - 1, s);
                    ret = true;
                } else {
                    vec.add(upperToken);
                    ret = true;
                }
            } else {
                vec.add(upperToken);
                ret = true;
            }
        } else {
            vec.add(upperToken);
            ret = true;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QueryStructure getQueryStructure(AoSession session, FwkPropertyGroup map) throws AoException {
        ApplicationStructure asObj;
        try {
            asObj = session.getApplicationStructure();
        }
        catch (Throwable tas) {
            throw new RuntimeException("Cannot retrieve the ODS session.");
        }
        Vector from = (Vector)map.get((Object)FROM);
        if (from == null) {
            throw new RuntimeException("ERROR: From clause missing.");
        }
        int size = from.size();
        if (size > 1) {
            throw new RuntimeException("WARNING: Selection from more than one element is currently not supported.");
        }
        String element = (String)from.get(0);
        String upper = element.toUpperCase();
        ApplicationElement[] aeObj = null;
        InstanceElement[] ieObj = null;
        if (upper.startsWith("IE.")) {
            String ieName;
            String spec = element.substring(3, element.length());
            String aeName = StringUtilities.substring((String)StringUtilities.substring((String)spec, (char)']', (int)-1), (char)'[', (int)1);
            aeObj = this.getApplicationElements(asObj, aeName);
            InstanceElement ie = aeObj[0].getInstanceByName(ieName = StringUtilities.substring((String)element, (char)']', (int)1));
            if (ie == null) {
                String name = StringUtilities.substring((String)ieName, (char)';', (int)-1);
                String version = ieName.substring(name.length() + 1);
                InstanceElementIterator ii = aeObj[0].getInstances(name);
                int count = ii.getCount();
                if (count == 1) {
                    ieObj = new InstanceElement[]{ii.nextOne()};
                } else {
                    ApplicationAttribute aaVersion = aeObj[0].getAttributeByBaseName("version");
                    Vector<InstanceElement> ieVec = new Vector<InstanceElement>();
                    for (int i = 0; i < count; ++i) {
                        ie = ii.nextOne();
                        NameValueUnit nvu = ie.getValue(aaVersion.getName());
                        if (!Pattern.match((String)OdsxHelper.ts_valueToString(nvu.value), (String)version, (boolean)false)) continue;
                        ieVec.add(ie);
                    }
                    if (ieVec.size() > 0) {
                        ieObj = ieVec.toArray(new InstanceElement[ieVec.size()]);
                    }
                }
                ii.destroy();
            } else {
                ieObj = new InstanceElement[]{ie};
            }
            if (ieObj == null) {
                throw new RuntimeException("ERROR: Instance element <" + element + "> not found.");
            }
            aeObj = null;
        } else {
            aeObj = this.getApplicationElements(asObj, element);
        }
        if (ieObj != null) {
            throw new RuntimeException("Instance selection is currently not supported.");
        }
        if (aeObj != null && aeObj.length > 1) {
            throw new RuntimeException("Multi application element selection is currently not supported.");
        }
        if (aeObj == null) {
            throw new RuntimeException("ERROR: ApplicationElement " + element + " not found.");
        }
        Vector select = (Vector)map.get((Object)SELECT);
        QueryStructure ret = new QueryStructure();
        ret.relInst = new ElemId();
        ret.relName = "";
        ret.relInst.aid = new T_LONGLONG();
        ret.relInst.iid = new T_LONGLONG();
        Vector refTo = (Vector)map.get((Object)REFTO);
        if (refTo != null) {
            if (refTo.size() == 0) {
                throw new RuntimeException("ERROR: RefTo clause missing.");
            }
            if (refTo.size() == 2) {
                try {
                    ret.relInst.aid = OdsxHelper.parseLongLong(refTo.get(0).toString());
                    ret.relInst.iid = OdsxHelper.parseLongLong(refTo.get(1).toString());
                }
                catch (Throwable tparseInt) {
                    throw new RuntimeException("ERROR: Parsing RefTo clause.");
                }
            }
            if (refTo.size() != 1) throw new RuntimeException("ERROR: RefTo clause currently supports aeId and ieId only.");
            String[] arr = refTo.get(0).toString().split(",");
            if (arr.length != 2) throw new RuntimeException("ERROR: RefTo clause currently supports aeId and ieId only.");
            try {
                ret.relInst.aid = OdsxHelper.parseLongLong(arr[0].trim());
                ret.relInst.iid = OdsxHelper.parseLongLong(arr[1].trim());
            }
            catch (Throwable tparseInt) {
                throw new RuntimeException("ERROR: Parsing RefTo clause.");
            }
        }
        ret.orderBy = new SelOrder[0];
        if (select == null || select.size() == 0) {
            ret.anuSeq = new AIDNameUnitId[1];
            ret.anuSeq[0] = new AIDNameUnitId();
            ret.anuSeq[0].attr = new AIDName();
            ret.anuSeq[0].attr.aid = aeObj[0].getId();
            ret.anuSeq[0].attr.aaName = aeObj[0].getAttributeByBaseName("id").getName();
            ret.anuSeq[0].unitId = new T_LONGLONG();
        } else {
            ret.anuSeq = this.getAIDNameUnitId(aeObj, select);
        }
        Vector where = (Vector)map.get((Object)WHERE);
        if (where != null && where.size() != 0) {
            Vector selOp = new Vector();
            Vector selValues = this.getSelValue(aeObj, where, null, selOp);
            if (selValues != null && selValues.size() != 0) {
                ret.condSeq = selValues.toArray(new SelValue[selValues.size()]);
            }
            if (selOp == null || selOp.size() == 0) return ret;
            ret.operSeq = selOp.toArray(new SelOperator[selOp.size()]);
            return ret;
        } else {
            ret.condSeq = new SelValue[0];
            ret.operSeq = new SelOperator[0];
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Vector getSelValue(ApplicationElement[] aeObj, Vector where, Vector selVal, Vector selOp) {
        block22: {
            block21: {
                int size;
                block23: {
                    if (selVal == null) {
                        selVal = new Vector();
                    }
                    if ((size = where.size()) <= 0) break block22;
                    selOp.add(operatorList.get("("));
                    if (!(where.get(0) instanceof String)) break block23;
                    if (size == 3) {
                        String val;
                        String field = (String)where.get(0);
                        String op = ((String)where.get(1)).toUpperCase();
                        Object o = where.get(2);
                        if (o instanceof String) {
                            val = (String)o;
                        } else {
                            if (!(o instanceof Collection)) {
                                throw new RuntimeException("ERROR(4): Syntax error in where clause. " + o.getClass().getName() + ": " + o.toString());
                            }
                            Collection c = (Collection)o;
                            Iterator it = c.iterator();
                            StringBuffer b = new StringBuffer("[");
                            if (it.hasNext()) {
                                b.append(it.next().toString());
                            }
                            while (it.hasNext()) {
                                b.append(", ").append(it.next().toString());
                            }
                            val = b.toString();
                        }
                        if (operatorList.get(op) == null) {
                            throw new RuntimeException("ERROR(2): Syntax error in where clause.");
                        }
                        SelValue s = this.getSelValue(aeObj, field, op, val);
                        if (s != null) {
                            selVal.add(s);
                        }
                        break block21;
                    } else if (size > 3) {
                        Vector vec = new Vector();
                        String op = ((String)where.get(3)).toUpperCase();
                        if (operatorList.get(op) != null) {
                            for (int i = 0; i < 3; ++i) {
                                vec.add(where.get(0));
                                where.remove(0);
                            }
                            selOp.add(operatorList.get(where.get(0)));
                            where.remove(0);
                            String field = (String)vec.get(0);
                            op = ((String)vec.get(1)).toUpperCase();
                            String val = (String)vec.get(2);
                            if (operatorList.get(op) == null) {
                                throw new RuntimeException("ERROR(2.2) in getVecValue: Syntax error in where clause.");
                            }
                            SelValue s = this.getSelValue(aeObj, field, op, val);
                            if (s != null) {
                                selVal.add(s);
                            }
                        }
                        selVal = this.getSelValue(aeObj, where, selVal, selOp);
                        break block21;
                    } else {
                        StringBuffer buf = new StringBuffer();
                        int xxx = 0;
                        while (true) {
                            if (xxx >= size) {
                                throw new RuntimeException("ERROR(4): Syntax error in where clause. " + buf.toString());
                            }
                            buf.append(where.get(xxx)).append(" ");
                            ++xxx;
                        }
                    }
                }
                Object elem = where.get(0);
                if (size > 1) {
                    this.getSelValue(aeObj, (Vector)elem, selVal, selOp);
                    where.remove(0);
                    String op = ((String)where.get(0)).toUpperCase();
                    if (operatorList.get(op) != null) {
                        selOp.add(operatorList.get(where.get(0)));
                        where.remove(0);
                    }
                    this.getSelValue(aeObj, where, selVal, selOp);
                } else {
                    this.getSelValue(aeObj, (Vector)elem, selVal, selOp);
                }
            }
            selOp.add(operatorList.get(")"));
        }
        return selVal;
    }

    protected SelValue getSelValue(ApplicationElement[] aeObj, String field, String op, String val) {
        SelValue ret;
        block12: {
            ret = null;
            try {
                SelOpcode opCode = (SelOpcode)operatorList.get(op.toUpperCase());
                if (opCode != null) {
                    ApplicationRelation[][] arrr;
                    int j;
                    int i;
                    AIDNameValueUnitId nvu = new AIDNameValueUnitId();
                    nvu.attr = new AIDName();
                    nvu.unitId = new T_LONGLONG();
                    nvu.values = new TS_Value();
                    nvu.values.u = new TS_Union();
                    nvu.values.u.longVal(0);
                    TS_Union u = null;
                    ApplicationAttribute[][] aarr = this.getAttributes(aeObj, field);
                    if (aarr != null) {
                        ApplicationAttribute aa = null;
                        int aeIndex = -1;
                        for (i = 0; aa == null && i < aarr.length; ++i) {
                            if (aarr[i] == null) continue;
                            for (j = 0; aa == null && j < aarr[i].length; ++j) {
                                aa = aarr[i][j];
                                aeIndex = i;
                            }
                        }
                        if (aa != null) {
                            nvu.attr.aid = aeObj[aeIndex].getId();
                            nvu.attr.aaName = aa.getName();
                            u = op.indexOf("IN") >= 0 ? OdsxHelper.parseTS_Union(OdsxHelper.DT2DS(aa.getDataType()), val) : OdsxHelper.parseTS_Union(aa.getDataType(), val);
                        }
                    }
                    if (u == null && (arrr = this.getRelations(aeObj, field)) != null) {
                        ApplicationRelation ar = null;
                        for (i = 0; ar == null && i < arrr.length; ++i) {
                            if (arrr[i] == null) continue;
                            for (j = 0; ar == null && j < arrr[i].length; ++j) {
                                ar = arrr[i][j];
                            }
                        }
                        if (ar != null) {
                            nvu.attr.aid = aeObj[0].getId();
                            nvu.attr.aaName = field;
                            u = op.indexOf("IN") >= 0 ? OdsxHelper.parseTS_Union(DataType.DS_LONGLONG, val) : OdsxHelper.parseTS_Union(DataType.DT_LONGLONG, val);
                        }
                    }
                    if (u != null) {
                        ret = new SelValue(nvu, opCode, new TS_Value(u, 15));
                    }
                    break block12;
                }
                throw new RuntimeException("ERROR: Unknown opcode in where clause.");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return ret;
    }

    protected AIDNameUnitId[] getAIDNameUnitId(ApplicationElement[] aeObj, Vector colSpec) {
        AIDNameUnitId[] nui;
        int i;
        AIDNameUnitId[] ret = null;
        Vector<AIDNameUnitId[]> vec = new Vector<AIDNameUnitId[]>();
        int size = colSpec.size();
        int count = 0;
        for (i = 0; i < size; ++i) {
            nui = this.getAIDNameUnitId(aeObj, (String)colSpec.get(i));
            if (nui == null || nui.length == 0) continue;
            count += nui.length;
            vec.add(nui);
        }
        if (vec.size() > 0 && count > 0) {
            ret = new AIDNameUnitId[count];
            count = 0;
            size = vec.size();
            for (i = 0; i < size; ++i) {
                nui = (AIDNameUnitId[])vec.get(i);
                System.arraycopy(nui, 0, ret, count, nui.length);
                count += nui.length;
            }
        }
        return ret;
    }

    protected AIDNameUnitId[] getAIDNameUnitId(ApplicationElement[] aeObj, String spec) {
        AIDNameUnitId[] ret = null;
        AIDNameUnitId aid = null;
        Vector<AIDNameUnitId> vec = new Vector<AIDNameUnitId>();
        int alen = aeObj.length;
        for (int i = 0; i < alen; ++i) {
            try {
                int j;
                int rlen;
                T_LONGLONG aeId;
                ApplicationAttribute[] aa = this.getApplicationAttributes(aeObj[i], spec);
                if (aa != null && aa.length > 0) {
                    aeId = aeObj[i].getId();
                    rlen = aa.length;
                    for (j = 0; j < rlen; ++j) {
                        aid = new AIDNameUnitId();
                        aid.unitId = new T_LONGLONG();
                        aid.attr = new AIDName();
                        aid.attr.aid = new T_LONGLONG(aeId.high, aeId.low);
                        aid.attr.aaName = aa[j].getName();
                        vec.add(aid);
                    }
                    continue;
                }
                ApplicationRelation[] ar = this.getApplicationRelations(aeObj[i], spec);
                if (ar != null && ar.length > 0) {
                    aeId = aeObj[i].getId();
                    rlen = ar.length;
                    for (j = 0; j < rlen; ++j) {
                        aid = new AIDNameUnitId();
                        aid.unitId = new T_LONGLONG();
                        aid.attr = new AIDName();
                        aid.attr.aid = new T_LONGLONG(aeId.high, aeId.low);
                        aid.attr.aaName = ar[j].getRelationName();
                        vec.add(aid);
                    }
                    continue;
                }
                throw new RuntimeException("Syntax error in select statement near -> " + spec);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (vec.size() > 0) {
            ret = vec.toArray(new AIDNameUnitId[vec.size()]);
        }
        return ret;
    }

    protected ApplicationAttribute[][] getAttributes(InstanceElement[] ieObj, String spec) throws AoException {
        ApplicationElement[] aeObj = new ApplicationElement[ieObj.length];
        int size = ieObj.length;
        for (int i = 0; i < size; ++i) {
            aeObj[i] = ieObj[i].getApplicationElement();
        }
        return this.getAttributes(aeObj, spec);
    }

    protected ApplicationAttribute[][] getAttributes(ApplicationElement[] aeObj, String spec) throws AoException {
        ApplicationAttribute[][] ret = new ApplicationAttribute[aeObj.length][];
        int size = aeObj.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getApplicationAttributes(aeObj[i], spec);
        }
        return ret;
    }

    protected ApplicationAttribute[] getApplicationAttributes(ApplicationElement aeObj, String spec) throws AoException {
        ApplicationAttribute[] ret;
        block12: {
            ret = null;
            try {
                ApplicationAttribute[] arr = aeObj.getAttributes(spec);
                if (arr != null && arr.length != 0) {
                    ret = arr;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (ret == null) {
                String upper = spec.toUpperCase();
                if (upper.startsWith("BA.")) {
                    String type = spec.substring(3, spec.length());
                    try {
                        BaseElement beObj = aeObj.getBaseElement();
                        BaseAttribute[] arr = beObj.getAttributes(type);
                        if (arr == null || arr.length == 0) break block12;
                        Vector<ApplicationAttribute> vec = new Vector<ApplicationAttribute>();
                        int size = arr.length;
                        for (int i = 0; i < size; ++i) {
                            vec.add(aeObj.getAttributeByBaseName(arr[i].getName()));
                        }
                        if (vec.size() > 0) {
                            ret = vec.toArray(new ApplicationAttribute[vec.size()]);
                        }
                    }
                    catch (Throwable tBE) {
                        ret = this.getApplicationAttributes(aeObj, type);
                    }
                } else if (upper.startsWith("AA.")) {
                    String name = spec.substring(3, spec.length());
                    ret = this.getApplicationAttributes(aeObj, name);
                }
            }
        }
        if (ret != null && ret.length == 0) {
            ret = null;
        }
        return ret;
    }

    protected ApplicationRelation[][] getRelations(InstanceElement[] ieObj, String spec) throws AoException {
        ApplicationElement[] aeObj = new ApplicationElement[ieObj.length];
        int size = ieObj.length;
        for (int i = 0; i < size; ++i) {
            aeObj[i] = ieObj[i].getApplicationElement();
        }
        return this.getRelations(aeObj, spec);
    }

    protected ApplicationRelation[][] getRelations(ApplicationElement[] aeObj, String spec) throws AoException {
        ApplicationRelation[][] ret = new ApplicationRelation[aeObj.length][];
        int size = aeObj.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getApplicationRelations(aeObj[i], spec);
        }
        return ret;
    }

    protected ApplicationRelation[] getApplicationRelations(ApplicationElement aeObj, String spec) throws AoException {
        ApplicationRelation[] ret = null;
        try {
            ApplicationRelation[] arr = aeObj.getAllRelations();
            if (arr != null && arr.length != 0) {
                Vector<ApplicationRelation> vec = new Vector<ApplicationRelation>();
                for (int i = 0; i < arr.length; ++i) {
                    String name = arr[i].getRelationName();
                    if (name.matches(spec)) {
                        vec.add(arr[i]);
                        continue;
                    }
                    name = arr[i].getInverseRelationName();
                    if (!name.matches(spec)) continue;
                    vec.add(arr[i]);
                }
                if (vec.size() > 0) {
                    ret = vec.toArray(new ApplicationRelation[vec.size()]);
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (ret == null) {
            // empty if block
        }
        if (ret != null && ret.length == 0) {
            ret = null;
        }
        return ret;
    }

    protected ApplicationElement[] getApplicationElements(ApplicationStructure asObj, String spec) throws AoException {
        ApplicationElement[] ret = null;
        try {
            ApplicationElement[] arr = asObj.getElements(spec);
            if (arr != null && arr.length != 0) {
                ret = arr;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (ret == null) {
            String upper = spec.toUpperCase();
            if (upper.startsWith("BE.")) {
                String type = spec.substring(3, spec.length());
                try {
                    ret = asObj.getElementsByBaseType(type);
                }
                catch (Throwable tBE) {
                    ret = this.getApplicationElements(asObj, type);
                }
            } else if (upper.startsWith("AE.")) {
                String name = spec.substring(3, spec.length());
                ret = this.getApplicationElements(asObj, name);
            }
        }
        if (ret != null && ret.length == 0) {
            ret = null;
        }
        return ret;
    }

    public String getSelectStatement(AoSession session, QueryStructure query) throws AoException {
        int size;
        ApplicationStructure asObj = session.getApplicationStructure();
        StringBuffer ret = new StringBuffer();
        ret.append("SELECT ");
        FwkSortedArray aeElem = new FwkSortedArray();
        if (query.anuSeq != null && query.anuSeq.length != 0) {
            size = query.anuSeq.length;
            for (int i = 0; i < size; ++i) {
                AIDNameUnitId nui = query.anuSeq[i];
                ApplicationElement aeObj = asObj.getElementById(nui.attr.aid);
                if (i != 0) {
                    ret.append(", ");
                }
                String name = aeObj.getName();
                aeElem.add((Comparable)((Object)name));
                if (nui.attr.aaName == null || nui.attr.aaName.length() == 0) continue;
                try {
                    ApplicationAttribute aaObj = aeObj.getAttributeByName(nui.attr.aaName);
                    BaseAttribute baObj = aaObj.getBaseAttribute();
                    ret.append("BA." + baObj.getName());
                    continue;
                }
                catch (Throwable t) {
                    ret.append("AA." + nui.attr.aaName);
                }
            }
        }
        if ((size = aeElem.size()) > 0) {
            ret.append(" FROM ");
        }
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                ret.append(", ");
            }
            ret.append(aeElem.get(i));
        }
        SelOperator[] operator = query.operSeq;
        if (operator == null || operator.length == 0) {
            operator = new SelOperator[]{SelOperator.OPEN, SelOperator.CLOSE};
        }
        int opSize = operator.length;
        if (query.condSeq != null && query.condSeq.length != 0) {
            SelValue[] selValue = query.condSeq;
            size = query.condSeq.length;
            ret.append(" WHERE ");
            int selCount = 0;
            for (int i = 0; i < opSize; ++i) {
                if (operator[i] == SelOperator.OPEN) {
                    ret.append("(");
                    continue;
                }
                if (operator[i] == SelOperator.OPEN) {
                    ret.append(")");
                    continue;
                }
                ret.append(this.getConditionString(asObj, selValue[selCount++]));
                String key = (String)operatorInvList.get(operator[i]);
                if (key != null) {
                    ret.append(" " + key + " ");
                }
                if (i + 1 >= opSize || operator[i + 1] == SelOperator.OPEN) continue;
                ret.append(this.getConditionString(asObj, selValue[selCount++]));
            }
        }
        return ret.toString();
    }

    public String getConditionString(ApplicationStructure asObj, SelValue selValue) {
        StringBuffer ret = new StringBuffer();
        if (operatorInvList.get(selValue.oper) != null) {
            try {
                String aaName = selValue.attr.attr.aaName;
                ApplicationElement aeObj = asObj.getElementById(selValue.attr.attr.aid);
                ApplicationAttribute aaObj = aeObj.getAttributeByName(aaName);
                String baName = null;
                try {
                    BaseAttribute baObj = aaObj.getBaseAttribute();
                    baName = baObj.getName();
                }
                catch (Throwable tBA) {
                    // empty catch block
                }
                if (baName != null) {
                    ret.append("BA." + baName);
                } else {
                    ret.append("AA." + aaName);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            throw new RuntimeException("Unknown operation <" + selValue.oper + ">");
        }
        ret.append(" " + operatorInvList.get(selValue.oper) + " ");
        ret.append(OdsxHelper.ts_valueToString(selValue.value));
        return ret.toString();
    }

    public static ResultColumn[] getResultColumns(ElemResultSet[] elemRes) {
        ResultColumn[] ret = new ResultColumn[]{};
        if (elemRes != null && elemRes.length > 0) {
            ret = new ResultColumn[elemRes[0].attrValues.length];
            for (int j = 0; j < elemRes[0].attrValues.length; ++j) {
                ret[j] = new ResultColumn(elemRes[0].attrValues[j].attrValues.valName);
            }
            for (int i = 0; i < elemRes.length; ++i) {
                for (int j = 0; j < elemRes[i].attrValues.length; ++j) {
                    TS_UnionSeq union = elemRes[i].attrValues[j].attrValues.value.u;
                    String[] sArr = null;
                    if (union != null && union.discriminator() != null) {
                        try {
                            switch (union.discriminator().value()) {
                                case 1: {
                                    sArr = union.stringVal();
                                    break;
                                }
                                case 2: {
                                    int x;
                                    short[] farr = union.shortVal();
                                    sArr = new String[farr.length];
                                    for (x = 0; x < farr.length; ++x) {
                                        sArr[x] = "" + farr[x];
                                    }
                                    break;
                                }
                                case 3: {
                                    int x;
                                    float[] farr = union.floatVal();
                                    sArr = new String[farr.length];
                                    for (x = 0; x < farr.length; ++x) {
                                        sArr[x] = "" + farr[x];
                                    }
                                    break;
                                }
                                case 5: {
                                    int x;
                                    byte[] barr = union.byteVal();
                                    sArr = new String[barr.length];
                                    for (x = 0; x < barr.length; ++x) {
                                        sArr[x] = Integer.toString(barr[x], 16);
                                    }
                                    break;
                                }
                                case 4: {
                                    int x;
                                    boolean[] barr = union.booleanVal();
                                    sArr = new String[barr.length];
                                    for (x = 0; x < barr.length; ++x) {
                                        sArr[x] = "" + barr[x];
                                    }
                                    break;
                                }
                                case 6: {
                                    int x;
                                    int[] larr = union.longVal();
                                    sArr = new String[larr.length];
                                    for (x = 0; x < larr.length; ++x) {
                                        sArr[x] = "" + larr[x];
                                    }
                                    break;
                                }
                                case 7: {
                                    int x;
                                    double[] darr = union.doubleVal();
                                    sArr = new String[darr.length];
                                    for (x = 0; x < darr.length; ++x) {
                                        sArr[x] = "" + darr[x];
                                    }
                                    break;
                                }
                                case 8: {
                                    int x;
                                    T_LONGLONG[] larr = union.longlongVal();
                                    sArr = new String[larr.length];
                                    for (x = 0; x < larr.length; ++x) {
                                        sArr[x] = "" + OdsxHelper.t_longlongToString(larr[x]);
                                    }
                                    break;
                                }
                                case 13: {
                                    int x;
                                    T_COMPLEX[] larr = union.complexVal();
                                    sArr = new String[larr.length];
                                    for (x = 0; x < larr.length; ++x) {
                                        sArr[x] = "" + OdsxHelper.t_complexToString(larr[x]);
                                    }
                                    break;
                                }
                                case 14: {
                                    int x;
                                    T_DCOMPLEX[] larr = union.dcomplexVal();
                                    sArr = new String[larr.length];
                                    for (x = 0; x < larr.length; ++x) {
                                        sArr[x] = "" + OdsxHelper.t_dcomplexToString(larr[x]);
                                    }
                                    break;
                                }
                                case 10: {
                                    sArr = union.dateVal();
                                    break;
                                }
                                case 11: {
                                    break;
                                }
                                case 28: {
                                    break;
                                }
                                default: {
                                    sArr = null;
                                }
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (sArr == null || sArr.length <= 0) continue;
                    for (int x = 0; x < sArr.length; ++x) {
                        ret[j].add(sArr[x]);
                    }
                }
            }
        }
        return ret;
    }

    public boolean parseParams(String params) {
        this.commandString = this.getName() + " " + params;
        this.keys = null;
        this.result = null;
        this.keys = this.parse("SELECT " + params);
        String val = (String)this.keys.remove((Object)">");
        if (val != null && this.hql.openStream(">", val)) {
            this.streamOpened |= 1;
        }
        if ((val = (String)this.keys.remove((Object)">>")) != null && this.hql.openStream(">>", val)) {
            this.streamOpened |= 4;
        }
        if ((val = (String)this.keys.remove((Object)"2>")) != null && this.hql.openStream("2>", val)) {
            this.streamOpened |= 2;
        }
        if ((val = (String)this.keys.remove((Object)"2>>")) != null && this.hql.openStream("2>>", val)) {
            this.streamOpened |= 8;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OdsxResultSetInterface getResultSet() {
        if (this.result != null) return this.result;
        Vector using = (Vector)this.keys.get((Object)USING);
        OdsxSessionInterface session = null;
        session = using == null ? this.hql.getLastUsedSession() : this.hql.getSession((String)using.get(0));
        QueryStructure qs = null;
        if (session == null) throw new RuntimeException("No session opened.");
        try {
            Vector refTo = (Vector)this.keys.get((Object)REFTO);
            if (refTo != null && refTo.size() > 0 && refTo.get(0).toString().toUpperCase().startsWith(SELECT)) {
                StringBuffer sbuf = new StringBuffer();
                for (int i = 0; i < refTo.size(); ++i) {
                    sbuf.append(refTo.get(i)).append(" ");
                }
                sbuf.append(";");
                CmdSelect select = (CmdSelect)this.hql.scanLine(sbuf.toString());
                ElemId[] elemId = select.getElemIds(session.getSession(), select.keys);
                if (elemId.length > 1) {
                    ApplElemAccess aea = session.getSession().getApplElemAccess();
                    Vector<String> vec = new Vector<String>();
                    Vector<ElemResultSet> resultArr = new Vector<ElemResultSet>();
                    this.keys.put((Object)REFTO, vec);
                    for (int i = 0; i < elemId.length; ++i) {
                        vec.clear();
                        vec.add(Long.toString(OdsxHelper.t_longlongToLong(elemId[0].aid)));
                        vec.add(Long.toString(OdsxHelper.t_longlongToLong(elemId[0].iid)));
                        qs = this.getQueryStructure(session.getSession(), this.keys);
                        try {
                            ElemResultSet[] elemRes = aea.getInstances(qs, 0);
                            for (int count = 0; count < elemRes.length; ++count) {
                                resultArr.add(elemRes[count]);
                            }
                            continue;
                        }
                        catch (AoException aoe) {
                            if (aoe.minorCode != 3062) continue;
                            throw new RuntimeException("Select statement cannot cross more than one relation.");
                        }
                    }
                    this.result = new OdsxResultSet(this.getClass().getName(), (CommandInterface)this, resultArr.toArray(new ElemResultSet[0]));
                    this.keys.put((Object)REFTO, (Object)refTo);
                } else if (elemId.length == 1) {
                    Vector<String> vec = new Vector<String>();
                    vec.add(Long.toString(OdsxHelper.t_longlongToLong(elemId[0].aid)));
                    vec.add(Long.toString(OdsxHelper.t_longlongToLong(elemId[0].iid)));
                    this.keys.put((Object)REFTO, vec);
                    qs = this.getQueryStructure(session.getSession(), this.keys);
                    this.keys.put((Object)REFTO, (Object)refTo);
                }
            }
            if (this.result == null && qs == null) {
                qs = this.getQueryStructure(session.getSession(), this.keys);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t.getMessage());
        }
        try {
            if (this.result != null) return this.result;
            ApplElemAccess aea = session.getSession().getApplElemAccess();
            ElemResultSet[] elemRes = aea.getInstances(qs, 0);
            this.result = new OdsxResultSet(this.getClass().getName(), (CommandInterface)this, elemRes);
            return this.result;
        }
        catch (AoException aoe) {
            aoe.printStackTrace();
            throw new RuntimeException("No elements selected.\n" + aoe.reason + " errorCode:" + aoe.errCode.value() + " minorCode:" + aoe.minorCode);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("No elements selected.\n" + t.getClass().getName() + ": " + t.getMessage());
        }
    }

    public boolean execute() {
        super.execute();
        if (this.result == null) {
            this.result = this.getResultSet();
        }
        this.terminateExecution();
        if (this.result != null) {
            this.hql.publishResultSet(this.result);
        }
        return true;
    }

    protected ElemId[] getElemIds(AoSession session, FwkPropertyGroup map) throws AoException {
        ElemId[] elemId;
        block23: {
            Object[] id;
            ApplicationStructure asObj;
            try {
                asObj = session.getApplicationStructure();
            }
            catch (Throwable tas) {
                throw new RuntimeException("Cannot retrieve the ODS session.");
            }
            Vector from = (Vector)map.get((Object)FROM);
            if (from == null) {
                throw new RuntimeException("ERROR: From clause missing.");
            }
            int size = from.size();
            if (size > 1) {
                throw new RuntimeException("WARNING: Selection from more than one element is currently not supported.");
            }
            String element = (String)from.get(0);
            String upper = element.toUpperCase();
            ApplicationElement[] aeObj = null;
            InstanceElement[] ieObj = null;
            if (upper.startsWith("IE.")) {
                String ieName;
                String spec = element.substring(3, element.length());
                String aeName = StringUtilities.substring((String)StringUtilities.substring((String)spec, (char)']', (int)-1), (char)'[', (int)1);
                aeObj = this.getApplicationElements(asObj, aeName);
                InstanceElement ie = aeObj[0].getInstanceByName(ieName = StringUtilities.substring((String)element, (char)']', (int)1));
                if (ie == null) {
                    String name = StringUtilities.substring((String)ieName, (char)';', (int)-1);
                    String version = ieName.substring(name.length() + 1);
                    InstanceElementIterator ii = aeObj[0].getInstances(name);
                    int count = ii.getCount();
                    if (count == 1) {
                        ieObj = new InstanceElement[]{ii.nextOne()};
                    } else {
                        ApplicationAttribute aaVersion = aeObj[0].getAttributeByBaseName("version");
                        Vector<InstanceElement> ieVec = new Vector<InstanceElement>();
                        for (int i = 0; i < count; ++i) {
                            ie = ii.nextOne();
                            NameValueUnit nvu = ie.getValue(aaVersion.getName());
                            if (!Pattern.match((String)OdsxHelper.ts_valueToString(nvu.value), (String)version, (boolean)false)) continue;
                            ieVec.add(ie);
                        }
                        if (ieVec.size() > 0) {
                            ieObj = ieVec.toArray(new InstanceElement[ieVec.size()]);
                        }
                    }
                    ii.destroy();
                } else {
                    ieObj = new InstanceElement[]{ie};
                }
                if (ieObj == null) {
                    throw new RuntimeException("ERROR: Instance element <" + element + "> not found.");
                }
                aeObj = null;
            } else {
                aeObj = this.getApplicationElements(asObj, element);
            }
            if (ieObj != null) {
                throw new RuntimeException("Instance selection is currently not supported.");
            }
            if (aeObj != null && aeObj.length > 1) {
                throw new RuntimeException("Multi application element selection is currently not supported.");
            }
            QueryStructure ret = new QueryStructure();
            ret.relInst = new ElemId();
            ret.relName = "";
            ret.relInst.aid = new T_LONGLONG();
            ret.relInst.iid = new T_LONGLONG();
            ret.orderBy = new SelOrder[0];
            ret.anuSeq = new AIDNameUnitId[1];
            ret.anuSeq[0] = new AIDNameUnitId();
            ret.anuSeq[0].attr = new AIDName();
            ret.anuSeq[0].attr.aid = aeObj[0].getId();
            ret.anuSeq[0].attr.aaName = aeObj[0].getAttributeByBaseName("id").getName();
            ret.anuSeq[0].unitId = new T_LONGLONG();
            Vector where = (Vector)map.get((Object)WHERE);
            if (where != null && where.size() != 0) {
                Vector selOp = new Vector();
                Vector selValues = this.getSelValue(aeObj, where, null, selOp);
                if (selValues != null && selValues.size() != 0) {
                    ret.condSeq = selValues.toArray(new SelValue[selValues.size()]);
                }
                if (selOp != null && selOp.size() != 0) {
                    ret.operSeq = selOp.toArray(new SelOperator[selOp.size()]);
                }
            } else {
                ret.condSeq = new SelValue[0];
                ret.operSeq = new SelOperator[0];
            }
            ApplElemAccess aea = asObj.getSession().getApplElemAccess();
            elemId = new ElemId[]{};
            ElemResultSet[] elemRes = aea.getInstances(ret, 0);
            if (elemRes == null || elemRes[0].attrValues == null || elemRes[0].attrValues.length <= 0) break block23;
            if (elemRes[0].attrValues[0].attrValues.value.u.discriminator().value() == 6) {
                id = elemRes[0].attrValues[0].attrValues.value.u.longVal();
                int idSize = id.length;
                elemId = new ElemId[idSize];
                T_LONGLONG aeId = aeObj[0].getId();
                for (int i = 0; i < idSize; ++i) {
                    elemId[i] = new ElemId(new T_LONGLONG(aeId.high, aeId.low), new T_LONGLONG(0, id[i]));
                }
            } else {
                id = elemRes[0].attrValues[0].attrValues.value.u.longlongVal();
                T_LONGLONG aeId = aeObj[0].getId();
                int idSize = id.length;
                elemId = new ElemId[idSize];
                for (int i = 0; i < idSize; ++i) {
                    elemId[i] = new ElemId(new T_LONGLONG(aeId.high, aeId.low), (T_LONGLONG)id[i]);
                }
            }
        }
        return elemId;
    }

    static {
        operatorList.put("&&", SelOperator.AND);
        operatorList.put("AND", SelOperator.AND);
        operatorList.put("and", SelOperator.AND);
        operatorList.put("||", SelOperator.OR);
        operatorList.put("OR", SelOperator.OR);
        operatorList.put("or", SelOperator.OR);
        operatorList.put("!", SelOperator.NOT);
        operatorList.put("(", SelOperator.OPEN);
        operatorList.put("[", SelOperator.OPEN);
        operatorList.put(")", SelOperator.CLOSE);
        operatorList.put("]", SelOperator.CLOSE);
        operatorList.put("==", SelOpcode.EQ);
        operatorList.put("=", SelOpcode.EQ);
        operatorList.put(">", SelOpcode.GT);
        operatorList.put(">=", SelOpcode.GTE);
        operatorList.put("<", SelOpcode.LT);
        operatorList.put("<=", SelOpcode.LTE);
        operatorList.put("LIKE", SelOpcode.LIKE);
        operatorList.put("IN", SelOpcode.INSET);
        operatorList.put("!IN", SelOpcode.NOTINSET);
        operatorList.put("!=", SelOpcode.NEQ);
        operatorInvList.put(SelOperator.AND, "&&");
        operatorInvList.put(SelOperator.OR, "||");
        operatorInvList.put(SelOperator.NOT, "!");
        operatorInvList.put(SelOperator.OPEN, "(");
        operatorInvList.put(SelOperator.CLOSE, ")");
        operatorInvList.put(SelOpcode.EQ, "==");
        operatorInvList.put(SelOpcode.EQ, "=");
        operatorInvList.put(SelOpcode.GT, ">");
        operatorInvList.put(SelOpcode.GTE, ">=");
        operatorInvList.put(SelOpcode.LT, "<");
        operatorInvList.put(SelOpcode.LTE, "<=");
        operatorInvList.put(SelOpcode.LIKE, "LIKE");
        operatorInvList.put(SelOpcode.INSET, "IN");
        operatorInvList.put(SelOpcode.NOTINSET, "!IN");
        operatorInvList.put(SelOpcode.NEQ, "!=");
        help = FwkPropertyBus.getProperty((String)"HQL.Help.CmdSelect", (String)null);
        if (help == null) {
            StringBuffer buf = new StringBuffer();
            if (OdsxHelper.deLang) {
                buf.append("Der SELECT Befehl listet die den Bedingungen entsprechenden\n");
                buf.append("Werte der selektierten Attribute eines Elementes auf.\n");
                buf.append("\n");
                buf.append("Der Befehl ist folgenderma\u00dfen aufgebaut:\n");
                buf.append("select <Attribute1, Attribute2,..> from <Element> \n");
                buf.append("where <Bedingungen f\u00fcr Attribute> using <Service>;\n");
                buf.append("\n");
                buf.append("Beispiel:\n");
                buf.append("Select ba.id, ba.name, ba.version from be.aotest where\n");
                buf.append("(ba.id >= 200 and ba.name = S*) and ba.version = 1;\n");
                buf.append("\n");
                buf.append("Der Praefix  ba. signalisiert, dass ein BasisAttribute verwendet wird,\n");
                buf.append("waehrend be. ein BasisElement angibt. Praefix, die andere Elemente\n");
                buf.append("beschreiben sind ebenso m\u00f6glich (aa., ae., ia., ie.).\n");
                buf.append("\n");
                buf.append("Allgemein:\n");
                buf.append("Der Befehl wird prinzipiell case-insensitive bearbeitet.\n");
                buf.append("Kontextabh\u00e4ngige Element sind hiervon ausgeschlossen. Sind Teile\n");
                buf.append("des Statements vom Datenbestand abh\u00e4ngig, so muss hier die\n");
                buf.append("Schreibweise genau beachtet werden.\n");
                buf.append("\n");
                buf.append("Angabe der Attribute:\n");
                buf.append("Es muss mindestens ein Attribut angegeben werden. Mehrere werden\n");
                buf.append("durch ein Komma getrennt (siehe Beispiel). Die Ausgabe ist abhaengig\n");
                buf.append("von der Reihenfolge der aufgelisteten Attribute. \n");
                buf.append("\n");
                buf.append("Angabe der Elemente:\n");
                buf.append("Es ist nur die Eingabe eines Elementes moeglich.\n");
                buf.append("\n");
                buf.append("Angabe von Bedingungen:\n");
                buf.append(" sind optional. Sie werden durch den where Befehl angefuehrt.\n");
                buf.append("Innerhalb eines Wertes (ba.id >= 200) sind folgende Operatoren moeglich:\n");
                buf.append("\n");
                buf.append("'='   ba.name =  S*; Jedes Attribut welches mit S beginnt\n");
                buf.append("'<='  ba.id   <= 10;\n");
                buf.append("'>='  ba.id   >= 10;\n");
                buf.append("'<'   ba.id   <  10;\n");
                buf.append("'>'   ba.id   >  10;\n");
                buf.append("'!='  ba.id   != 10;\n");
                buf.append("\n");
                buf.append("Mehrere Werte k\u00f6nnen durch folgende Operatoren verknuepft werden:\n");
                buf.append("\n");
                buf.append("'&&',  'AND',  'and'    fuer 'und'\n");
                buf.append("'||',  'OR' ,  'or'     fuer 'oder'\n");
                buf.append("\n");
                buf.append("Zum Verschachteln der Werte sind  ' ( , ) ' zulaessig.\n");
                buf.append("\n");
                buf.append("Der using  Term:\n");
                buf.append("Die using Anweisung ist optional. Bei mehreren geoeffneten\n");
                buf.append("services, lawsst sich derjenige angeben der benutzt werden\n");
                buf.append("soll. Fehlt der using Teil, so wird die zuletzt benutzte\n");
                buf.append("Session verwendet.\n");
            } else {
                buf.append("The SELECT statement is like a SQL statement.\n\n");
                buf.append("Example:\n");
                buf.append("Select ba.id from be.AoTest where ba.id < 10 using ATF/Target; \n\n");
                buf.append("The prefix ba. signals that a BasisAttribute should be used.\n");
                buf.append("The prefix be. signals that a BasisElement should be used.\n");
                buf.append("There are more prefix available for other elements (aa., ae., ia., ie.). \n");
                buf.append("The statement is caseinsensitive. \n");
                buf.append("Context dependent element should be used as they appear in database.\n");
                buf.append("The USING part is optional.\n");
                buf.append("If you ommit the USING part, the interpreter will try to find the\n");
                buf.append("last used session.");
            }
            help = buf.toString();
        }
    }
}

