/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hql;

import com.highqsoft.fwk.FwkApplication;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkInfoBusConsumer;
import com.highqsoft.fwk.FwkInfoBusController;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.fwk.util.StringUtilities;
import com.highqsoft.interfaces.fwk.FwkControlledByInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.hql.CommandInterface;
import com.highqsoft.odsx.hql.OdsxResultSetInterface;
import com.highqsoft.odsx.hql.OdsxResultSetProducer;
import com.highqsoft.odsx.hql.ResultColumnInterface;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRevokedEvent;

public class HQL
extends FwkApplication {
    public static final String version = "$Revision: 1.7 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    public static final String DELIMITERS = " \t\n\r'\",=";
    public static final String OPEN_OUT = ">";
    public static final String APPEND_OUT = ">>";
    public static final String OPEN_ERR = "2>";
    public static final String APPEND_ERR = "2>>";
    protected HQLController infoBusController = null;
    protected HQLResultSetConsumer resultSetConsumer = null;
    protected OdsxResultSetProducer resultSetProducer = null;
    protected Vector outStack;
    protected Vector errStack;
    public PrintStream out;
    public InputStream in;
    protected boolean verbose;
    public PrintStream err;
    protected FwkPropertyGroupInterface cmdGroup;
    protected String[] cmds;
    HashMap session;
    Vector sessionOrder;
    static /* synthetic */ Class class$com$highqsoft$odsx$hql$OdsxResultSetInterface;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)HQL.class, (FwkDescriptionInterface)descriptor);
    }

    public HQL() {
        String key;
        Enumeration props;
        FwkPropertyGroup grp;
        this.setVerbose(true);
        this.setDescriptor(HQL.getDescriptor());
        this.register();
        this.infoBusController = new HQLController();
        this.infoBusController.setController((FwkControllerInterface)this);
        this.resultSetConsumer = new HQLResultSetConsumer();
        this.resultSetConsumer.setController((FwkControllerInterface)this);
        this.resultSetProducer = new OdsxResultSetProducer("ResultSetProducer[" + this.getName() + "]");
        this.resultSetProducer.setController((FwkControllerInterface)this);
        this.in = System.in;
        this.out = System.out;
        this.err = System.err;
        this.outStack = new Vector();
        this.errStack = new Vector();
        FwkPropertyGroupInterface group = FwkPropertyBus.getPropertyGroup((String)"HQL.Command");
        if (group == null) {
            group = new FwkPropertyGroup();
        }
        this.session = new HashMap();
        this.sessionOrder = new Vector();
        if (group.getProperty("EXIT.Classname") == null) {
            group.put((Object)"EXIT.Classname", (Object)"com.highqsoft.odsx.hql.CmdExit");
        }
        if (group.getProperty("ECHO.Classname") == null) {
            group.put((Object)"ECHO.Classname", (Object)"com.highqsoft.odsx.hql.CmdEcho");
        }
        if (group.getProperty("QUIT.Classname") == null) {
            group.put((Object)"QUIT.Classname", (Object)"com.highqsoft.odsx.hql.CmdExit");
        }
        if (group.getProperty("HELP.Classname") == null) {
            group.put((Object)"HELP.Classname", (Object)"com.highqsoft.odsx.hql.CmdHelp");
        }
        if (group.getProperty("SOURCE.Classname") == null) {
            group.put((Object)"SOURCE.Classname", (Object)"com.highqsoft.odsx.hql.CmdSource");
        }
        if (group.getProperty("LIST.Classname") == null) {
            group.put((Object)"LIST.Classname", (Object)"com.highqsoft.odsx.hql.CmdList");
        }
        if (group.getProperty("CONNECT.Classname") == null) {
            group.put((Object)"CONNECT.Classname", (Object)"com.highqsoft.odsx.hql.CmdConnect");
        }
        if (group.getProperty("CLOSE.Classname") == null) {
            group.put((Object)"CLOSE.Classname", (Object)"com.highqsoft.odsx.hql.CmdClose");
        }
        if (group.getProperty("SELECT.Classname") == null) {
            group.put((Object)"SELECT.Classname", (Object)"com.highqsoft.odsx.hql.CmdSelect");
        }
        if (group.getProperty("DESCRIBE.Classname") == null) {
            group.put((Object)"DESCRIBE.Classname", (Object)"com.highqsoft.odsx.hql.CmdDescribe");
        }
        if (group.getProperty("JOURNAL.Classname") == null) {
            group.put((Object)"JOURNAL.Classname", (Object)"com.highqsoft.odsx.hql.CmdJournal");
        }
        this.cmdGroup = new FwkPropertyGroup();
        Enumeration names = group.groupNames();
        FwkSortedArray cmdsVec = new FwkSortedArray();
        while (names.hasMoreElements()) {
            String cmdName = (String)names.nextElement();
            grp = group.getPropertyGroup(cmdName);
            String className = grp.getProperty("Classname", (String)null);
            if (className == null) continue;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (Throwable t) {
                this.err.println("Cannot instanciate class <" + className + ">.");
            }
            if (clazz == null || grp.get((Object)"Class") != null) continue;
            grp.put((Object)"Class", clazz);
            props = grp.propertyNames();
            cmdName = cmdName.toUpperCase();
            while (props.hasMoreElements()) {
                key = (String)props.nextElement();
                this.cmdGroup.put((Object)(cmdName + '.' + key), grp.get((Object)key));
                cmdsVec.add((Comparable)((Object)cmdName));
            }
            clazz = null;
        }
        grp = new FwkPropertyGroup();
        grp.put((Object)"Classname", (Object)((Object)((Object)this)).getClass().getName());
        grp.put((Object)"Class", ((Object)((Object)this)).getClass());
        String hqlHelp = FwkPropertyBus.getProperty((String)"HQL.Help", (String)null);
        if (hqlHelp == null) {
            if (OdsxHelper.deLang) {
                grp.put((Object)"Help", (Object)("HighQSoft Interpreter f\u00fcr ODS Kommandos (Version " + this.getVersion() + ")\n" + "Jedes Kommando muss mit einem Semicolon abgeschlossen sein.\n" + "Benutzen Sie das Kommand <help> f\u00fcr weitere Hilfen."));
            } else {
                grp.put((Object)"Help", (Object)("HighQSoft Interpreter for ODS commands (Version " + this.getVersion() + ")\n" + "Each command must be terminated by a colon (;).\n" + "Use the command <help> to get more information."));
            }
        } else {
            grp.put((Object)"Help", (Object)hqlHelp);
        }
        props = grp.propertyNames();
        while (props.hasMoreElements()) {
            key = (String)props.nextElement();
            this.cmdGroup.put((Object)("HQL." + key), grp.get((Object)key));
            cmdsVec.add((Comparable)((Object)"HQL"));
        }
        this.cmds = (String[])cmdsVec.toArray((Object[])new String[0]);
        if (FwkPropertyBus.getProperty((String)"HQL.Verbose", (boolean)false) || FwkPropertyBus.getProperty((String)"HQL.Version", (boolean)false)) {
            this.out.println(this.getVersion());
        }
        if (FwkPropertyBus.getProperty((String)"HQL.Verbose", (boolean)false)) {
            this.out.println(this.getVersion());
            this.out.println(this.cmdGroup);
        }
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void run() {
    }

    public FwkPanelInterface getPanel() {
        return null;
    }

    public boolean exit() {
        boolean ret = super.exit();
        if (ret) {
            this.infoBusController.unregister();
            this.resultSetProducer.unregister();
            this.resultSetConsumer.unregister();
        }
        return ret;
    }

    public void release() {
        if (this.cmdGroup != null) {
            this.cmdGroup.clear();
            this.cmdGroup = null;
        }
    }

    public static String[] parseParams(String params, FwkPropertyGroup keys) {
        Vector<String> ret = new Vector<String>();
        if (keys == null) {
            keys = new FwkPropertyGroup();
        }
        StringTokenizer st = new StringTokenizer(params, DELIMITERS, true);
        int isKey = -1;
        while (st.hasMoreTokens()) {
            String lastToken = st.nextToken();
            if (lastToken.charAt(0) == '\'' || lastToken.charAt(0) == '\"') {
                if (isKey >= 0) {
                    keys.put((Object)((String)ret.get(isKey)).toUpperCase(), (Object)HQL.parseString(st, lastToken.charAt(0)));
                    ret.remove(isKey);
                    isKey = -1;
                    continue;
                }
                ret.add(HQL.parseString(st, lastToken.charAt(0)));
                continue;
            }
            if (lastToken.charAt(0) == '=') {
                isKey = ret.size() - 1;
                continue;
            }
            if (DELIMITERS.indexOf(lastToken) >= 0) continue;
            if (isKey >= 0) {
                keys.put((Object)((String)ret.get(isKey)).toUpperCase(), (Object)lastToken);
                ret.remove(isKey);
                isKey = -1;
                continue;
            }
            if (lastToken.charAt(0) == '/') {
                keys.put((Object)lastToken.substring(1, lastToken.length()).toUpperCase(), (Object)"TRUE");
                continue;
            }
            ret.add(lastToken);
        }
        String[] arr = new String[ret.size()];
        if (ret.size() > 0) {
            arr = ret.toArray(arr);
        }
        return arr;
    }

    protected static String parseString(StringTokenizer st, char delimiter) {
        StringBuffer ret = new StringBuffer();
        boolean stop = false;
        while (!stop && st.hasMoreTokens()) {
            String lastToken = st.nextToken();
            if (lastToken.charAt(0) != delimiter) {
                ret = ret.append(lastToken);
                continue;
            }
            if (ret.length() > 0) {
                if (ret.charAt(ret.length() - 1) != '\\') {
                    stop = true;
                    continue;
                }
                ret = ret.replace(ret.length() - 1, ret.length(), lastToken);
                continue;
            }
            stop = true;
        }
        return ret.toString();
    }

    public CommandInterface readString(String cmdString) throws RuntimeException {
        ByteArrayInputStream in = new ByteArrayInputStream(cmdString.getBytes());
        CommandInterface ret = this.readFrom(in);
        try {
            in.close();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
        return ret;
    }

    public CommandInterface readFrom(InputStream in) throws RuntimeException {
        return this.readFrom(new InputStreamReader(in));
    }

    public CommandInterface readFrom(InputStreamReader in) throws RuntimeException {
        return this.readFrom(new BufferedReader(in));
    }

    public CommandInterface readFrom(BufferedReader in) throws RuntimeException {
        CommandInterface ret = null;
        String cmd = "";
        boolean complete = false;
        while (!complete) {
            String oneLine;
            try {
                oneLine = in.readLine();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException("Cannot read command from stream.");
            }
            if (oneLine != null) {
                if ((oneLine = oneLine.trim()).length() == 0 || oneLine.charAt(0) == '#') {
                    complete = true;
                    cmd = ";";
                    continue;
                }
                cmd = cmd + " " + oneLine;
                complete = cmd.endsWith(";");
                continue;
            }
            complete = true;
            cmd = null;
        }
        if (cmd != null) {
            try {
                ret = this.scanLine(cmd);
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getMessage());
            }
        }
        return ret;
    }

    public CommandInterface scanLine(String line) throws Throwable {
        StringTokenizer st;
        CommandInterface ret = null;
        String cmd = line.trim();
        if (cmd.length() > 0 && cmd.endsWith(";")) {
            cmd = cmd.substring(0, cmd.length() - 1);
        }
        if (cmd.length() > 0 && (st = new StringTokenizer(cmd, " \t\n\r", false)).hasMoreTokens()) {
            String token = st.nextToken();
            ret = this.createCommand(token.toUpperCase());
            ret.parseParams(cmd.substring(token.length(), cmd.length()).trim());
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandInterface createCommand(String name) {
        CommandInterface ret = null;
        FwkPropertyGroupInterface grp = this.cmdGroup.getPropertyGroup(name = name.trim().toUpperCase());
        if (grp != null) {
            Class clazz = (Class)grp.get((Object)"Class");
            if (clazz == null) throw new RuntimeException("Cannot find command class for <" + name + OPEN_OUT);
            try {
                ret = (CommandInterface)clazz.newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException("\nCannot instanciate command <" + name + ">.");
            }
            try {
                ret.setInterpreter(this);
                return ret;
            }
            catch (Throwable t) {}
            return ret;
        }
        StringUtilities.LevenstheinDistance[] res = StringUtilities.levenstheinDist((String)name.toUpperCase(), (String[])this.cmds);
        if (res[0].getDistance() == res[1].getDistance() && !res[0].getValue().startsWith(name.toUpperCase())) throw new RuntimeException("Unknown command <" + name + OPEN_OUT);
        String altName = res[0].getValue();
        grp = this.cmdGroup.getPropertyGroup(altName.trim().toUpperCase());
        if (grp == null) throw new RuntimeException("Unknown command <" + name + OPEN_OUT);
        if (!FwkPropertyBus.getProperty((String)"HQL.Verbose", (boolean)false)) return this.createCommand(altName);
        this.out.println("Unknown command <" + name + ">: using <" + altName + "> instead.");
        return this.createCommand(altName);
    }

    public void readFromKeyboard() {
        String PROMPT = "HQL> ";
        this.out.print(PROMPT);
        this.out.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (!this.isInterrupted()) {
            try {
                CommandInterface cmd = this.readFrom(in);
                if (cmd != null && cmd.execute()) {
                    cmd.terminateExecution();
                }
            }
            catch (Throwable t) {
                this.err.println(t.getMessage());
                this.err.flush();
            }
            if (this.isInterrupted()) continue;
            this.out.print(PROMPT);
            this.out.flush();
        }
    }

    public static void printCols(PrintStream out, ResultColumnInterface[] cols) {
        if (cols != null && cols.length > 0) {
            StringBuffer ret = new StringBuffer("| ");
            for (int i = 0; i < cols.length; ++i) {
                ret.append(cols[i].getName() + " | ");
            }
            ret.append("\n");
            char[] sep = new char[ret.length() - 2];
            Arrays.fill(sep, '-');
            ret.insert(0, new String(sep) + "\n");
            ret.append(new String(sep));
            int size = cols[0].size();
            for (int j = 0; j < size; ++j) {
                ret.append("\n| ");
                for (int i = 0; i < cols.length; ++i) {
                    ret.append(cols[i].get(j) + " | ");
                }
            }
            ret.append("\n" + new String(sep));
            out.println(ret);
        }
    }

    public FwkPropertyGroupInterface getCommandProperties(String cmd) {
        FwkPropertyGroupInterface ret = this.cmdGroup.getPropertyGroup(cmd = cmd.toUpperCase());
        if (ret == null) {
            String altName = StringUtilities.levenstheinFind((String)cmd, (String[])this.cmds);
            ret = this.cmdGroup.getPropertyGroup(altName);
        }
        return ret;
    }

    public Enumeration getInterpreterCommands() {
        return this.cmdGroup.groupNames();
    }

    public void setSession(String name, OdsxSessionInterface session) {
        if (name == null) {
            name = session.getName();
        }
        if (this.session.get(name) == null) {
            this.session.put(name, session);
            this.sessionOrder.add(name);
        }
    }

    public void closeSession(String name) {
        OdsxSessionInterface s = this.getSession(name);
        if (s != null) {
            s.close();
            this.session.remove(name);
            this.sessionOrder.remove(name);
        }
    }

    public OdsxSessionInterface getSession(String name) {
        OdsxSessionInterface ret = (OdsxSessionInterface)this.session.get(name);
        if (ret != null) {
            this.sessionOrder.remove(name);
            this.sessionOrder.add(name);
        }
        return ret;
    }

    public OdsxSessionInterface getLastUsedSession() {
        if (this.sessionOrder.size() > 0) {
            return (OdsxSessionInterface)this.session.get((String)this.sessionOrder.get(this.sessionOrder.size() - 1));
        }
        return null;
    }

    public Iterator listSessions() {
        return this.session.keySet().iterator();
    }

    public boolean openStream(String type, String spec) {
        FileOutputStream os = null;
        if (type.equals(OPEN_OUT)) {
            try {
                os = new FileOutputStream(spec);
                this.setOut(new PrintStream(os));
            }
            catch (Throwable t) {}
        } else if (type.equals(OPEN_ERR)) {
            try {
                os = new FileOutputStream(spec);
                this.setErr(new PrintStream(os));
            }
            catch (Throwable t) {}
        } else if (type.equals(APPEND_OUT)) {
            try {
                os = new FileOutputStream(spec, true);
                this.setOut(new PrintStream(os));
            }
            catch (Throwable t) {}
        } else if (type.equals(APPEND_ERR)) {
            try {
                os = new FileOutputStream(spec, true);
                this.setErr(new PrintStream(os));
            }
            catch (Throwable t) {}
        } else {
            this.err.println("Unknown stream type.");
        }
        return os != null;
    }

    public boolean closeStream(String type) {
        boolean ret = false;
        if (type.equals(OPEN_OUT) || type.equals(APPEND_OUT)) {
            if (this.outStack.size() > 0) {
                try {
                    this.out.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.out = (PrintStream)this.outStack.get(this.outStack.size() - 1);
                this.outStack.remove(this.outStack.size() - 1);
            }
        } else if ((type.equals(OPEN_ERR) || type.equals(APPEND_ERR)) && this.errStack.size() > 0) {
            try {
                this.err.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.err = (PrintStream)this.errStack.get(this.errStack.size() - 1);
            this.errStack.remove(this.errStack.size() - 1);
        }
        return ret;
    }

    public void setOut(PrintStream out) {
        this.outStack.add(this.out);
        this.out = out;
    }

    public void setErr(PrintStream err) {
        this.errStack.add(this.err);
        this.err = err;
    }

    public void publishResultSet(OdsxResultSetInterface result) {
        if (result != null) {
            this.resultSetProducer.add(result);
        }
    }

    public void revokeResultSet(OdsxResultSetInterface result) {
        if (result != null) {
            this.resultSetProducer.revoke(result);
        }
    }

    public static void main(String[] args) {
        String[] aaa = new String[args.length + 1];
        if (args.length > 0) {
            System.arraycopy(args, 0, aaa, 0, args.length);
        }
        aaa[args.length] = "-BatchMode";
        FwkContainer.initialize((String[])aaa);
        HQL hql = new HQL();
        hql.start();
        hql.readFromKeyboard();
        System.exit(0);
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("The HQL interpreter.");
        descriptor.setTitleName("HQL.Text.Title");
        descriptor.setName(HQL.class.getName());
        descriptor.setClassName(HQL.class.getName());
        descriptor.setIconKey("Icon.HQL");
        descriptor.setCreationDate("$Date: 2006/01/16 08:29:51 $", null);
    }

    private class HQLResultSetConsumer
    extends FwkInfoBusConsumer
    implements FwkControlledByInterface {
        public HQLResultSetConsumer() {
            super("HQLResultSetConsumer[" + HQL.this.getName() + "]@" + FwkDataBus.BUSNAME, FwkContainer.getFwkMimeType((Class)(class$com$highqsoft$odsx$hql$OdsxResultSetInterface == null ? (class$com$highqsoft$odsx$hql$OdsxResultSetInterface = HQL.class$("com.highqsoft.odsx.hql.OdsxResultSetInterface")) : class$com$highqsoft$odsx$hql$OdsxResultSetInterface)));
        }

        public void dataItemAvailable(InfoBusItemAvailableEvent ev) {
            OdsxResultSetInterface result;
            if (this.isAssignable(ev.getDataFlavors()) && (result = (OdsxResultSetInterface)ev.requestDataItem((InfoBusDataConsumer)this, this.getDataFlavors())) != null && HQL.this.getVerbose()) {
                int count = result.getRowCount();
                HQL.printCols(HQL.this.out, result.getResultColumns());
                HQL.this.out.println(count + " rows / elapsed time " + (double)Math.round((double)result.createdBy().timeNeeded() / 10.0) / 100.0 + " sec");
            }
        }

        public void dataItemRevoked(InfoBusItemRevokedEvent ev) {
        }
    }

    private class HQLController
    extends FwkInfoBusController
    implements FwkControlledByInterface {
        FwkControllerInterface controller;

        public HQLController() {
            super("HQLController[" + HQL.this.getName() + "]@" + FwkDataBus.BUSNAME, FwkContainer.getFwkMimeTypes((Class)(class$com$highqsoft$odsx$hql$OdsxResultSetInterface == null ? (class$com$highqsoft$odsx$hql$OdsxResultSetInterface = HQL.class$("com.highqsoft.odsx.hql.OdsxResultSetInterface")) : class$com$highqsoft$odsx$hql$OdsxResultSetInterface)), 2);
            this.setInAllowed(-1);
            this.setOutAllowed(-1);
        }

        public void addDataConsumer(InfoBusDataConsumer consumer) {
            if (this.getController() != null && consumer instanceof FwkControlledByInterface) {
                FwkControlledByInterface appl = (FwkControlledByInterface)consumer;
                if (this.getController().equals(appl.getController())) {
                    this.consumerList.put(consumer, consumer);
                }
            }
        }

        public void addDataProducer(InfoBusDataProducer producer) {
            if (this.getController() != null && producer instanceof FwkControlledByInterface) {
                FwkControlledByInterface appl = (FwkControlledByInterface)producer;
                if (this.getController().equals(appl.getController())) {
                    this.producerList.put(producer, producer);
                }
            }
        }
    }
}

