/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hql;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkItem;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.hql.CommandInterface;
import com.highqsoft.odsx.hql.OdsxResultSetInterface;
import com.highqsoft.odsx.hql.ResultColumn;
import com.highqsoft.odsx.hql.ResultColumnInterface;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import org.asam.ods.ElemResultSet;
import org.asam.ods.NameValueSeqUnitId;
import org.asam.ods.TS_UnionSeq;
import org.asam.ods.T_COMPLEX;
import org.asam.ods.T_DCOMPLEX;
import org.asam.ods.T_ExternalReference;
import org.asam.ods.T_LONGLONG;

public class OdsxResultSet
extends FwkItem
implements OdsxResultSetInterface {
    public static final String version = "$Revision: 1.11 $";
    protected ElemResultSet[] elemRes;
    protected int[] charWidth;
    protected Object[] stringVal;
    protected CommandInterface command;
    protected int refCount;
    protected Locale locale;
    protected int[] sortIdx;

    public String getVersion() {
        return version;
    }

    public OdsxResultSet(String name, CommandInterface command) {
        this.setLocale(FwkContainer.getLocale());
        this.setName(name);
        this.elemRes = null;
        this.command = command;
        this.charWidth = null;
        this.stringVal = null;
        this.refCount = 1;
        this.sortIdx = null;
    }

    public OdsxResultSet(String name, CommandInterface command, ElemResultSet[] res) {
        this(name, command);
        this.elemRes = res;
        this.getRowCount();
    }

    public OdsxResultSet(String name, CommandInterface command, String[] res) {
        this(name, command);
        this.stringVal = new Object[1];
        if (res != null) {
            String[] arr = new String[res.length];
            System.arraycopy(res, 0, arr, 0, res.length);
            this.stringVal[0] = arr;
        } else {
            this.stringVal[0] = new String[0];
        }
    }

    public OdsxResultSet(String name, CommandInterface command, Vector res) {
        this(name, command);
        this.stringVal = new Object[1];
        this.stringVal[0] = res != null ? res.toArray(new String[res.size()]) : new String[0];
    }

    public CommandInterface createdBy() {
        return this.command;
    }

    public void release() {
        if (this.refCount == 1) {
            this.name = null;
            this.elemRes = null;
            this.charWidth = null;
            this.stringVal = null;
            this.command.release();
            this.command = null;
            this.sortIdx = null;
        }
        --this.refCount;
    }

    public void attach() {
        ++this.refCount;
    }

    public String[] listColumns(String pattern) {
        Vector<String> ret = new Vector<String>();
        if (this.elemRes != null && this.elemRes.length > 0) {
            int size = this.getColumnCount();
            if (pattern.equals("*")) {
                for (int i = 0; i < size; ++i) {
                    ret.add(this.elemRes[0].attrValues[i].attrValues.valName);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    String val = this.elemRes[0].attrValues[i].attrValues.valName;
                    if (!Pattern.match((String)val, (String)pattern, (boolean)false)) continue;
                    ret.add(val);
                }
            }
        } else if (this.stringVal != null && this.stringVal.length > 0) {
            ret.add(this.getName());
        }
        if (ret.size() > 0) {
            return ret.toArray(new String[ret.size()]);
        }
        return new String[0];
    }

    public int findColumn(String name) {
        int ret = -1;
        if (this.elemRes != null && this.elemRes.length > 0) {
            int size = this.elemRes[0].attrValues.length;
            for (int i = 0; ret == -1 && i < size; ++i) {
                String val = this.elemRes[0].attrValues[i].attrValues.valName;
                if (val.compareToIgnoreCase(name) != 0) continue;
                ret = i;
            }
        }
        return ret;
    }

    public void sort(int colIdx, boolean asc) {
        if (colIdx >= 0 && colIdx < this.getColumnCount()) {
            int size;
            Comparator comparator = null;
            if (this.elemRes != null && (size = this.elemRes.length) > 0) {
                int i;
                TS_UnionSeq union = this.elemRes[0].attrValues[colIdx].attrValues.value.u;
                switch (union.discriminator().value()) {
                    case 1: {
                        union = this.elemRes[0].attrValues[colIdx].attrValues.value.u;
                        comparator = new StringComparator(union.stringVal(), asc);
                        break;
                    }
                    case 10: {
                        union = this.elemRes[0].attrValues[colIdx].attrValues.value.u;
                        comparator = new DateComparator(union.dateVal(), asc);
                        break;
                    }
                    case 2: {
                        union = this.elemRes[0].attrValues[colIdx].attrValues.value.u;
                        comparator = new ShortComparator(union.shortVal(), asc);
                        break;
                    }
                    case 5: {
                        union = this.elemRes[0].attrValues[colIdx].attrValues.value.u;
                        comparator = new ByteComparator(union.byteVal(), asc);
                        break;
                    }
                    case 6: 
                    case 30: {
                        union = this.elemRes[0].attrValues[colIdx].attrValues.value.u;
                        comparator = new IntComparator(union.longVal(), asc);
                        break;
                    }
                    case 7: {
                        union = this.elemRes[0].attrValues[colIdx].attrValues.value.u;
                        comparator = new DoubleComparator(union.doubleVal(), asc);
                        break;
                    }
                    case 3: {
                        union = this.elemRes[0].attrValues[colIdx].attrValues.value.u;
                        comparator = new FloatComparator(union.floatVal(), asc);
                        break;
                    }
                    case 8: {
                        union = this.elemRes[0].attrValues[colIdx].attrValues.value.u;
                        comparator = new LongLongComparator(union.longlongVal(), asc);
                        break;
                    }
                    default: {
                        String[] arr = this.getColumnStringValue(colIdx);
                        comparator = new StringComparator(arr, asc);
                        break;
                    }
                }
                int rowCount = this.getRowCount();
                Integer[] idx = new Integer[rowCount];
                for (i = 0; i < rowCount; ++i) {
                    idx[i] = new Integer(i);
                }
                Arrays.sort(idx, comparator);
                this.sortIdx = new int[rowCount];
                for (i = 0; i < rowCount; ++i) {
                    this.sortIdx[i] = idx[i];
                }
            }
        } else {
            this.sortIdx = null;
        }
    }

    public void sort(String name, boolean asc) {
        int idx = this.findColumn(name);
        if (idx >= 0) {
            this.sort(idx, asc);
        }
    }

    public int getColumnDisplaySize(int column) {
        int ret = 0;
        if (this.charWidth == null) {
            this.charWidth = new int[this.getColumnCount()];
            Arrays.fill(this.charWidth, -1);
        }
        if (column < this.charWidth.length) {
            if (this.charWidth[column] == -1) {
                String[] arr = this.getColumnStringValue(column);
                int size = arr.length;
                for (int i = 0; i < size; ++i) {
                    ret = Math.max(ret, arr[i].length());
                }
                this.charWidth[column] = ret;
            } else {
                ret = this.charWidth[column];
            }
        }
        return ret;
    }

    public String[] getRowStringValue(int row) {
        int cCount = this.getColumnCount();
        String[] ret = new String[cCount];
        for (int i = 0; i < cCount; ++i) {
            ret[i] = this.getColumnStringValue(i)[row];
        }
        return ret;
    }

    public String getCellStringValue(int column, int row) {
        if (this.sortIdx != null) {
            return this.getColumnStringValue(column)[this.sortIdx[row]];
        }
        return this.getColumnStringValue(column)[row];
    }

    public String[] getColumnStringValue(int column) {
        String[] ret = new String[]{};
        if (this.stringVal == null) {
            this.stringVal = new Object[this.getColumnCount()];
        }
        if (column < this.stringVal.length) {
            if (this.elemRes != null) {
                if (this.stringVal[column] == null) {
                    SimpleDateFormat odsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    SimpleDateFormat dateFormat = this.locale.getLanguage().compareTo("de") == 0 ? new SimpleDateFormat("dd.MM.yyyy HH:mm:ss") : new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aaa");
                    int size = this.elemRes.length;
                    Vector<String> vec = new Vector<String>();
                    for (int j = 0; j < size; ++j) {
                        TS_UnionSeq union = this.elemRes[j].attrValues[column].attrValues.value.u;
                        String[] sArr = null;
                        if (union != null && union.discriminator() != null) {
                            try {
                                switch (union.discriminator().value()) {
                                    case 1: {
                                        sArr = union.stringVal();
                                        break;
                                    }
                                    case 2: {
                                        short[] farr = union.shortVal();
                                        sArr = new String[farr.length];
                                        for (int x = 0; x < farr.length; ++x) {
                                            sArr[x] = "" + farr[x];
                                        }
                                        break;
                                    }
                                    case 3: {
                                        float[] farr = union.floatVal();
                                        sArr = new String[farr.length];
                                        for (int x = 0; x < farr.length; ++x) {
                                            sArr[x] = "" + farr[x];
                                        }
                                        break;
                                    }
                                    case 5: {
                                        byte[] barr = union.byteVal();
                                        sArr = new String[barr.length];
                                        for (int x = 0; x < barr.length; ++x) {
                                            sArr[x] = Integer.toString(barr[x], 16);
                                        }
                                        break;
                                    }
                                    case 4: {
                                        boolean[] barr = union.booleanVal();
                                        sArr = new String[barr.length];
                                        for (int x = 0; x < barr.length; ++x) {
                                            sArr[x] = "" + barr[x];
                                        }
                                        break;
                                    }
                                    case 6: {
                                        int[] larr = union.longVal();
                                        sArr = new String[larr.length];
                                        for (int x = 0; x < larr.length; ++x) {
                                            sArr[x] = "" + larr[x];
                                        }
                                        break;
                                    }
                                    case 7: {
                                        double[] darr = union.doubleVal();
                                        sArr = new String[darr.length];
                                        for (int x = 0; x < darr.length; ++x) {
                                            sArr[x] = "" + darr[x];
                                        }
                                        break;
                                    }
                                    case 8: {
                                        T_LONGLONG[] larr = union.longlongVal();
                                        sArr = new String[larr.length];
                                        for (int x = 0; x < larr.length; ++x) {
                                            sArr[x] = OdsxHelper.t_longlongToString(larr[x]);
                                        }
                                        break;
                                    }
                                    case 13: {
                                        T_COMPLEX[] larr = union.complexVal();
                                        sArr = new String[larr.length];
                                        for (int x = 0; x < larr.length; ++x) {
                                            sArr[x] = OdsxHelper.t_complexToString(larr[x]);
                                        }
                                        break;
                                    }
                                    case 14: {
                                        T_DCOMPLEX[] larr = union.dcomplexVal();
                                        sArr = new String[larr.length];
                                        for (int x = 0; x < larr.length; ++x) {
                                            sArr[x] = OdsxHelper.t_dcomplexToString(larr[x]);
                                        }
                                        break;
                                    }
                                    case 10: {
                                        sArr = union.dateVal();
                                        ParsePosition pos = new ParsePosition(0);
                                        for (int x = 0; x < sArr.length; ++x) {
                                            Date date = odsFormat.parse(sArr[x], pos);
                                            pos.setIndex(0);
                                            if (date == null) continue;
                                            sArr[x] = dateFormat.format(date);
                                        }
                                        break;
                                    }
                                    case 30: {
                                        int[] larr = union.enumVal();
                                        sArr = new String[larr.length];
                                        for (int x = 0; x < larr.length; ++x) {
                                            sArr[x] = "" + larr[x];
                                        }
                                        break;
                                    }
                                    case 11: {
                                        break;
                                    }
                                    case 28: {
                                        T_ExternalReference[] eArr = union.extRefVal();
                                        sArr = new String[eArr.length];
                                        for (int x = 0; x < eArr.length; ++x) {
                                            sArr[x] = OdsxHelper.valToString(eArr[x]);
                                        }
                                        break;
                                    }
                                    default: {
                                        sArr = null;
                                    }
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        if (sArr == null || sArr.length <= 0) continue;
                        for (int x = 0; x < sArr.length; ++x) {
                            vec.add(sArr[x]);
                        }
                    }
                    this.stringVal[column] = ret = vec.toArray(new String[vec.size()]);
                } else {
                    try {
                        ret = (String[])this.stringVal[column];
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        ret = null;
                    }
                }
            } else {
                try {
                    ret = (String[])this.stringVal[column];
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ret = null;
                }
            }
        }
        if (ret == null) {
            ret = new String[]{};
        } else if (this.sortIdx != null) {
            int len = ret.length;
            String[] tmp = new String[len];
            for (int i = 0; i < len; ++i) {
                tmp[i] = ret[this.sortIdx[i]];
            }
            ret = tmp;
        }
        return ret;
    }

    public Object[] getAttributeValues(int column) {
        NameValueSeqUnitId[] ret = null;
        if (column >= 0 && column < this.getColumnCount()) {
            ret = new NameValueSeqUnitId[this.elemRes[column].attrValues.length];
            System.arraycopy(this.elemRes[column].attrValues, 0, ret, 0, ret.length);
        }
        return ret;
    }

    public int getColumnCount() {
        int ret = 0;
        if (this.elemRes != null && this.elemRes.length > 0) {
            ret = this.elemRes[0].attrValues.length;
        } else if (this.stringVal != null && this.stringVal.length > 0) {
            ret = 1;
        }
        return ret;
    }

    public int getRowCount() {
        int ret = 0;
        if (this.stringVal == null) {
            this.getColumnStringValue(0);
        }
        if (this.stringVal != null && this.stringVal.length > 0) {
            ret = ((String[])this.stringVal[0]).length;
        }
        return ret;
    }

    public ResultColumnInterface[] getResultColumns() {
        ResultColumnInterface[] ret;
        int colCount = this.getColumnCount();
        if (colCount > 0) {
            ret = new ResultColumn[colCount];
            String[] names = this.listColumns("*");
            for (int j = 0; j < colCount; ++j) {
                String[] arr;
                ret[j] = new ResultColumn(names[j]);
                try {
                    arr = this.getColumnStringValue(j);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    arr = new String[]{};
                }
                int aSize = arr.length;
                for (int i = 0; i < aSize; ++i) {
                    ((ResultColumn)ret[j]).add(arr[i]);
                }
            }
        } else {
            ret = new ResultColumn[]{};
        }
        return ret;
    }

    public ElemResultSet[] getElemResultSet() {
        return this.elemRes;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.stringVal = null;
    }

    protected static class FloatComparator
    implements Comparator {
        float[] arr;
        boolean asc;

        FloatComparator(float[] arr, boolean asc) {
            this.arr = arr;
            this.asc = asc;
        }

        public int compare(Object o1, Object o2) {
            if (this.asc) {
                return (int)(this.arr[(Integer)o1] - this.arr[(Integer)o2]);
            }
            return (int)(this.arr[(Integer)o2] - this.arr[(Integer)o1]);
        }
    }

    protected static class LongLongComparator
    implements Comparator {
        T_LONGLONG[] arr;
        boolean asc;

        LongLongComparator(T_LONGLONG[] arr, boolean asc) {
            this.arr = arr;
            this.asc = asc;
        }

        public int compare(Object o1, Object o2) {
            long l1 = OdsxHelper.t_longlongToLong(this.arr[(Integer)o1]);
            long l2 = OdsxHelper.t_longlongToLong(this.arr[(Integer)o2]);
            if (this.asc) {
                return (int)(l1 - l2);
            }
            return (int)(l2 - l1);
        }
    }

    protected static class DoubleComparator
    implements Comparator {
        double[] arr;
        boolean asc;

        DoubleComparator(double[] arr, boolean asc) {
            this.arr = arr;
            this.asc = asc;
        }

        public int compare(Object o1, Object o2) {
            if (this.asc) {
                return (int)(this.arr[(Integer)o1] - this.arr[(Integer)o2]);
            }
            return (int)(this.arr[(Integer)o2] - this.arr[(Integer)o1]);
        }
    }

    protected static class ByteComparator
    implements Comparator {
        byte[] arr;
        boolean asc;

        ByteComparator(byte[] arr, boolean asc) {
            this.arr = arr;
            this.asc = asc;
        }

        public int compare(Object o1, Object o2) {
            if (this.asc) {
                return this.arr[(Integer)o1] - this.arr[(Integer)o2];
            }
            return this.arr[(Integer)o2] - this.arr[(Integer)o1];
        }
    }

    protected static class IntComparator
    implements Comparator {
        int[] arr;
        boolean asc;

        IntComparator(int[] arr, boolean asc) {
            this.arr = arr;
            this.asc = asc;
        }

        public int compare(Object o1, Object o2) {
            if (this.asc) {
                return this.arr[(Integer)o1] - this.arr[(Integer)o2];
            }
            return this.arr[(Integer)o2] - this.arr[(Integer)o1];
        }
    }

    protected static class ShortComparator
    implements Comparator {
        short[] arr;
        boolean asc;

        ShortComparator(short[] arr, boolean asc) {
            this.arr = arr;
            this.asc = asc;
        }

        public int compare(Object o1, Object o2) {
            if (this.asc) {
                return this.arr[(Integer)o1] - this.arr[(Integer)o2];
            }
            return this.arr[(Integer)o2] - this.arr[(Integer)o1];
        }
    }

    protected static class DateComparator
    implements Comparator {
        String[] arr;
        boolean asc;

        DateComparator(String[] arr, boolean asc) {
            this.arr = arr;
            this.asc = asc;
        }

        public int compare(Object o1, Object o2) {
            if (this.asc) {
                return this.arr[(Integer)o1].compareTo(this.arr[(Integer)o2]);
            }
            return this.arr[(Integer)o2].compareTo(this.arr[(Integer)o1]);
        }
    }

    protected static class StringComparator
    implements Comparator {
        String[] arr;
        boolean asc;

        StringComparator(String[] arr, boolean asc) {
            this.arr = arr;
            this.asc = asc;
        }

        public int compare(Object o1, Object o2) {
            if (this.asc) {
                return this.arr[(Integer)o1].toUpperCase().compareTo(this.arr[(Integer)o2].toUpperCase());
            }
            return this.arr[(Integer)o2].toUpperCase().compareTo(this.arr[(Integer)o1].toUpperCase());
        }
    }
}

