/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hql;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.fwk.util.StringUtilities;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.hql.HQL;
import com.highqsoft.odsx.hql.ResultColumn;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.asam.ods.AIDName;
import org.asam.ods.AIDNameUnitId;
import org.asam.ods.AIDNameValueUnitId;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.BaseAttribute;
import org.asam.ods.BaseElement;
import org.asam.ods.ElemResultSet;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.NameValueUnit;
import org.asam.ods.QueryStructure;
import org.asam.ods.SelOpcode;
import org.asam.ods.SelOperator;
import org.asam.ods.SelValue;
import org.asam.ods.TS_Union;
import org.asam.ods.TS_UnionSeq;
import org.asam.ods.TS_Value;
import org.asam.ods.T_COMPLEX;
import org.asam.ods.T_DCOMPLEX;
import org.asam.ods.T_LONGLONG;

public class OdsxSelectConvert {
    protected static final String SPACES;
    public static final String SELECT = "SELECT";
    public static final String FROM = "FROM";
    public static final String WHERE = "WHERE";
    protected static final String braces = "()";
    protected static final String operators = "<>=!&|";
    protected static final HashMap operatorList;
    protected static final HashMap operatorInvList;
    protected static final String delimiter = " \t\n\r'\",";
    protected String lastToken;
    protected String upperToken;

    protected String getToken(StringTokenizer st) {
        this.lastToken = st.nextToken();
        this.upperToken = this.lastToken.toUpperCase();
        return this.lastToken;
    }

    public HashMap parse(String statement) {
        HashMap ret = new HashMap();
        StringTokenizer st = new StringTokenizer(statement, " \t\n\r'\",<>=!&|()", true);
        while (st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (!this.upperToken.equals(SELECT)) continue;
            this.parseSelect(st, ret);
        }
        return ret;
    }

    protected void parseSelect(StringTokenizer st, HashMap map) {
        Vector<String> ret = new Vector<String>();
        while (st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (this.upperToken.equals(FROM)) {
                this.parseFrom(st, map);
                continue;
            }
            if (this.upperToken.equals(WHERE)) {
                this.parseWhere(st, map);
                continue;
            }
            if (this.lastToken.charAt(0) == '\'' || this.lastToken.charAt(0) == '\"') {
                ret.add(this.parseString(st));
                continue;
            }
            if (delimiter.indexOf(this.lastToken) >= 0 || braces.indexOf(this.lastToken) >= 0) continue;
            ret.add(this.lastToken);
        }
        if (ret.size() > 0) {
            map.put(SELECT, ret);
        }
    }

    protected void parseFrom(StringTokenizer st, HashMap map) {
        Vector<String> ret = new Vector<String>();
        while (st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (this.upperToken.equals(WHERE)) {
                this.parseWhere(st, map);
                continue;
            }
            if (this.lastToken.charAt(0) == '\'' || this.lastToken.charAt(0) == '\"') {
                ret.add(this.parseString(st));
                continue;
            }
            if (delimiter.indexOf(this.lastToken) >= 0 || braces.indexOf(this.lastToken) >= 0) continue;
            ret.add(this.lastToken);
        }
        if (ret.size() > 0) {
            map.put(FROM, ret);
        }
    }

    protected void parseWhere(StringTokenizer st, HashMap map) {
        Vector ret = this.parseConditions(st);
        if (ret.size() > 0) {
            map.put(WHERE, ret);
        }
    }

    public Vector parseConditions(StringTokenizer st) {
        Vector<Object> ret = new Vector<Object>();
        int openbrace = 0;
        if (this.lastToken.charAt(0) == '(') {
            openbrace = 1;
        }
        block10: while (st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (this.lastToken.charAt(0) == '\'' || this.lastToken.charAt(0) == '\"') {
                ret.add(this.parseString(st));
                continue;
            }
            if (this.lastToken.length() == 1) {
                if (delimiter.indexOf(this.lastToken) >= 0) continue;
                switch (this.lastToken.charAt(0)) {
                    case '(': {
                        ret.add(this.parseConditions(st));
                        continue block10;
                    }
                    case ')': {
                        if (--openbrace != 0) {
                            if (openbrace > 0) {
                                System.err.println("Error: Too much open braces in where clause.");
                            } else {
                                System.err.println("Error: Too much close braces in where clause.");
                            }
                        }
                        return ret;
                    }
                    case '&': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block10;
                    }
                    case '|': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block10;
                    }
                    case '<': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block10;
                    }
                    case '>': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block10;
                    }
                    case '=': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block10;
                    }
                    case '!': {
                        this.handleParsedOperator(ret, this.upperToken);
                        continue block10;
                    }
                }
                continue;
            }
            if (this.upperToken.equals("IN")) {
                if (ret.size() > 0) {
                    String s = (String)ret.get(ret.size() - 1);
                    if (s.equals("!")) {
                        ret.set(ret.size() - 1, "!IN");
                        continue;
                    }
                    ret.add("IN");
                    continue;
                }
                ret.add("IN");
                continue;
            }
            ret.add(this.lastToken);
        }
        if (openbrace != 0) {
            if (openbrace > 0) {
                System.err.println("Error: Too much open braces in where clause.");
            } else {
                System.err.println("Error: Too much close braces in where clause.");
            }
        }
        return ret;
    }

    protected String parseString(StringTokenizer st) {
        StringBuffer ret = new StringBuffer();
        char startToken = this.lastToken.charAt(0);
        boolean stop = false;
        while (!stop && st.hasMoreTokens()) {
            this.lastToken = this.getToken(st);
            if (this.lastToken.charAt(0) != startToken) {
                ret = ret.append(this.lastToken);
                continue;
            }
            if (ret.length() > 0) {
                if (ret.charAt(ret.length() - 1) != '\\') {
                    stop = true;
                    continue;
                }
                ret = ret.replace(ret.length() - 1, ret.length(), this.lastToken);
                continue;
            }
            stop = true;
        }
        return ret.toString();
    }

    public boolean handleParsedOperator(Vector vec, String upperToken) {
        boolean ret = false;
        if (vec.size() > 0) {
            if (vec.get(vec.size() - 1) instanceof String) {
                String s = (String)vec.get(vec.size() - 1);
                if ((s = s + upperToken).equals(">=") || s.equals("<=") || s.equals("==") || s.equals("!=") || s.equals("&&") || s.equals("!IN") || s.equals("||")) {
                    vec.set(vec.size() - 1, s);
                    ret = true;
                } else {
                    vec.add(upperToken);
                    ret = true;
                }
            } else {
                vec.add(upperToken);
                ret = true;
            }
        } else {
            vec.add(upperToken);
            ret = true;
        }
        return ret;
    }

    public QueryStructure getQueryStructure(AoSession session, HashMap map) throws AoException {
        ApplicationStructure asObj = session.getApplicationStructure();
        Vector from = (Vector)map.get(FROM);
        if (from == null) {
            System.err.println("ERROR: From clause missing.");
            return null;
        }
        int size = from.size();
        if (size > 1) {
            System.err.println("WARNING: Selection from more than one element is currently not supported.");
        }
        String element = (String)from.get(0);
        String upper = element.toUpperCase();
        ApplicationElement[] aeObj = null;
        InstanceElement[] ieObj = null;
        if (upper.startsWith("IE.")) {
            String ieName;
            String spec = element.substring(3, element.length());
            String aeName = StringUtilities.substring((String)StringUtilities.substring((String)spec, (char)']', (int)-1), (char)'[', (int)1);
            aeObj = this.getApplicationElements(asObj, aeName);
            InstanceElement ie = aeObj[0].getInstanceByName(ieName = StringUtilities.substring((String)element, (char)']', (int)1));
            if (ie == null) {
                String name = StringUtilities.substring((String)ieName, (char)';', (int)-1);
                String version = ieName.substring(name.length() + 1);
                InstanceElementIterator ii = aeObj[0].getInstances(name);
                int count = ii.getCount();
                if (count == 1) {
                    ieObj = new InstanceElement[]{ii.nextOne()};
                } else {
                    ApplicationAttribute aaVersion = aeObj[0].getAttributeByBaseName("version");
                    Vector<InstanceElement> ieVec = new Vector<InstanceElement>();
                    for (int i = 0; i < count; ++i) {
                        ie = ii.nextOne();
                        NameValueUnit nvu = ie.getValue(aaVersion.getName());
                        if (!Pattern.match((String)OdsxHelper.ts_valueToString(nvu.value), (String)version, (boolean)false)) continue;
                        ieVec.add(ie);
                    }
                    if (ieVec.size() > 0) {
                        ieObj = ieVec.toArray(new InstanceElement[ieVec.size()]);
                    }
                }
                ii.destroy();
            } else {
                ieObj = new InstanceElement[]{ie};
            }
            if (ieObj == null) {
                System.err.println("ERROR: Instance element <" + element + "> not found.");
            }
            aeObj = null;
        } else {
            aeObj = this.getApplicationElements(asObj, element);
        }
        if (ieObj != null) {
            System.err.println("Instance selection is currently not supported.");
            return null;
        }
        if (aeObj != null && aeObj.length > 1) {
            System.err.println("Multi application element selection is currently not supported.");
            return null;
        }
        Vector select = (Vector)map.get(SELECT);
        QueryStructure ret = new QueryStructure();
        if (select == null || select.size() == 0) {
            ret.anuSeq = new AIDNameUnitId[1];
            ret.anuSeq[0] = new AIDNameUnitId();
            ret.anuSeq[0].attr = new AIDName();
            ret.anuSeq[0].attr.aid = aeObj[0].getId();
        } else {
            ret.anuSeq = this.getAIDNameUnitId(aeObj, select);
        }
        Vector where = (Vector)map.get(WHERE);
        if (where != null && where.size() != 0) {
            Vector selOp = new Vector();
            Vector selValues = this.getSelValue(aeObj, where, null, selOp);
            if (selValues != null && selValues.size() != 0) {
                ret.condSeq = selValues.toArray(new SelValue[selValues.size()]);
            }
            if (selOp != null && selOp.size() != 0) {
                ret.operSeq = selOp.toArray(new SelOperator[selOp.size()]);
            }
        }
        return ret;
    }

    protected Vector getSelValue(ApplicationElement[] aeObj, Vector where, Vector selVal, Vector selOp) {
        int size;
        if (selVal == null) {
            selVal = new Vector<SelValue>();
        }
        if ((size = where.size()) > 0) {
            selOp.add(operatorList.get("("));
            if (where.get(0) instanceof String) {
                if (size == 3) {
                    String field = (String)where.get(0);
                    String op = (String)where.get(1);
                    String val = (String)where.get(2);
                    if (operatorList.get(op) != null) {
                        SelValue s = this.getSelValue(aeObj, field, op, val);
                        if (s != null) {
                            selVal.add(s);
                        }
                    } else {
                        System.err.println("ERROR(2): Syntax error in where clause.");
                    }
                } else if (size > 3) {
                    if (operatorList.get(where.get(3)) != null) {
                        Vector vec = new Vector();
                        for (int i = 0; i < 3; ++i) {
                            vec.add(where.get(0));
                            where.remove(0);
                        }
                        selOp.remove(selOp.get(selOp.size() - 1));
                        this.getSelValue(aeObj, where, selVal, selOp);
                    } else {
                        System.err.println("ERROR(3): Syntax error in where clause.");
                    }
                } else {
                    System.err.println("ERROR(4): Syntax error in where clause.");
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    Object elem = where.get(i);
                    if (elem instanceof String) {
                        if (operatorList.get(elem) != null) {
                            selOp.add(operatorList.get(elem));
                            continue;
                        }
                        System.err.println("ERROR(5): Syntax error in where clause.");
                        continue;
                    }
                    this.getSelValue(aeObj, (Vector)elem, selVal, selOp);
                }
            }
            selOp.add(operatorList.get(")"));
        }
        return selVal;
    }

    protected SelValue getSelValue(ApplicationElement[] aeObj, String field, String op, String val) {
        SelValue ret;
        block7: {
            ret = null;
            try {
                SelOpcode opCode = (SelOpcode)operatorList.get(op);
                if (opCode != null) {
                    ApplicationAttribute[][] aarr = this.getAttributes(aeObj, field);
                    if (aarr == null) break block7;
                    ApplicationAttribute aa = null;
                    int aeIndex = -1;
                    for (int i = 0; aa == null && i < aarr.length; ++i) {
                        if (aarr[i] != null) {
                            for (int j = 0; aa == null && j < aarr[i].length; ++j) {
                                aa = aarr[i][j];
                                aeIndex = i;
                            }
                            continue;
                        }
                        System.err.println("ERROR: Syntax error in where clause near -> " + field + " " + op + " " + val);
                    }
                    if (aa != null) {
                        AIDNameValueUnitId nvu = new AIDNameValueUnitId();
                        nvu.attr = new AIDName();
                        nvu.attr.aid = aeObj[aeIndex].getId();
                        nvu.attr.aaName = aa.getName();
                        TS_Union u = OdsxHelper.parseTS_Union(aa.getDataType(), val);
                        ret = new SelValue(nvu, opCode, new TS_Value(u, 15));
                    }
                    break block7;
                }
                System.err.println("ERROR: Unknown opcode in where clause.");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return ret;
    }

    protected AIDNameUnitId[] getAIDNameUnitId(ApplicationElement[] aeObj, Vector colSpec) {
        AIDNameUnitId[] nui;
        int i;
        AIDNameUnitId[] ret = null;
        Vector<AIDNameUnitId[]> vec = new Vector<AIDNameUnitId[]>();
        int size = colSpec.size();
        int count = 0;
        for (i = 0; i < size; ++i) {
            nui = this.getAIDNameUnitId(aeObj, (String)colSpec.get(i));
            if (nui == null || nui.length == 0) continue;
            count += nui.length;
            vec.add(nui);
        }
        if (vec.size() > 0 && count > 0) {
            ret = new AIDNameUnitId[count];
            count = 0;
            size = vec.size();
            for (i = 0; i < size; ++i) {
                nui = (AIDNameUnitId[])vec.get(i);
                System.arraycopy(nui, 0, ret, count, nui.length);
                count += nui.length;
            }
        }
        return ret;
    }

    protected AIDNameUnitId[] getAIDNameUnitId(ApplicationElement[] aeObj, String spec) {
        AIDNameUnitId[] ret = null;
        AIDNameUnitId aid = null;
        Vector<AIDNameUnitId> vec = new Vector<AIDNameUnitId>();
        int alen = aeObj.length;
        for (int i = 0; i < alen; ++i) {
            try {
                ApplicationAttribute[] aa = this.getApplicationAttributes(aeObj[i], spec);
                if (aa != null && aa.length > 0) {
                    T_LONGLONG aeId = aeObj[i].getId();
                    int rlen = aa.length;
                    for (int j = 0; j < rlen; ++j) {
                        aid = new AIDNameUnitId();
                        aid.attr = new AIDName();
                        aid.attr.aid = aeId;
                        aid.attr.aaName = aa[j].getName();
                        vec.add(aid);
                    }
                    continue;
                }
                System.out.println("ERROR: Syntax error in select statement near -> " + spec);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (vec.size() > 0) {
            ret = vec.toArray(new AIDNameUnitId[vec.size()]);
        }
        return ret;
    }

    protected ApplicationAttribute[][] getAttributes(InstanceElement[] ieObj, String spec) throws AoException {
        ApplicationElement[] aeObj = new ApplicationElement[ieObj.length];
        int size = ieObj.length;
        for (int i = 0; i < size; ++i) {
            aeObj[i] = ieObj[i].getApplicationElement();
        }
        return this.getAttributes(aeObj, spec);
    }

    protected ApplicationAttribute[][] getAttributes(ApplicationElement[] aeObj, String spec) throws AoException {
        ApplicationAttribute[][] ret = new ApplicationAttribute[aeObj.length][];
        int size = aeObj.length;
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getApplicationAttributes(aeObj[i], spec);
        }
        return ret;
    }

    protected ApplicationAttribute[] getApplicationAttributes(ApplicationElement aeObj, String spec) throws AoException {
        ApplicationAttribute[] ret;
        block12: {
            ret = null;
            try {
                ApplicationAttribute[] arr = aeObj.getAttributes(spec);
                if (arr != null && arr.length != 0) {
                    ret = arr;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (ret == null) {
                String upper = spec.toUpperCase();
                if (upper.startsWith("BA.")) {
                    String type = spec.substring(3, spec.length());
                    try {
                        BaseElement beObj = aeObj.getBaseElement();
                        BaseAttribute[] arr = beObj.getAttributes(type);
                        if (arr == null || arr.length == 0) break block12;
                        Vector<ApplicationAttribute> vec = new Vector<ApplicationAttribute>();
                        int size = arr.length;
                        for (int i = 0; i < size; ++i) {
                            vec.add(aeObj.getAttributeByBaseName(arr[i].getName()));
                        }
                        if (vec.size() > 0) {
                            ret = vec.toArray(new ApplicationAttribute[vec.size()]);
                        }
                    }
                    catch (Throwable tBE) {
                        ret = this.getApplicationAttributes(aeObj, type);
                    }
                } else if (upper.startsWith("AA.")) {
                    String name = spec.substring(3, spec.length());
                    ret = this.getApplicationAttributes(aeObj, name);
                }
            }
        }
        if (ret != null && ret.length == 0) {
            ret = null;
        }
        return ret;
    }

    protected ApplicationElement[] getApplicationElements(ApplicationStructure asObj, String spec) throws AoException {
        ApplicationElement[] ret = null;
        try {
            ApplicationElement[] arr = asObj.getElements(spec);
            if (arr != null && arr.length != 0) {
                ret = arr;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (ret == null) {
            String upper = spec.toUpperCase();
            if (upper.startsWith("BE.")) {
                String type = spec.substring(3, spec.length());
                try {
                    ret = asObj.getElementsByBaseType(type);
                }
                catch (Throwable tBE) {
                    ret = this.getApplicationElements(asObj, type);
                }
            } else if (upper.startsWith("AE.")) {
                String name = spec.substring(3, spec.length());
                ret = this.getApplicationElements(asObj, name);
            }
        }
        if (ret != null && ret.length == 0) {
            ret = null;
        }
        return ret;
    }

    public String getSelectStatement(AoSession session, QueryStructure query) throws AoException {
        int size;
        ApplicationStructure asObj = session.getApplicationStructure();
        StringBuffer ret = new StringBuffer();
        ret.append("SELECT ");
        FwkSortedArray aeElem = new FwkSortedArray();
        if (query.anuSeq != null && query.anuSeq.length != 0) {
            size = query.anuSeq.length;
            for (int i = 0; i < size; ++i) {
                AIDNameUnitId nui = query.anuSeq[i];
                ApplicationElement aeObj = asObj.getElementById(nui.attr.aid);
                if (i != 0) {
                    ret.append(", ");
                }
                String name = aeObj.getName();
                aeElem.add((Comparable)((Object)name));
                if (nui.attr.aaName == null || nui.attr.aaName.length() == 0) continue;
                try {
                    ApplicationAttribute aaObj = aeObj.getAttributeByName(nui.attr.aaName);
                    BaseAttribute baObj = aaObj.getBaseAttribute();
                    ret.append("BA." + baObj.getName());
                    continue;
                }
                catch (Throwable t) {
                    ret.append("AA." + nui.attr.aaName);
                }
            }
        }
        if ((size = aeElem.size()) > 0) {
            ret.append(" FROM ");
        }
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                ret.append(", ");
            }
            ret.append(aeElem.get(i));
        }
        SelOperator[] operator = query.operSeq;
        if (operator == null || operator.length == 0) {
            operator = new SelOperator[]{SelOperator.OPEN, SelOperator.CLOSE};
        }
        int opSize = operator.length;
        if (query.condSeq != null && query.condSeq.length != 0) {
            SelValue[] selValue = query.condSeq;
            size = query.condSeq.length;
            ret.append(" WHERE ");
            int selCount = 0;
            for (int i = 0; i < opSize; ++i) {
                if (operator[i] == SelOperator.OPEN) {
                    ret.append("(");
                    continue;
                }
                if (operator[i] == SelOperator.OPEN) {
                    ret.append(")");
                    continue;
                }
                ret.append(this.getConditionString(asObj, selValue[selCount++]));
                String key = (String)operatorInvList.get(operator[i]);
                if (key != null) {
                    ret.append(" " + key + " ");
                }
                if (i + 1 >= opSize || operator[i + 1] == SelOperator.OPEN) continue;
                ret.append(this.getConditionString(asObj, selValue[selCount++]));
            }
        }
        return ret.toString();
    }

    public String getConditionString(ApplicationStructure asObj, SelValue selValue) {
        StringBuffer ret = new StringBuffer();
        if (operatorInvList.get(selValue.oper) != null) {
            try {
                String aaName = selValue.attr.attr.aaName;
                ApplicationElement aeObj = asObj.getElementById(selValue.attr.attr.aid);
                ApplicationAttribute aaObj = aeObj.getAttributeByName(aaName);
                String baName = null;
                try {
                    BaseAttribute baObj = aaObj.getBaseAttribute();
                    baName = baObj.getName();
                }
                catch (Throwable tBA) {
                    // empty catch block
                }
                if (baName != null) {
                    ret.append("BA." + baName);
                } else {
                    ret.append("AA." + aaName);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ret.append(" " + operatorInvList.get(selValue.oper) + " ");
            ret.append(OdsxHelper.ts_valueToString(selValue.value));
        } else {
            System.out.println("ERROR: Unknown operation <" + selValue.oper + ">");
        }
        return ret.toString();
    }

    public static void printElemResultSet(PrintStream out, ElemResultSet[] elemRes) {
        if (elemRes != null && elemRes.length > 0) {
            ResultColumn[] cols = new ResultColumn[elemRes[0].attrValues.length];
            for (int j = 0; j < elemRes[0].attrValues.length; ++j) {
                cols[j] = new ResultColumn(elemRes[0].attrValues[j].attrValues.valName);
            }
            for (int i = 0; i < elemRes.length; ++i) {
                for (int j = 0; j < elemRes[i].attrValues.length; ++j) {
                    TS_UnionSeq union = elemRes[i].attrValues[j].attrValues.value.u;
                    String[] sArr = null;
                    if (union != null && union.discriminator() != null) {
                        try {
                            switch (union.discriminator().value()) {
                                case 1: {
                                    sArr = union.stringVal();
                                    break;
                                }
                                case 2: {
                                    int x;
                                    short[] farr = union.shortVal();
                                    sArr = new String[farr.length];
                                    for (x = 0; x < farr.length; ++x) {
                                        sArr[x] = "" + farr[x];
                                    }
                                    break;
                                }
                                case 3: {
                                    int x;
                                    float[] farr = union.floatVal();
                                    sArr = new String[farr.length];
                                    for (x = 0; x < farr.length; ++x) {
                                        sArr[x] = "" + farr[x];
                                    }
                                    break;
                                }
                                case 5: {
                                    int x;
                                    byte[] barr = union.byteVal();
                                    sArr = new String[barr.length];
                                    for (x = 0; x < barr.length; ++x) {
                                        sArr[x] = Integer.toString(barr[x], 16);
                                    }
                                    break;
                                }
                                case 4: {
                                    int x;
                                    boolean[] barr = union.booleanVal();
                                    sArr = new String[barr.length];
                                    for (x = 0; x < barr.length; ++x) {
                                        sArr[x] = "" + barr[x];
                                    }
                                    break;
                                }
                                case 6: {
                                    int x;
                                    int[] larr = union.longVal();
                                    sArr = new String[larr.length];
                                    for (x = 0; x < larr.length; ++x) {
                                        sArr[x] = "" + larr[x];
                                    }
                                    break;
                                }
                                case 7: {
                                    int x;
                                    double[] darr = union.doubleVal();
                                    sArr = new String[darr.length];
                                    for (x = 0; x < darr.length; ++x) {
                                        sArr[x] = "" + darr[x];
                                    }
                                    break;
                                }
                                case 8: {
                                    int x;
                                    T_LONGLONG[] larr = union.longlongVal();
                                    sArr = new String[larr.length];
                                    for (x = 0; x < larr.length; ++x) {
                                        sArr[x] = "" + OdsxHelper.t_longlongToString(larr[x]);
                                    }
                                    break;
                                }
                                case 13: {
                                    int x;
                                    T_COMPLEX[] larr = union.complexVal();
                                    sArr = new String[larr.length];
                                    for (x = 0; x < larr.length; ++x) {
                                        sArr[x] = OdsxHelper.t_complexToString(larr[x]);
                                    }
                                    break;
                                }
                                case 14: {
                                    int x;
                                    T_DCOMPLEX[] larr = union.dcomplexVal();
                                    sArr = new String[larr.length];
                                    for (x = 0; x < larr.length; ++x) {
                                        sArr[x] = OdsxHelper.t_dcomplexToString(larr[x]);
                                    }
                                    break;
                                }
                                case 10: {
                                    sArr = union.dateVal();
                                    break;
                                }
                                case 11: {
                                    break;
                                }
                                case 28: {
                                    break;
                                }
                                default: {
                                    sArr = null;
                                }
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (sArr == null || sArr.length <= 0) continue;
                    for (int x = 0; x < sArr.length; ++x) {
                        cols[j].add(sArr[x]);
                    }
                }
            }
            OdsxSelectConvert.printCols(out, cols);
        }
    }

    public static void showElemResultSet(ElemResultSet[] elemRes) {
        OdsxSelectConvert.printElemResultSet(System.out, elemRes);
    }

    public static void printCols(PrintStream out, ResultColumn[] cols) {
        if (cols != null && cols.length > 0) {
            StringBuffer ret = new StringBuffer("| ");
            for (int i = 0; i < cols.length; ++i) {
                ret.append(cols[i].getName() + " | ");
            }
            ret.append("\n");
            char[] sep = new char[ret.length() - 2];
            Arrays.fill(sep, '-');
            ret.insert(0, new String(sep) + "\n");
            ret.append(new String(sep));
            int size = cols[0].size();
            for (int j = 0; j <= size; ++j) {
                ret.append("\n| ");
                for (int i = 0; i < cols.length; ++i) {
                    ret.append(cols[i].get(j) + " | ");
                }
            }
            ret.append("\n" + new String(sep));
            out.println(ret);
        }
    }

    public static void main(String[] args) {
        String[] arr = new String[args.length + 2];
        if (args.length > 0) {
            System.arraycopy(args, 0, arr, 0, args.length);
        }
        arr[arr.length - 2] = "-Odsx.NewSession.AskForPassword";
        arr[arr.length - 1] = "false";
        FwkContainer.initialize((String[])arr);
        OdsxSelectConvert parser = new OdsxSelectConvert();
        HashMap map = parser.parse("select ba.id, ba.name from be.AoTest where ba.name = 'WAL*' or ba.name = '*0' using ATF/Target");
        System.out.println(map);
        String PROMPT = "HQL> ";
        System.out.print(PROMPT);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        HQL hql = new HQL();
        boolean stop = false;
        while (!stop) {
            try {
                hql.readFrom(in);
                System.out.print(PROMPT);
            }
            catch (Throwable t) {}
        }
        System.exit(0);
    }

    static {
        char[] arr = new char[4096];
        Arrays.fill(arr, ' ');
        SPACES = new String(arr);
        operatorList = new HashMap();
        operatorInvList = new HashMap();
        operatorList.put("&&", SelOperator.AND);
        operatorList.put("||", SelOperator.OR);
        operatorList.put("!", SelOperator.NOT);
        operatorList.put("&&", SelOperator.AND);
        operatorList.put("(", SelOperator.OPEN);
        operatorList.put(")", SelOperator.CLOSE);
        operatorList.put("==", SelOpcode.EQ);
        operatorList.put("=", SelOpcode.EQ);
        operatorList.put(">", SelOpcode.GT);
        operatorList.put(">=", SelOpcode.GTE);
        operatorList.put("<", SelOpcode.LT);
        operatorList.put("<=", SelOpcode.LTE);
        operatorList.put("LIKE", SelOpcode.LIKE);
        operatorList.put("IN", SelOpcode.INSET);
        operatorList.put("!IN", SelOpcode.NOTINSET);
        operatorList.put("!=", SelOpcode.NEQ);
        operatorInvList.put(SelOperator.AND, "&&");
        operatorInvList.put(SelOperator.OR, "||");
        operatorInvList.put(SelOperator.NOT, "!");
        operatorInvList.put(SelOperator.AND, "&&");
        operatorInvList.put(SelOperator.OPEN, "(");
        operatorInvList.put(SelOperator.CLOSE, ")");
        operatorInvList.put(SelOpcode.EQ, "==");
        operatorInvList.put(SelOpcode.EQ, "=");
        operatorInvList.put(SelOpcode.GT, ">");
        operatorInvList.put(SelOpcode.GTE, ">=");
        operatorInvList.put(SelOpcode.LT, "<");
        operatorInvList.put(SelOpcode.LTE, "<=");
        operatorInvList.put(SelOpcode.LIKE, "LIKE");
        operatorInvList.put(SelOpcode.INSET, "IN");
        operatorInvList.put(SelOpcode.NOTINSET, "!IN");
        operatorInvList.put(SelOpcode.NEQ, "!=");
    }
}

