/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hql;

import com.highqsoft.odsx.hql.ResultColumnInterface;
import java.util.Arrays;
import java.util.Vector;

public class ResultColumn
implements ResultColumnInterface {
    public static final String version = "$Revision: 1.2 $";
    protected static final String SPACES;
    protected static final int MAXLEN = 4096;
    String name;
    int maxLen;
    Vector values;
    int[] order;

    public String getVersion() {
        return version;
    }

    public ResultColumn(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
        this.maxLen = name.length();
        this.values = new Vector();
        this.order = null;
    }

    public void release() {
    }

    public String getName() {
        return this.name + SPACES.substring(0, this.maxLen - this.name.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String value) {
        Vector vector = this.values;
        synchronized (vector) {
            int index = value.indexOf("\n ");
            if (index >= 0) {
                value = value.substring(0, index) + " (" + value.substring(index + 2, value.length()) + ")";
            }
            this.maxLen = Math.max(this.maxLen, value.length());
            this.values.add(value);
            this.order = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(int i) {
        Vector vector = this.values;
        synchronized (vector) {
            String ret = (String)this.values.get(i);
            return ret + SPACES.substring(0, this.maxLen - ret.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Vector vector = this.values;
        synchronized (vector) {
            return this.values.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getOrder() {
        Vector vector = this.values;
        synchronized (vector) {
            int[] ret;
            if (this.order == null) {
                Object[] arr = this.values.toArray(new String[this.values.size()]);
                ret = new int[this.values.size()];
                if (this.values.size() != 0) {
                    Arrays.sort(arr);
                    int size = this.values.size();
                    for (int i = 0; i < size; ++i) {
                        ret[Arrays.binarySearch((Object[])arr, this.values.get((int)i))] = i;
                    }
                }
                this.order = new int[ret.length];
                System.arraycopy(ret, 0, this.order, 0, ret.length);
            } else {
                ret = new int[this.order.length];
                System.arraycopy(this.order, 0, ret, 0, this.order.length);
            }
            return ret;
        }
    }

    public String toString() {
        return this.toString(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(boolean ascent) {
        Vector vector = this.values;
        synchronized (vector) {
            if (this.size() > 0) {
                int size = this.values.size();
                Object[] arr = this.values.toArray(new String[this.values.size()]);
                this.values.clear();
                Arrays.sort(arr);
                if (ascent) {
                    for (int i = 0; i < size; ++i) {
                        this.values.add(arr[i]);
                    }
                } else {
                    for (int i = size - 1; i >= 0; --i) {
                        this.values.add(arr[i]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(boolean ordered, boolean ascent) {
        Vector vector = this.values;
        synchronized (vector) {
            StringBuffer ret = new StringBuffer("| ");
            ret.append(this.getName() + " | ");
            ret.append("\n");
            char[] sep = new char[ret.length() - 2];
            Arrays.fill(sep, '-');
            ret.insert(0, new String(sep) + "\n");
            ret.append(new String(sep));
            int size = this.size();
            if (ordered) {
                int[] order = this.getOrder();
                if (ascent) {
                    for (int i = 0; i < size; ++i) {
                        ret.append("\n| ");
                        ret.append(this.get(order[i]) + " | ");
                    }
                } else {
                    for (int i = size - 1; i >= 0; --i) {
                        ret.append("\n| ");
                        ret.append(this.get(order[i]) + " | ");
                    }
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    ret.append("\n| ");
                    ret.append(this.get(i) + " | ");
                }
            }
            ret.append("\n" + new String(sep));
            return ret.toString();
        }
    }

    static {
        char[] arr = new char[4096];
        Arrays.fill(arr, ' ');
        SPACES = new String(arr);
    }
}

