/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hqlx;

import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.hqlx.ResultColumn;
import java.io.PrintStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.asam.ods.AoException;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.ElemResultSetExt;
import org.asam.ods.ElemResultSetExtSeqIterator;
import org.asam.ods.NameValueSeqUnitId;
import org.asam.ods.ResultSetExt;
import org.asam.ods.TS_UnionSeq;
import org.asam.ods.T_COMPLEX;
import org.asam.ods.T_DCOMPLEX;
import org.asam.ods.T_LONGLONG;

public class HQLXResultSetPrinter {
    public static final String version = "$Revision: 1.4 $";
    ApplicationStructure asObj;
    protected ResultSetExt[] resultSet;
    protected int[] charWidth;
    protected Object[] stringVal;
    protected int columnCount;
    SimpleDateFormat dateFormat;
    SimpleDateFormat odsFormat;

    public String getVersion() {
        return version;
    }

    public HQLXResultSetPrinter(ApplicationStructure asObj, ResultSetExt[] res) {
        this.asObj = asObj;
        this.resultSet = res;
        this.stringVal = null;
        this.odsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        this.dateFormat = Locale.getDefault().getLanguage().compareTo("de") == 0 ? new SimpleDateFormat("dd.MM.yyyy HH:mm:ss") : new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aaa");
    }

    public void release() {
        this.resultSet = null;
        this.charWidth = null;
        this.stringVal = null;
    }

    public String[] listColumns() throws AoException {
        String[] ret = new String[this.getColumnCount()];
        if (ret.length > 0) {
            int rCount = 0;
            String add = "";
            if (this.resultSet != null && this.resultSet.length > 0) {
                int size = this.resultSet.length;
                for (int i = 0; i < size; ++i) {
                    if (this.resultSet[i].firstElems == null) continue;
                    int count = this.resultSet[i].firstElems.length;
                    for (int c = 0; c < count; ++c) {
                        ElemResultSetExt elemResultSet = this.resultSet[i].firstElems[c];
                        if (count > 1) {
                            ApplicationElement aeObj = this.asObj.getElementById(elemResultSet.aid);
                            add = aeObj.getName() + ".";
                        }
                        int vlen = elemResultSet.values.length;
                        for (int v = 0; v < vlen; ++v) {
                            ret[rCount++] = add + elemResultSet.values[v].valName;
                        }
                    }
                }
            }
        }
        return ret;
    }

    public int findColumn(String name) throws Exception {
        int ret = -1;
        String[] arr = this.listColumns();
        int size = arr.length;
        for (int i = 0; ret == -1 && i < size; ++i) {
            if (!arr[i].matches(name)) continue;
            ret = i;
        }
        return ret;
    }

    public int getColumnDisplaySize(int column) throws AoException {
        int ret = 0;
        if (this.charWidth == null) {
            this.charWidth = new int[this.getColumnCount()];
            Arrays.fill(this.charWidth, -1);
        }
        if (column < this.charWidth.length) {
            if (this.charWidth[column] == -1) {
                String[] arr = this.getColumnStringValue(column);
                int size = arr.length;
                for (int i = 0; i < size; ++i) {
                    ret = Math.max(ret, arr[i].length());
                }
                this.charWidth[column] = ret;
            } else {
                ret = this.charWidth[column];
            }
        }
        return ret;
    }

    public String[] getRowStringValue(int row) throws AoException {
        int cCount = this.getColumnCount();
        String[] ret = new String[cCount];
        for (int i = 0; i < cCount; ++i) {
            ret[i] = this.getColumnStringValue(i)[row];
        }
        return ret;
    }

    public String getCellStringValue(int column, int row) throws AoException {
        return this.getColumnStringValue(column)[row];
    }

    public String[] getColumnStringValue(int column) throws AoException {
        if (this.stringVal[column] == null) {
            String[] arr;
            NameValueSeqUnitId restNvusid;
            NameValueSeqUnitId nvusid = this.getAttributeValues(column);
            String[] ret = this.ts_UnionSeqToString(nvusid.value.u);
            if (ret != null && (restNvusid = this.getAttributeRestValues(column)) != null && (arr = this.ts_UnionSeqToString(restNvusid.value.u)) != null) {
                String[] tmp = new String[ret.length + arr.length];
                System.arraycopy(ret, 0, tmp, 0, ret.length);
                System.arraycopy(arr, 0, tmp, ret.length, arr.length);
                ret = tmp;
            }
            this.stringVal[column] = ret;
        }
        return (String[])this.stringVal[column];
    }

    public String[] ts_UnionSeqToString(TS_UnionSeq unionSeq) throws AoException {
        String[] sArr = null;
        if (unionSeq != null && unionSeq.discriminator() != null) {
            try {
                switch (unionSeq.discriminator().value()) {
                    case 1: {
                        sArr = unionSeq.stringVal();
                        break;
                    }
                    case 2: {
                        short[] farr = unionSeq.shortVal();
                        sArr = new String[farr.length];
                        for (int x = 0; x < farr.length; ++x) {
                            sArr[x] = "" + farr[x];
                        }
                        break;
                    }
                    case 3: {
                        float[] farr = unionSeq.floatVal();
                        sArr = new String[farr.length];
                        for (int x = 0; x < farr.length; ++x) {
                            sArr[x] = "" + farr[x];
                        }
                        break;
                    }
                    case 5: {
                        byte[] barr = unionSeq.byteVal();
                        sArr = new String[barr.length];
                        for (int x = 0; x < barr.length; ++x) {
                            sArr[x] = Integer.toString(barr[x], 16);
                        }
                        break;
                    }
                    case 4: {
                        boolean[] barr = unionSeq.booleanVal();
                        sArr = new String[barr.length];
                        for (int x = 0; x < barr.length; ++x) {
                            sArr[x] = "" + barr[x];
                        }
                        break;
                    }
                    case 6: {
                        int[] larr = unionSeq.longVal();
                        sArr = new String[larr.length];
                        for (int x = 0; x < larr.length; ++x) {
                            sArr[x] = "" + larr[x];
                        }
                        break;
                    }
                    case 7: {
                        double[] darr = unionSeq.doubleVal();
                        sArr = new String[darr.length];
                        for (int x = 0; x < darr.length; ++x) {
                            sArr[x] = "" + darr[x];
                        }
                        break;
                    }
                    case 8: {
                        T_LONGLONG[] larr = unionSeq.longlongVal();
                        sArr = new String[larr.length];
                        for (int x = 0; x < larr.length; ++x) {
                            sArr[x] = OdsxHelper.t_longlongToString(larr[x]);
                        }
                        break;
                    }
                    case 13: {
                        T_COMPLEX[] larr = unionSeq.complexVal();
                        sArr = new String[larr.length];
                        for (int x = 0; x < larr.length; ++x) {
                            sArr[x] = OdsxHelper.t_complexToString(larr[x]);
                        }
                        break;
                    }
                    case 14: {
                        T_DCOMPLEX[] larr = unionSeq.dcomplexVal();
                        sArr = new String[larr.length];
                        for (int x = 0; x < larr.length; ++x) {
                            sArr[x] = OdsxHelper.t_dcomplexToString(larr[x]);
                        }
                        break;
                    }
                    case 10: {
                        sArr = unionSeq.dateVal();
                        ParsePosition pos = new ParsePosition(0);
                        for (int x = 0; x < sArr.length; ++x) {
                            Date date = this.odsFormat.parse(sArr[x], pos);
                            pos.setIndex(0);
                            if (date == null) continue;
                            sArr[x] = this.dateFormat.format(date);
                        }
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 28: {
                        break;
                    }
                    default: {
                        sArr = null;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return sArr;
    }

    protected NameValueSeqUnitId getAttributeValues(int column) throws AoException {
        NameValueSeqUnitId ret = null;
        if (column >= 0 && column < this.getColumnCount()) {
            int pos = 0;
            if (this.resultSet != null && this.resultSet.length > 0) {
                int size = this.resultSet.length;
                for (int i = 0; ret == null && i < size; ++i) {
                    if (this.resultSet[i].firstElems == null) continue;
                    int noAE = this.resultSet[i].firstElems.length;
                    for (int ae = 0; ret == null && ae < noAE; ++ae) {
                        ElemResultSetExt elemResultSet = this.resultSet[i].firstElems[ae];
                        int noAA = elemResultSet.values.length;
                        if (column < pos + noAA) {
                            ret = elemResultSet.values[column - pos];
                        }
                        pos += noAA;
                    }
                }
            }
        }
        return ret;
    }

    protected NameValueSeqUnitId getAttributeRestValues(int column) throws AoException {
        NameValueSeqUnitId ret = null;
        if (column >= 0 && column < this.getColumnCount()) {
            int pos = 0;
            if (this.resultSet != null && this.resultSet.length > 0) {
                int size = this.resultSet.length;
                for (int i = 0; ret == null && i < size; ++i) {
                    if (this.resultSet[i].restElems == null) continue;
                    ElemResultSetExtSeqIterator it = this.resultSet[i].restElems;
                    it.reset();
                    if (this.resultSet[i].firstElems != null) {
                        it.nextN(this.resultSet[i].firstElems.length);
                    }
                    ElemResultSetExt[] restElems = it.nextN(it.getCount());
                    int noAE = restElems.length;
                    for (int ae = 0; ret == null && ae < noAE; ++ae) {
                        ElemResultSetExt elemResultSet = restElems[ae];
                        int noAA = elemResultSet.values.length;
                        if (column < pos + noAA) {
                            ret = elemResultSet.values[column - pos];
                        }
                        pos += noAA;
                    }
                }
            }
        }
        return ret;
    }

    public int getColumnCount() throws AoException {
        if (this.stringVal == null || this.stringVal.length == 0) {
            int columnCount = 0;
            if (this.resultSet != null && this.resultSet.length > 0) {
                int size = this.resultSet.length;
                for (int i = 0; i < size; ++i) {
                    if (this.resultSet[i].firstElems == null) continue;
                    int count = this.resultSet[i].firstElems.length;
                    for (int c = 0; c < count; ++c) {
                        ElemResultSetExt elemResultSet = this.resultSet[i].firstElems[c];
                        columnCount += elemResultSet.values.length;
                    }
                }
            }
            this.stringVal = new Object[columnCount];
        }
        return this.stringVal.length;
    }

    public int getRowCount() throws AoException {
        int ret = 0;
        if (this.stringVal == null) {
            this.getColumnStringValue(0);
        }
        if (this.stringVal != null && this.stringVal.length > 0) {
            ret = ((String[])this.stringVal[0]).length;
        }
        return ret;
    }

    public ResultColumn[] getResultColumns() throws AoException {
        ResultColumn[] ret;
        int colCount = this.getColumnCount();
        if (colCount > 0) {
            ret = new ResultColumn[colCount];
            String[] names = this.listColumns();
            for (int j = 0; j < colCount; ++j) {
                String[] arr;
                ret[j] = new ResultColumn(names[j]);
                try {
                    arr = this.getColumnStringValue(j);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    arr = new String[]{};
                }
                int aSize = arr.length;
                for (int i = 0; i < aSize; ++i) {
                    ret[j].add(arr[i]);
                }
            }
        } else {
            ret = new ResultColumn[]{};
        }
        return ret;
    }

    public ResultSetExt[] getResultSetExt() {
        return this.resultSet;
    }

    public void printCols(PrintStream out) throws AoException {
        ResultColumn[] cols = this.getResultColumns();
        if (cols != null && cols.length > 0) {
            StringBuffer ret = new StringBuffer("| ");
            for (int i = 0; i < cols.length; ++i) {
                ret.append(cols[i].getName() + " | ");
            }
            ret.append("\n");
            char[] sep = new char[ret.length() - 2];
            Arrays.fill(sep, '-');
            ret.insert(0, new String(sep) + "\n");
            ret.append(new String(sep));
            int size = cols[0].size();
            for (int j = 0; j < size; ++j) {
                ret.append("\n| ");
                for (int i = 0; i < cols.length; ++i) {
                    ret.append(cols[i].get(j) + " | ");
                }
            }
            ret.append("\n" + new String(sep));
            out.println(ret);
        }
    }
}

