/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hqlx;

import com.highqsoft.ods.AoService;
import com.highqsoft.ods.AoServiceFactory;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.hqlx.MissingChildNodeException;
import com.highqsoft.odsx.hqlx.MultipleElementNotAllowedException;
import com.highqsoft.odsx.hqlx.QueryStructureGeneratorException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Vector;
import org.asam.ods.AIDName;
import org.asam.ods.AIDNameUnitId;
import org.asam.ods.AggrFunc;
import org.asam.ods.AoException;
import org.asam.ods.AoFactory;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.DataType;
import org.asam.ods.InstanceElement;
import org.asam.ods.JoinDef;
import org.asam.ods.JoinType;
import org.asam.ods.QueryStructureExt;
import org.asam.ods.SelAIDNameUnitId;
import org.asam.ods.SelItem;
import org.asam.ods.SelOpcode;
import org.asam.ods.SelOperator;
import org.asam.ods.SelOrder;
import org.asam.ods.SelValueExt;
import org.asam.ods.TS_Union;
import org.asam.ods.TS_Value;
import org.asam.ods.T_LONGLONG;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectFactory {
    private static ObjectFactory instance = null;

    public static ObjectFactory getInstance() {
        if (instance == null) {
            instance = new ObjectFactory();
        }
        return instance;
    }

    public PrintStream getPrintStream(Element elem) throws FileNotFoundException {
        PrintStream ret = null;
        NodeList list = elem.getElementsByTagName("printstream");
        if (list.getLength() >= 0) {
            Element psElem = (Element)list.item(0);
            String mode = psElem.getAttribute("mode").toLowerCase();
            String filename = psElem.getAttribute("filename");
            if (filename.length() > 0) {
                FileOutputStream fos = new FileOutputStream(filename, mode.indexOf(97) >= 0);
                ret = new PrintStream(fos);
            }
        }
        return ret;
    }

    public AoSession evalAoSession(Element elem) throws QueryStructureGeneratorException {
        try {
            String plumName;
            Element fElem = this.getSingleObligatoryElement(elem, "AoFactory", true);
            Element srvElem = this.getSingleObligatoryElement(fElem, "AoService", true);
            String srvOptions = srvElem.getAttribute("options");
            if (srvOptions.length() == 0) {
                srvOptions = "INI_FILE=ATHOS_INI";
            }
            if ((plumName = srvElem.getAttribute("plumname")).length() == 0) {
                plumName = "corba";
            }
            if (plumName.compareToIgnoreCase("corba") == 0) {
                plumName = "com.highqsoft.ods.corba.AoService";
            } else if (plumName.compareToIgnoreCase("athos") == 0) {
                plumName = "com.highqsoft.ods.athos.AoService";
            }
            AoService aoService = AoServiceFactory.newService((String)plumName, (String)srvOptions);
            String srvName = fElem.getAttribute("servicename");
            String fOptions = fElem.getAttribute("options");
            if (fOptions.length() == 0) {
                fOptions = null;
            }
            AoFactory aoFactory = aoService.newFactory(srvName, fOptions);
            String user = elem.getAttribute("user");
            String password = elem.getAttribute("password");
            String other = elem.getAttribute("options");
            String openmode = elem.getAttribute("openmode");
            if (openmode.length() == 0) {
                openmode = "read";
            }
            StringBuffer sessionOptions = new StringBuffer("OPENMODE=" + openmode);
            if (user.length() > 0) {
                sessionOptions.append(", USER=").append(user);
            }
            if (password.length() > 0) {
                sessionOptions.append(", PASSWORD=").append(password);
            }
            if (other.length() > 0) {
                sessionOptions.append(", ").append(other);
            }
            return aoFactory.newSession(sessionOptions.toString());
        }
        catch (AoException aoe) {
            throw new QueryStructureGeneratorException(OdsxHelper.aoExceptionToString(aoe), aoe);
        }
        catch (MultipleElementNotAllowedException menae) {
            throw new QueryStructureGeneratorException(menae);
        }
        catch (MissingChildNodeException menae) {
            throw new QueryStructureGeneratorException(menae);
        }
    }

    public Element getQueryStructureExtElem(ApplicationStructure asObj, QueryStructureExt qse, Element parent) throws QueryStructureGeneratorException {
        Element qseElem = null;
        if (qse != null) {
            Element elem;
            Document doc = parent.getOwnerDocument();
            qseElem = doc.createElement("querystructureext");
            parent.appendChild(qseElem);
            if (qse.anuSeq != null && qse.anuSeq.length > 0) {
                elem = doc.createElement("anuseq");
                qseElem.appendChild(elem);
                this.appendAnuSeq(asObj, qse.anuSeq, elem);
            }
            if (qse.condSeq != null && qse.condSeq.length > 0) {
                elem = doc.createElement("condseq");
                qseElem.appendChild(elem);
                this.appendCondSeq(asObj, qse.condSeq, elem);
            }
            if (qse.joinSeq != null && qse.joinSeq.length > 0) {
                elem = doc.createElement("joinseq");
                qseElem.appendChild(elem);
                this.appendJoinSeq(asObj, qse.joinSeq, elem);
            }
            if (qse.orderBy != null && qse.orderBy.length > 0) {
                elem = doc.createElement("orderby");
                qseElem.appendChild(elem);
                this.appendOrderBy(asObj, qse.orderBy, elem);
            }
            if (qse.groupBy != null && qse.groupBy.length > 0) {
                elem = doc.createElement("groupby");
                qseElem.appendChild(elem);
                this.appendGroupBy(asObj, qse.groupBy, elem);
            }
        }
        return qseElem;
    }

    public QueryStructureExt getQueryStructureExt(ApplicationStructure asObj, Element root) throws QueryStructureGeneratorException {
        Vector<Node> anuSeq = new Vector<Node>();
        Vector<Node> condSeq = new Vector<Node>();
        Vector<Node> groupBy = new Vector<Node>();
        Vector<Node> joinSeq = new Vector<Node>();
        Vector<Node> orderBy = new Vector<Node>();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            String nodeName = node.getNodeName().toLowerCase();
            if (nodeName.compareTo("anuseq") == 0) {
                anuSeq.add(node);
                continue;
            }
            if (nodeName.compareTo("condseq") == 0) {
                condSeq.add(node);
                continue;
            }
            if (nodeName.compareTo("joinseq") == 0) {
                joinSeq.add(node);
                continue;
            }
            if (nodeName.compareTo("groupby") == 0) {
                groupBy.add(node);
                continue;
            }
            if (nodeName.compareTo("orderby") == 0) {
                orderBy.add(node);
                continue;
            }
            if (nodeName.compareTo("out") == 0 || nodeName.compareTo("err") == 0 || nodeName.compareTo("aosession") == 0) continue;
            System.err.println("Unknown element <" + node.getNodeName() + "> found.");
        }
        return this.getQueryStructureExt(asObj, anuSeq.toArray(new Element[anuSeq.size()]), condSeq.toArray(new Element[condSeq.size()]), groupBy.toArray(new Element[groupBy.size()]), joinSeq.toArray(new Element[joinSeq.size()]), orderBy.toArray(new Element[orderBy.size()]));
    }

    public QueryStructureExt getQueryStructureExt(ApplicationStructure asObj, Element[] anuSeq, Element[] condSeq, Element[] groupBy, Element[] joinSeq, Element[] orderBy) throws QueryStructureGeneratorException {
        return new QueryStructureExt(this.evalAnuSeq(asObj, anuSeq), this.evalCondSeq(asObj, condSeq), this.evalJoinSeq(asObj, joinSeq), this.evalOrderBy(asObj, orderBy), this.evalGroupBy(asObj, groupBy));
    }

    public SelAIDNameUnitId[] evalAnuSeq(ApplicationStructure asObj, Element[] anuSeq) throws QueryStructureGeneratorException {
        Vector<SelAIDNameUnitId> arr = new Vector<SelAIDNameUnitId>();
        int len = anuSeq.length;
        for (int l = 0; l < len; ++l) {
            NodeList nodeList = anuSeq[l].getElementsByTagName("selaidnameunitid");
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                SelAIDNameUnitId selNameUnit = this.evalSelAIDNameUnitId(asObj, (Element)nodeList.item(i));
                if (selNameUnit != null) {
                    arr.add(selNameUnit);
                    continue;
                }
                System.err.println("Cannot create object from " + i + ". selaidnameunitid of " + l + ". anuSeq element.");
            }
        }
        return arr.toArray(new SelAIDNameUnitId[arr.size()]);
    }

    public void appendAnuSeq(ApplicationStructure asObj, SelAIDNameUnitId[] anuSeq, Element parent) throws QueryStructureGeneratorException {
        if (anuSeq != null && anuSeq.length > 0) {
            int size = anuSeq.length;
            for (int i = 0; i < size; ++i) {
                this.appendSelAIDNameUnitId(asObj, anuSeq[i], parent);
            }
        }
    }

    public SelItem[] evalCondSeq(ApplicationStructure asObj, Element[] condSeq) throws QueryStructureGeneratorException {
        Vector<SelItem> arr = new Vector<SelItem>();
        int len = condSeq.length;
        for (int l = 0; l < len; ++l) {
            NodeList nodeList = condSeq[l].getElementsByTagName("selitem");
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                SelItem selItem = this.evalSelItem(asObj, (Element)nodeList.item(i));
                if (selItem != null) {
                    arr.add(selItem);
                    continue;
                }
                System.err.println("Cannot create object from " + i + ". selitem of " + l + ". condSeq element.");
            }
        }
        return arr.toArray(new SelItem[arr.size()]);
    }

    public void appendCondSeq(ApplicationStructure asObj, SelItem[] condSeq, Element parent) throws QueryStructureGeneratorException {
        if (condSeq != null && condSeq.length > 0) {
            int size = condSeq.length;
            for (int i = 0; i < size; ++i) {
                this.appendSelItem(asObj, condSeq[i], parent);
            }
        }
    }

    public AIDName[] evalGroupBy(ApplicationStructure asObj, Element[] groupBy) throws QueryStructureGeneratorException {
        Vector<AIDName> arr = new Vector<AIDName>();
        int len = groupBy.length;
        for (int l = 0; l < len; ++l) {
            NodeList aidNameList = groupBy[l].getElementsByTagName("aidname");
            int slen = aidNameList.getLength();
            for (int s = 0; s < slen; ++s) {
                arr.add(this.evalAIDName(asObj, (Element)aidNameList.item(s)));
            }
        }
        return arr.toArray(new AIDName[arr.size()]);
    }

    public void appendGroupBy(ApplicationStructure asObj, AIDName[] aidName, Element parent) throws QueryStructureGeneratorException {
        if (aidName != null && aidName.length > 0) {
            int size = aidName.length;
            for (int i = 0; i < size; ++i) {
                this.appendAIDName(asObj, aidName[i], parent);
            }
        }
    }

    public JoinDef[] evalJoinSeq(ApplicationStructure asObj, Element[] joindef) throws QueryStructureGeneratorException {
        Vector<JoinDef> arr = new Vector<JoinDef>();
        int len = joindef.length;
        for (int l = 0; l < len; ++l) {
            NodeList joinDefList = joindef[l].getElementsByTagName("joindef");
            int slen = joinDefList.getLength();
            for (int s = 0; s < slen; ++s) {
                arr.add(this.evalJoinDef(asObj, (Element)joinDefList.item(s)));
            }
        }
        return arr.toArray(new JoinDef[arr.size()]);
    }

    public void appendJoinSeq(ApplicationStructure asObj, JoinDef[] joinSeq, Element parent) throws QueryStructureGeneratorException {
        if (joinSeq != null && joinSeq.length > 0) {
            int size = joinSeq.length;
            for (int i = 0; i < size; ++i) {
                this.appendJoinDef(asObj, joinSeq[i], parent);
            }
        }
    }

    public JoinDef evalJoinDef(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        JoinDef ret = null;
        try {
            Element toaid = this.getSingleObligatoryElement(elem, "toaid", true);
            T_LONGLONG toAID = this.evalAID(asObj, toaid);
            Element fromaid = this.getSingleObligatoryElement(elem, "fromaid", true);
            T_LONGLONG fromAID = this.evalAID(asObj, fromaid);
            JoinType joinType = this.evalJoinType(asObj, elem);
            ret = new JoinDef(fromAID, toAID, elem.getAttribute("refname"), joinType);
        }
        catch (MultipleElementNotAllowedException menae) {
            throw new QueryStructureGeneratorException(menae);
        }
        catch (MissingChildNodeException menae) {
            throw new QueryStructureGeneratorException(menae);
        }
        return ret;
    }

    public void appendJoinDef(ApplicationStructure asObj, JoinDef joinDef, Element parent) throws QueryStructureGeneratorException {
        if (joinDef != null) {
            Document doc = parent.getOwnerDocument();
            Element jdElem = doc.createElement("joindef");
            parent.appendChild(jdElem);
            this.appendFromAID(asObj, joinDef.fromAID, jdElem);
            this.appendToAID(asObj, joinDef.toAID, jdElem);
            this.appendJoinType(asObj, joinDef.joiningType, jdElem);
            if (joinDef.refName != null && joinDef.refName.length() > 0) {
                jdElem.setAttribute("refname", joinDef.refName);
            }
        }
    }

    public SelOrder[] evalOrderBy(ApplicationStructure asObj, Element[] orderBy) throws QueryStructureGeneratorException {
        Vector<SelOrder> arr = new Vector<SelOrder>();
        int len = orderBy.length;
        for (int l = 0; l < len; ++l) {
            NodeList selOrderList = orderBy[l].getElementsByTagName("selorder");
            int slen = selOrderList.getLength();
            for (int s = 0; s < slen; ++s) {
                arr.add(this.evalSelOrder(asObj, (Element)selOrderList.item(s)));
            }
        }
        return arr.toArray(new SelOrder[arr.size()]);
    }

    public void appendOrderBy(ApplicationStructure asObj, SelOrder[] orderby, Element parent) throws QueryStructureGeneratorException {
        if (orderby != null && orderby.length > 0) {
            int size = orderby.length;
            for (int i = 0; i < size; ++i) {
                this.appendSelOrder(asObj, orderby[i], parent);
            }
        }
    }

    public SelOrder evalSelOrder(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        SelOrder ret = null;
        try {
            Element aidelem = this.getSingleObligatoryElement(elem, "aidname", true);
            AIDName aidName = this.evalAIDName(asObj, aidelem);
            boolean ascending = this.evalBoolean(elem.getAttribute("ascending"), true);
            ret = new SelOrder(aidName, ascending);
        }
        catch (MultipleElementNotAllowedException menae) {
            throw new QueryStructureGeneratorException(menae);
        }
        catch (MissingChildNodeException menae) {
            throw new QueryStructureGeneratorException(menae);
        }
        return ret;
    }

    public void appendSelOrder(ApplicationStructure asObj, SelOrder selOrder, Element parent) throws QueryStructureGeneratorException {
        if (selOrder != null) {
            Document doc = parent.getOwnerDocument();
            Element obElem = doc.createElement("selorder");
            parent.appendChild(obElem);
            this.appendAIDName(asObj, selOrder.attr, obElem);
            if (selOrder.ascending) {
                obElem.setAttribute("ascending", "true");
            } else {
                obElem.setAttribute("ascending", "false");
            }
        }
    }

    public SelAIDNameUnitId evalSelAIDNameUnitId(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        SelAIDNameUnitId ret = null;
        try {
            Element aidname = this.getSingleObligatoryElement(elem, "aidname", true);
            Element unit = this.getSingleObligatoryElement(elem, "unit", false);
            Element aggregate = this.getSingleObligatoryElement(elem, "aggregate", false);
            AIDName ain = this.evalAIDName(asObj, aidname);
            AggrFunc aggrFun = this.evalAggregate(asObj, aggregate);
            InstanceElement ieUnit = this.evalUnit(asObj, unit);
            T_LONGLONG unitID = null;
            if (ieUnit == null) {
                ApplicationElement aeObj = asObj.getElementById(ain.aid);
                ApplicationAttribute aaObj = aeObj.getAttributeByName(ain.aaName);
                unitID = aaObj.getUnit();
            } else {
                unitID = ieUnit.getId();
            }
            ret = new SelAIDNameUnitId(ain, unitID, aggrFun);
        }
        catch (AoException aoe) {
            throw new QueryStructureGeneratorException(OdsxHelper.aoExceptionToString(aoe), aoe);
        }
        catch (MultipleElementNotAllowedException menae) {
            throw new QueryStructureGeneratorException(menae);
        }
        catch (MissingChildNodeException menae) {
            throw new QueryStructureGeneratorException(menae);
        }
        return ret;
    }

    public void appendSelAIDNameUnitId(ApplicationStructure asObj, SelAIDNameUnitId selAIDNameUnitId, Element parent) throws QueryStructureGeneratorException {
        if (selAIDNameUnitId != null) {
            Document doc = parent.getOwnerDocument();
            Element qseElem = doc.createElement("selaidnameunitid");
            parent.appendChild(qseElem);
            this.appendAggregate(asObj, selAIDNameUnitId.aggregate, qseElem);
            this.appendAIDName(asObj, selAIDNameUnitId.attr, qseElem);
            this.appendUnit(asObj, selAIDNameUnitId.unitId, qseElem);
        }
    }

    public SelItem evalSelItem(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        SelItem ret = null;
        NodeList nodeList = elem.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName().toLowerCase();
            if (name.compareTo("selvalueext") == 0) {
                SelValueExt selValueExt = this.evalSelValueExt(asObj, (Element)node);
                ret = new SelItem();
                ret.value(selValueExt);
                continue;
            }
            if (name.compareTo("seloperator") == 0) {
                SelOperator selOperator = this.evalSelOperator(asObj, (Element)node);
                ret = new SelItem();
                ret._operator(selOperator);
                continue;
            }
            throw new QueryStructureGeneratorException(name + " is a unknown or wrong childnode node for element " + elem.getNodeName() + ".");
        }
        return ret;
    }

    public void appendSelItem(ApplicationStructure asObj, SelItem selItem, Element parent) throws QueryStructureGeneratorException {
        if (selItem != null) {
            int type = selItem.discriminator().value();
            if (type == 1 || type == 0) {
                Document doc = parent.getOwnerDocument();
                Element siElem = doc.createElement("selitem");
                parent.appendChild(siElem);
                if (selItem.discriminator().value() == 1) {
                    this.appendSelOperator(asObj, selItem._operator(), siElem);
                } else if (selItem.discriminator().value() == 0) {
                    this.appendSelValueExt(asObj, selItem.value(), siElem);
                }
            } else {
                throw new QueryStructureGeneratorException("Unknown SelType " + selItem.discriminator().value() + ".");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SelOperator evalSelOperator(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        SelOperator ret = null;
        if (elem == null) throw new QueryStructureGeneratorException("No element.");
        String type = elem.getAttribute("type").toUpperCase();
        if (type.length() == 0) throw new QueryStructureGeneratorException("SelOperator has no type attribute.");
        Class clazz = SelOperator.class;
        try {
            Field field = clazz.getField(type);
            return (SelOperator)field.get(null);
        }
        catch (Throwable t) {
            throw new QueryStructureGeneratorException("SelOperator " + type + " not found in API.", t);
        }
    }

    public void appendSelOperator(ApplicationStructure asObj, SelOperator selOperator, Element parent) throws QueryStructureGeneratorException {
        if (selOperator != null) {
            int value = selOperator.value();
            Class clazz = SelOperator.class;
            String opValue = null;
            try {
                Field[] fields = clazz.getFields();
                int size = fields.length;
                for (int i = 0; opValue == null && i < size; ++i) {
                    String name = fields[i].getName();
                    if (name.charAt(0) != '_' || (Integer)fields[i].get(null) != value) continue;
                    opValue = name.substring(1, name.length()).toLowerCase();
                }
            }
            catch (Throwable t) {
                throw new QueryStructureGeneratorException("Cannot evaluate selection operator [" + value + "].");
            }
            if (opValue != null) {
                Document doc = parent.getOwnerDocument();
                Element soElem = doc.createElement("seloperator");
                parent.appendChild(soElem);
                soElem.setAttribute("type", opValue);
            } else {
                throw new QueryStructureGeneratorException("Unknown selection operator [" + value + "] found.");
            }
        }
    }

    public SelValueExt evalSelValueExt(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        SelValueExt ret = null;
        if (elem != null) {
            try {
                SelOpcode opcode = this.evalSelOpcode(asObj, elem);
                Element aidnuidElem = this.getSingleObligatoryElement(elem, "aidnameunitid", true);
                Element tsvElem = this.getSingleObligatoryElement(elem, "ts_value", true);
                AIDNameUnitId aidNameUnidId = this.evalAIDNameUnitId(asObj, aidnuidElem);
                TS_Value ts_value = this.evalTS_Value(asObj, tsvElem);
                ret = new SelValueExt(aidNameUnidId, opcode, ts_value);
            }
            catch (MultipleElementNotAllowedException menae) {
                throw new QueryStructureGeneratorException(menae);
            }
            catch (MissingChildNodeException menae) {
                throw new QueryStructureGeneratorException(menae);
            }
        } else {
            throw new QueryStructureGeneratorException("No element.");
        }
        return ret;
    }

    public void appendSelValueExt(ApplicationStructure asObj, SelValueExt selValueExt, Element parent) throws QueryStructureGeneratorException {
        if (selValueExt != null) {
            Document doc = parent.getOwnerDocument();
            Element sveElem = doc.createElement("selvalueext");
            parent.appendChild(sveElem);
            this.appendSelOpcode(asObj, selValueExt.oper, sveElem);
            this.appendAIDNameUnitId(asObj, selValueExt.attr, sveElem);
            this.appendTS_Value(asObj, selValueExt.value, sveElem);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SelOpcode evalSelOpcode(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        SelOpcode ret = null;
        if (elem == null) throw new QueryStructureGeneratorException("No element.");
        String selOpcode = elem.getAttribute("selopcode").toUpperCase();
        if (selOpcode.length() == 0) throw new QueryStructureGeneratorException("selvalueext has no selopcode attribute.");
        Class clazz = SelOpcode.class;
        try {
            Field field = clazz.getField(selOpcode);
            return (SelOpcode)field.get(null);
        }
        catch (Throwable t) {
            throw new QueryStructureGeneratorException("SelOpcode " + selOpcode + " was not found in API.", t);
        }
    }

    public void appendSelOpcode(ApplicationStructure asObj, SelOpcode selOpcode, Element parent) throws QueryStructureGeneratorException {
        if (selOpcode != null) {
            int value = selOpcode.value();
            Class clazz = SelOpcode.class;
            String opValue = null;
            try {
                Field[] fields = clazz.getFields();
                int size = fields.length;
                for (int i = 0; opValue == null && i < size; ++i) {
                    String name = fields[i].getName();
                    if (name.charAt(0) != '_' || (Integer)fields[i].get(null) != value) continue;
                    opValue = name.substring(1, name.length()).toLowerCase();
                }
            }
            catch (Throwable t) {
                throw new QueryStructureGeneratorException("Cannot evaluate selection opcode [" + value + "].");
            }
            if (opValue != null) {
                parent.setAttribute("selopcode", opValue);
            } else {
                throw new QueryStructureGeneratorException("Unknown selection opcode [" + value + "] found.");
            }
        }
    }

    public TS_Value evalTS_Value(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        TS_Value ret = null;
        if (elem != null) {
            DataType dataType = this.evalDataType(asObj, elem);
            short flag = this.evalFlag(asObj, elem);
            try {
                TS_Union ts_Union = OdsxHelper.parseTS_Union(dataType, elem.getAttribute("value"));
                ret = new TS_Value(ts_Union, flag);
            }
            catch (AoException aoe) {
                throw new QueryStructureGeneratorException(OdsxHelper.aoExceptionToString(aoe), aoe);
            }
        } else {
            throw new QueryStructureGeneratorException("No element.");
        }
        return ret;
    }

    public void appendTS_Value(ApplicationStructure asObj, TS_Value ts_value, Element parent) throws QueryStructureGeneratorException {
        if (ts_value != null) {
            Document doc = parent.getOwnerDocument();
            Element tsvElem = doc.createElement("ts_value");
            parent.appendChild(tsvElem);
            this.appendFlag(asObj, ts_value.flag, tsvElem);
            this.appendDataType(asObj, ts_value.u.discriminator(), tsvElem);
            tsvElem.setAttribute("value", OdsxHelper.ts_unionToString(ts_value.u));
        }
    }

    public short evalFlag(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        short ret = 15;
        if (elem != null) {
            String flag = elem.getAttribute("flag").toUpperCase();
            if (flag.length() != 0) {
                try {
                    ret = Short.parseShort(flag);
                }
                catch (Throwable t) {
                    throw new QueryStructureGeneratorException("Wrong short format for attribute flag.");
                }
            }
        } else {
            throw new QueryStructureGeneratorException("No element.");
        }
        return ret;
    }

    public void appendFlag(ApplicationStructure asObj, short flag, Element parent) throws QueryStructureGeneratorException {
        parent.setAttribute("flag", Short.toString(flag));
    }

    public DataType evalDataType(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        DataType ret = DataType.DT_STRING;
        if (elem != null) {
            String datatype = elem.getAttribute("datatype").toUpperCase();
            if (datatype.length() != 0) {
                Class clazz = DataType.class;
                try {
                    Field field = clazz.getField(datatype);
                    ret = (DataType)field.get(null);
                }
                catch (Throwable t) {
                    throw new QueryStructureGeneratorException("DataType " + datatype + " was not found in API.", t);
                }
            }
        } else {
            throw new QueryStructureGeneratorException("No element.");
        }
        return ret;
    }

    public void appendDataType(ApplicationStructure asObj, DataType dataType, Element parent) throws QueryStructureGeneratorException {
        if (dataType != null) {
            int value = dataType.value();
            Class clazz = DataType.class;
            String dtValue = null;
            try {
                Field[] fields = clazz.getFields();
                int size = fields.length;
                for (int i = 0; dtValue == null && i < size; ++i) {
                    String name = fields[i].getName();
                    if (name.charAt(0) != '_' || (Integer)fields[i].get(null) != value) continue;
                    dtValue = name.substring(1, name.length()).toLowerCase();
                }
            }
            catch (Throwable t) {
                throw new QueryStructureGeneratorException("Cannot evaluate datatype [" + value + "].");
            }
            if (dtValue != null) {
                parent.setAttribute("datatype", dtValue);
            } else {
                throw new QueryStructureGeneratorException("Unknown datatype [" + value + "] found.");
            }
        }
    }

    public AIDNameUnitId evalAIDNameUnitId(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        AIDNameUnitId ret = null;
        try {
            Element aidname = this.getSingleObligatoryElement(elem, "aidname", true);
            Element unit = this.getSingleObligatoryElement(elem, "unit", false);
            AIDName ain = this.evalAIDName(asObj, aidname);
            InstanceElement ieUnit = this.evalUnit(asObj, unit);
            T_LONGLONG unitID = null;
            if (ieUnit == null) {
                ApplicationElement aeObj = asObj.getElementById(ain.aid);
                ApplicationAttribute aaObj = aeObj.getAttributeByName(ain.aaName);
                unitID = aaObj.getUnit();
            } else {
                unitID = ieUnit.getId();
            }
            ret = new AIDNameUnitId(ain, unitID);
        }
        catch (AoException aoe) {
            throw new QueryStructureGeneratorException(OdsxHelper.aoExceptionToString(aoe), aoe);
        }
        catch (MultipleElementNotAllowedException menae) {
            throw new QueryStructureGeneratorException(menae);
        }
        catch (MissingChildNodeException menae) {
            throw new QueryStructureGeneratorException(menae);
        }
        return ret;
    }

    public void appendAIDNameUnitId(ApplicationStructure asObj, AIDNameUnitId aidNameUnitId, Element parent) throws QueryStructureGeneratorException {
        if (aidNameUnitId != null) {
            Document doc = parent.getOwnerDocument();
            Element qseElem = doc.createElement("aidnameunitid");
            parent.appendChild(qseElem);
            this.appendAIDName(asObj, aidNameUnitId.attr, qseElem);
            this.appendUnit(asObj, aidNameUnitId.unitId, qseElem);
        }
    }

    public AIDName evalAIDName(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        AIDName ret = null;
        if (elem != null) {
            try {
                ApplicationAttribute aaObj;
                Element aidElem = this.getSingleObligatoryElement(elem, "aid", true);
                T_LONGLONG aid = this.evalAID(asObj, aidElem);
                String ba = elem.getAttribute("ba");
                String aa = elem.getAttribute("aa");
                ApplicationElement aeObj = null;
                if (aa.length() > 0) {
                    aeObj = asObj.getElementById(aid);
                    aaObj = aeObj.getAttributeByName(aa);
                } else if (ba.length() > 0) {
                    aeObj = asObj.getElementById(aid);
                    aaObj = aeObj.getAttributeByBaseName(ba);
                } else {
                    throw new QueryStructureGeneratorException("Missing Attribute name.");
                }
                ret = new AIDName(aeObj.getId(), aaObj.getName());
            }
            catch (AoException aoe) {
                throw new QueryStructureGeneratorException(OdsxHelper.aoExceptionToString(aoe), aoe);
            }
            catch (MultipleElementNotAllowedException menae) {
                throw new QueryStructureGeneratorException(menae);
            }
            catch (MissingChildNodeException menae) {
                throw new QueryStructureGeneratorException(menae);
            }
        } else {
            throw new QueryStructureGeneratorException("No element.");
        }
        return ret;
    }

    public void appendAIDName(ApplicationStructure asObj, AIDName aidName, Element parent) throws QueryStructureGeneratorException {
        if (aidName != null) {
            Document doc = parent.getOwnerDocument();
            Element aidnElem = doc.createElement("aidname");
            parent.appendChild(aidnElem);
            aidnElem.setAttribute("aa", aidName.aaName);
            this.appendAID(asObj, aidName.aid, aidnElem);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T_LONGLONG evalAID(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        T_LONGLONG ret = null;
        if (elem == null) throw new QueryStructureGeneratorException("No element.");
        String be = elem.getAttribute("be");
        String ae = elem.getAttribute("ae");
        String aid = elem.getAttribute("aid");
        try {
            ApplicationElement aeObj = null;
            if (ae.length() > 0) {
                aeObj = asObj.getElementByName(ae);
            } else if (aid.length() > 0) {
                aeObj = asObj.getElementById(OdsxHelper.parseLongLong(aid));
            } else if (be.length() > 0) {
                ApplicationElement[] arr = asObj.getElementsByBaseType(be);
                if (arr.length == 1) {
                    aeObj = arr[0];
                } else if (arr.length > 1) {
                    throw new QueryStructureGeneratorException("More than one ApplicationElement is derived from BaseElement " + be + ".");
                }
            }
            if (aeObj == null) return ret;
            return aeObj.getId();
        }
        catch (AoException aoe) {
            throw new QueryStructureGeneratorException(OdsxHelper.aoExceptionToString(aoe), aoe);
        }
        catch (NumberFormatException nfe) {
            throw new QueryStructureGeneratorException(nfe);
        }
    }

    public void appendAID(ApplicationStructure asObj, T_LONGLONG aid, Element parent) throws QueryStructureGeneratorException {
        if (aid != null) {
            Document doc = parent.getOwnerDocument();
            Element aidElem = doc.createElement("aid");
            parent.appendChild(aidElem);
            try {
                ApplicationElement aeObj = asObj.getElementById(aid);
                aidElem.setAttribute("ae", aeObj.getName());
            }
            catch (AoException aoe) {
                throw new QueryStructureGeneratorException(OdsxHelper.aoExceptionToString(aoe), aoe);
            }
        }
    }

    public void appendFromAID(ApplicationStructure asObj, T_LONGLONG aid, Element parent) throws QueryStructureGeneratorException {
        if (aid != null) {
            Document doc = parent.getOwnerDocument();
            Element aidElem = doc.createElement("fromaid");
            parent.appendChild(aidElem);
            try {
                ApplicationElement aeObj = asObj.getElementById(aid);
                aidElem.setAttribute("ae", aeObj.getName());
            }
            catch (AoException aoe) {
                throw new QueryStructureGeneratorException(OdsxHelper.aoExceptionToString(aoe), aoe);
            }
        }
    }

    public void appendToAID(ApplicationStructure asObj, T_LONGLONG aid, Element parent) throws QueryStructureGeneratorException {
        if (aid != null) {
            Document doc = parent.getOwnerDocument();
            Element aidElem = doc.createElement("toaid");
            parent.appendChild(aidElem);
            try {
                ApplicationElement aeObj = asObj.getElementById(aid);
                aidElem.setAttribute("ae", aeObj.getName());
            }
            catch (AoException aoe) {
                throw new QueryStructureGeneratorException(OdsxHelper.aoExceptionToString(aoe), aoe);
            }
        }
    }

    public InstanceElement evalUnit(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        InstanceElement ret = null;
        if (elem != null) {
            String id = elem.getAttribute("id");
            String name = elem.getAttribute("name");
            try {
                ApplicationElement[] arr = asObj.getElementsByBaseType("aounit");
                ApplicationElement unit = null;
                if (arr.length == 1) {
                    unit = arr[0];
                } else if (arr.length > 1) {
                    throw new QueryStructureGeneratorException("ApplicationElement derived from aoUnit is not uniq.");
                }
                if (id.length() > 0) {
                    ret = unit.getInstanceById(OdsxHelper.parseLongLong(id));
                } else if (name.length() > 0) {
                    unit.getInstanceByName(name);
                }
            }
            catch (AoException aoe) {
                throw new QueryStructureGeneratorException(OdsxHelper.aoExceptionToString(aoe), aoe);
            }
            catch (NumberFormatException nfe) {
                throw new QueryStructureGeneratorException(nfe);
            }
        }
        return ret;
    }

    public void appendUnit(ApplicationStructure asObj, T_LONGLONG unitId, Element parent) throws QueryStructureGeneratorException {
        if (unitId != null && (unitId.low != 0 || unitId.high != 0)) {
            String unitString = null;
            try {
                ApplicationElement[] arr = asObj.getElementsByBaseType("aounit");
                ApplicationElement unit = null;
                unit = arr[0];
                InstanceElement ieObj = unit.getInstanceById(unitId);
                unitString = ieObj.getName();
                ieObj.destroy();
            }
            catch (Throwable t) {
                // empty catch block
            }
            Document doc = parent.getOwnerDocument();
            Element unitElem = doc.createElement("selaidnameunitid");
            parent.appendChild(unitElem);
            if (unitString != null) {
                unitElem.setAttribute("name", unitString);
            } else {
                unitElem.setAttribute("id", OdsxHelper.t_longlongToString(unitId));
            }
        }
    }

    public AggrFunc evalAggregate(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        String value;
        AggrFunc ret = AggrFunc.NONE;
        if (elem != null && (value = elem.getAttribute("value")).length() != 0 && (value = value.toUpperCase()).compareTo("NONE") != 0) {
            Class clazz = AggrFunc.class;
            try {
                Field field = clazz.getField(value);
                ret = (AggrFunc)field.get(null);
            }
            catch (Throwable t) {
                throw new QueryStructureGeneratorException("Aggregate " + value + " not found in API.", t);
            }
        }
        return ret;
    }

    public void appendAggregate(ApplicationStructure asObj, AggrFunc aggr, Element parent) throws QueryStructureGeneratorException {
        if (aggr != null) {
            Class clazz = AggrFunc.class;
            String aggrValue = null;
            try {
                Field[] fields = clazz.getFields();
                int value = aggr.value();
                int size = fields.length;
                for (int i = 0; aggrValue == null && i < size; ++i) {
                    String name = fields[i].getName();
                    if (name.charAt(0) != '_' || (Integer)fields[i].get(null) != value) continue;
                    aggrValue = name.substring(1, name.length()).toLowerCase();
                }
            }
            catch (Throwable t) {
                throw new QueryStructureGeneratorException("Cannot evaluate aggregate function [" + aggr.value() + "].");
            }
            if (aggrValue != null) {
                Document doc = parent.getOwnerDocument();
                Element aggrElem = doc.createElement("aggregate");
                parent.appendChild(aggrElem);
                aggrElem.setAttribute("value", aggrValue);
            } else {
                throw new QueryStructureGeneratorException("Unknown aggregate function [" + aggr.value() + "] found.");
            }
        }
    }

    public JoinType evalJoinType(ApplicationStructure asObj, Element elem) throws QueryStructureGeneratorException {
        String value;
        JoinType ret = JoinType.JTDEFAULT;
        if (elem != null && (value = elem.getAttribute("jointype")).length() != 0 && (value = value.toUpperCase()).compareTo("JTDEFAULT") != 0) {
            Class clazz = JoinType.class;
            try {
                Field field = clazz.getField(value);
                ret = (JoinType)field.get(null);
            }
            catch (Throwable t) {
                throw new QueryStructureGeneratorException("JoinType " + value + " not found in API.", t);
            }
        }
        return ret;
    }

    public void appendJoinType(ApplicationStructure asObj, JoinType joinType, Element parent) throws QueryStructureGeneratorException {
        if (joinType != null) {
            int value = joinType.value();
            Class clazz = JoinType.class;
            String tValue = null;
            try {
                Field[] fields = clazz.getFields();
                int size = fields.length;
                for (int i = 0; tValue == null && i < size; ++i) {
                    String name = fields[i].getName();
                    if (name.charAt(0) != '_' || (Integer)fields[i].get(null) != value) continue;
                    tValue = name.substring(1, name.length()).toLowerCase();
                }
            }
            catch (Throwable t) {
                throw new QueryStructureGeneratorException("Cannot evaluate join type [" + value + "].");
            }
            if (tValue != null) {
                parent.setAttribute("jointype", tValue);
            } else {
                throw new QueryStructureGeneratorException("Unknown join type [" + value + "] found.");
            }
        }
    }

    protected boolean evalBoolean(String value, boolean defValue) {
        if (value.length() == 0) {
            return defValue;
        }
        char c = value.toLowerCase().charAt(0);
        return c == 't' || c == 'w' || c == '1' || c == 'y' || c == 'j';
    }

    protected Element getSingleObligatoryElement(Element parent, String name, boolean obligatory) throws MultipleElementNotAllowedException, MissingChildNodeException {
        Element ret = null;
        NodeList nodeList = parent.getElementsByTagName(name);
        if (nodeList.getLength() == 1) {
            ret = (Element)nodeList.item(0);
        } else {
            if (nodeList.getLength() != 0) {
                throw new MultipleElementNotAllowedException("Element " + name + " is multiple defined for element " + parent.getNodeName() + ".");
            }
            if (obligatory && nodeList.getLength() == 0) {
                throw new MissingChildNodeException("Element " + name + " must be defined as child of element " + parent.getNodeName() + ".");
            }
        }
        return ret;
    }
}

