/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hqlx;

import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.hqlx.HQLXResultSetPrinter;
import com.highqsoft.odsx.hqlx.ObjectFactory;
import com.highqsoft.odsx.hqlx.QueryStructureGeneratorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplElemAccess;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.QueryStructureExt;
import org.asam.ods.ResultSetExt;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class QSEFromXML {
    PrintStream sysOut = null;
    PrintStream sysErr = null;
    protected File xmlFile;
    protected InputStream inputStream;
    protected InputSource inputSource;
    protected String uri;
    protected Document doc;

    public QSEFromXML(String uri) throws ParserConfigurationException, SAXException, FileNotFoundException, IOException {
        this.uri = uri;
        this.parse();
    }

    public QSEFromXML(InputSource source) throws ParserConfigurationException, SAXException, FileNotFoundException, IOException {
        this.inputSource = source;
        this.parse();
    }

    public QSEFromXML(InputStream stream) throws ParserConfigurationException, SAXException, FileNotFoundException, IOException {
        this.inputStream = stream;
        this.parse();
    }

    public QSEFromXML(File file) throws ParserConfigurationException, SAXException, FileNotFoundException, IOException {
        this.xmlFile = file;
        this.parse();
    }

    protected Document parse() throws ParserConfigurationException, SAXException, FileNotFoundException, IOException {
        this.doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        if (this.xmlFile != null) {
            this.doc = db.parse(this.xmlFile);
        } else if (this.inputSource != null) {
            this.doc = db.parse(this.inputSource);
        } else if (this.inputStream != null) {
            this.doc = db.parse(this.inputStream);
        } else if (this.uri != null) {
            this.doc = db.parse(this.uri);
        }
        return this.doc;
    }

    public Element getFirstNodeOf(String name) {
        NodeList list = this.doc.getElementsByTagName(name);
        Element elem = null;
        if (list.getLength() == 0) {
            list = this.doc.getElementsByTagName("*");
        } else if (list.getLength() == 1) {
            elem = (Element)list.item(0);
        }
        if (elem == null) {
            int size = list.getLength();
            for (int i = 0; elem == null && i < size; ++i) {
                Node node = list.item(i);
                if (node.getNodeName().compareToIgnoreCase(name) != 0) continue;
                elem = (Element)node;
            }
        }
        return elem;
    }

    public QueryStructureExt getQueryStructureExt(ApplicationStructure asObj) throws QueryStructureGeneratorException {
        Element qse = this.getFirstNodeOf("querystructureext");
        if (qse != null) {
            ObjectFactory factory = ObjectFactory.getInstance();
            return factory.getQueryStructureExt(asObj, qse);
        }
        throw new QueryStructureGeneratorException("<querystructureext> node not found.");
    }

    public AoSession getAoSession() throws QueryStructureGeneratorException {
        Element aosession = this.getFirstNodeOf("aosession");
        AoSession aoSession = null;
        if (aosession != null) {
            ObjectFactory factory = ObjectFactory.getInstance();
            aoSession = factory.evalAoSession(aosession);
        }
        return aoSession;
    }

    public void resetOutputStreams() {
        if (this.sysOut != null) {
            System.setOut(this.sysOut);
        }
        if (this.sysErr != null) {
            System.setErr(this.sysErr);
        }
    }

    public void setOutputStreams() throws Exception {
        ObjectFactory factory = ObjectFactory.getInstance();
        if (this.doc != null) {
            PrintStream ps;
            NodeList list = this.doc.getElementsByTagName("out");
            if (list != null && list.getLength() > 0 && (ps = factory.getPrintStream((Element)list.item(0))) != null) {
                if (this.sysOut == null) {
                    this.sysOut = System.out;
                }
                System.setOut(ps);
            }
            if ((list = this.doc.getElementsByTagName("err")) != null && list.getLength() > 0 && (ps = factory.getPrintStream((Element)list.item(0))) != null) {
                if (this.sysErr == null) {
                    this.sysErr = System.err;
                }
                System.setErr(ps);
            }
        }
    }

    public static void test(InputStream stream) throws Exception {
        QSEFromXML xml = new QSEFromXML(stream);
        xml.executeTest(null);
    }

    public static void test(AoSession aoSession, InputStream stream) throws Exception {
        QSEFromXML xml = new QSEFromXML(stream);
        xml.executeTest(aoSession);
    }

    protected void executeTest(AoSession aoSession) throws AoException, QueryStructureGeneratorException {
        boolean aoSessionWasNull;
        try {
            this.setOutputStreams();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        boolean bl = aoSessionWasNull = aoSession == null;
        if (aoSessionWasNull) {
            aoSession = this.getAoSession();
        }
        if (aoSession != null) {
            ApplicationStructure asObj = aoSession.getApplicationStructure();
            long time = System.currentTimeMillis();
            QueryStructureExt qse = this.getQueryStructureExt(asObj);
            long evalTime = System.currentTimeMillis() - time;
            time = System.currentTimeMillis();
            ApplElemAccess aea = aoSession.getApplElemAccess();
            ResultSetExt[] results = aea.getInstancesExt(qse, 0);
            long accessTime = System.currentTimeMillis() - time;
            time = System.currentTimeMillis();
            HQLXResultSetPrinter printer = new HQLXResultSetPrinter(asObj, results);
            long printTime = System.currentTimeMillis() - time;
            printer.printCols(System.out);
            System.out.println(printer.getRowCount() + " rows selected.");
            System.out.println("Elapsed time for evaluation " + evalTime + " msec.");
            System.out.println("Elapsed time for selection " + accessTime + " msec.");
            System.out.println("Elapsed time for printing " + printTime + " msec.");
            System.out.println("Total elapsed time " + (evalTime + accessTime + printTime) + " msec.");
            if (aoSessionWasNull) {
                aoSession.close();
            }
        } else {
            System.err.println("There is no session defined.");
        }
        try {
            this.resetOutputStreams();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            InputStream stream = null;
            if (args.length > 0) {
                try {
                    URL url = new URL(args[0]);
                    stream = url.openStream();
                }
                catch (MalformedURLException mfue) {
                    try {
                        stream = new FileInputStream(args[0]);
                    }
                    catch (FileNotFoundException fnf) {
                        System.err.println(fnf.getMessage());
                    }
                }
            }
            if (stream == null) {
                Class clazz = QSEFromXML.class;
                stream = clazz.getResourceAsStream("QueryStructureExtExample.xml");
            }
            QSEFromXML.test(stream);
        }
        catch (AoException aoe) {
            System.err.println(OdsxHelper.aoExceptionToString(aoe));
            aoe.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

