/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.hqlx;

import com.highqsoft.odsx.hqlx.ObjectFactory;
import com.highqsoft.odsx.hqlx.QSEFromXML;
import com.highqsoft.odsx.hqlx.QueryStructureGeneratorException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.QueryStructureExt;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QSEToXML {
    public Document generate(ApplicationStructure asObj, QueryStructureExt qse) throws ParserConfigurationException, QueryStructureGeneratorException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        ObjectFactory oFac = ObjectFactory.getInstance();
        Document doc = db.newDocument();
        Element asamods = doc.createElement("asamods");
        doc.appendChild(asamods);
        if (qse != null) {
            oFac.getQueryStructureExtElem(asObj, qse, asamods);
        }
        return doc;
    }

    public static void printNode(PrintStream printer, String prefix, Node node) {
        short type = node.getNodeType();
        String nodeName = node.getNodeName();
        if (type == 1) {
            printer.print(prefix);
            printer.print("<" + nodeName);
            NamedNodeMap map = node.getAttributes();
            int size = map.getLength();
            for (int i = 0; i < size; ++i) {
                Node aNode = map.item(i);
                printer.print(" " + aNode.getNodeName() + "=\"" + aNode.getNodeValue() + "\"");
            }
            NodeList nodeList = node.getChildNodes();
            size = nodeList.getLength();
            if (size > 0) {
                printer.println(">");
                String p = prefix + "   ";
                for (int i = 0; i < size; ++i) {
                    QSEToXML.printNode(printer, p, nodeList.item(i));
                }
                printer.println(prefix + "</" + nodeName + ">");
            } else {
                printer.println("/>");
            }
        } else {
            NodeList nodeList = node.getChildNodes();
            int size = nodeList.getLength();
            if (size > 0) {
                String p = prefix;
                for (int i = 0; i < size; ++i) {
                    QSEToXML.printNode(printer, p, nodeList.item(i));
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            InputStream stream = null;
            if (args.length > 0) {
                try {
                    URL url = new URL(args[0]);
                    stream = url.openStream();
                }
                catch (MalformedURLException mfue) {
                    try {
                        stream = new FileInputStream(args[0]);
                    }
                    catch (FileNotFoundException fnf) {
                        System.err.println(fnf.getMessage());
                    }
                }
            }
            if (stream == null) {
                Class clazz = QSEFromXML.class;
                stream = clazz.getResourceAsStream("QueryStructureExtExample.xml");
            }
            QSEFromXML xml = new QSEFromXML(stream);
            AoSession aoSession = xml.getAoSession();
            ApplicationStructure asObj = aoSession.getApplicationStructure();
            QSEToXML toXML = new QSEToXML();
            Document doc = toXML.generate(asObj, xml.getQueryStructureExt(asObj));
            QSEToXML.printNode(System.out, "", doc);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

