/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.listener;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkExecuteStateEvent;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionConnectInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import com.highqsoft.util.StringFormat;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractAction;

public class OdsxNewSessionListener
extends AbstractAction
implements ActionListener {
    public static final String version = "$Revision: 1.9 $";
    OdsxSessionConnectInterface controller;
    Container dialogParent;

    public String getVersion() {
        return version;
    }

    private OdsxNewSessionListener() {
        this.dialogParent = null;
    }

    public OdsxNewSessionListener(OdsxSessionConnectInterface controller) {
        this.controller = controller;
    }

    public OdsxNewSessionListener(OdsxSessionConnectInterface controller, Container dialogParent) {
        this.controller = controller;
        this.dialogParent = dialogParent;
    }

    public void actionPerformed(ActionEvent ev) {
        if (this.dialogParent == null) {
            this.dialogParent = FwkGUIFactory.getDialogParent((EventObject)ev);
        }
        NewSessionThread st = new NewSessionThread(this.dialogParent, this.controller, (OdsxSessionInterface)this.getValue("OdsxSession"));
        st.start();
    }

    public class NewSessionThread
    extends FwkThread {
        OdsxSessionInterface odsSession;
        OdsxSessionConnectInterface controller;
        Container root;

        public NewSessionThread(Container root, OdsxSessionConnectInterface controller, OdsxSessionInterface odsSession) {
            this.odsSession = odsSession;
            this.controller = controller;
            this.root = root;
        }

        public void run() {
            if (this.controller != null && this.controller instanceof FwkApplicationInterface) {
                ((FwkApplicationInterface)this.controller).fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 2, FwkPropertyBus.getProperty((String)"Text.Open") + " " + this.odsSession.getName()));
            }
            if (this.odsSession != null) {
                if (this.root != null && OdsxSessionFactory.getDialogParent(this.odsSession) == null) {
                    OdsxSessionFactory.setDialogParent(this.odsSession, this.root);
                }
                if (this.odsSession.isValid()) {
                    if (this.odsSession.hasPermissions()) {
                        this.controller.connectToSession(this.odsSession);
                    } else {
                        FwkContainer.showErrorMessage((Container)this.root, (String)StringFormat.printf((String)FwkPropertyBus.getProperty((String)"OdsxSession.Error.NoPermissions"), (String)this.odsSession.getServiceName()), (String)FwkPropertyBus.getProperty((String)"Error.Hint"), (String)this.odsSession.toString());
                        try {
                            this.odsSession.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        this.odsSession = null;
                    }
                } else {
                    if (!this.odsSession.wasCancelled()) {
                        FwkContainer.showErrorMessage((Container)this.root, (String)StringFormat.printf((String)FwkPropertyBus.getProperty((String)"OdsxSession.Error.NoSession"), (String)this.odsSession.getServiceName()), (String)FwkPropertyBus.getProperty((String)"Error.Hint"), (String)this.odsSession.toString());
                    }
                    this.odsSession.close();
                }
            } else {
                try {
                    this.odsSession.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                FwkContainer.showErrorMessage((Container)this.root, (String)StringFormat.printf((String)FwkPropertyBus.getProperty((String)"OdsxSession.Error.NoSession"), (String)this.odsSession.getServiceName()), (String)FwkPropertyBus.getProperty((String)"Error.Hint"), (String)null);
                this.odsSession = null;
            }
            if (this.controller != null && this.controller instanceof FwkApplicationInterface) {
                ((FwkApplicationInterface)this.controller).fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
            }
        }
    }
}

