/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.listener;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.util.StringUtilities;
import com.highqsoft.interfaces.odsx.OdsxSessionConnectInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.ods.AoService;
import com.highqsoft.odsx.OdsxSession;
import com.highqsoft.odsx.listener.OdsxNewSessionListener;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class OdsxServiceListener
extends AbstractAction
implements MenuListener {
    public static final String version = "$Revision: 1.10 $";
    OdsxSessionConnectInterface controller;

    public String getVersion() {
        return version;
    }

    private OdsxServiceListener() {
    }

    public OdsxServiceListener(OdsxSessionConnectInterface controller) {
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public void menuCanceled(MenuEvent ev) {
    }

    public void menuDeselected(MenuEvent ev) {
    }

    public void menuSelected(MenuEvent ev) {
        JMenu menu = (JMenu)ev.getSource();
        Container root = FwkGUIFactory.getDialogParent((EventObject)ev);
        if (root == null && this.controller != null && this.controller instanceof Container) {
            root = (Container)((Object)this.controller);
        }
        if (root != null) {
            root.setCursor(Cursor.getPredefinedCursor(3));
        }
        menu.removeAll();
        OdsxSession odsSession = new OdsxSession();
        odsSession.setPlumName((String)this.getValue("PLUM_NAME"));
        String sessionOptions = this.controller.getSessionOptionString();
        String serviceOptions = this.controller.getServiceOptionString();
        if (serviceOptions != null) {
            odsSession.setServiceOptions(serviceOptions);
        }
        if (sessionOptions != null) {
            odsSession.setSessionOptions(sessionOptions);
        }
        try {
            odsSession.getService();
        }
        catch (FwkException tService) {
            FwkContainer.showErrorMessage((Container)root, (String)"Error.Occured", (String)"Error.Hint", (Throwable)tService);
            try {
                odsSession.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            odsSession = null;
            System.err.println("\nOdsxServiceListener, menuSelected failed:\n   " + tService.toString());
        }
        int nServices = 0;
        if (odsSession != null) {
            try {
                AoService service = odsSession.getService();
                String[] plumServiceNames = service.listServices("*");
                nServices = plumServiceNames.length;
                for (int i = 0; i < nServices; ++i) {
                    if (plumServiceNames[i].toUpperCase().startsWith("STUB/")) continue;
                    String[] elems = StringUtilities.split((String)plumServiceNames[i], (int)47, (boolean)true);
                    this.createMenuItem(root, elems, 0, menu, odsSession, plumServiceNames[i]);
                }
            }
            catch (Exception fwke) {
                if (FwkContainer.getDebugLevel() > 0) {
                    FwkContainer.showErrorMessage((Container)root, (String)"Error.Occured", (String)"Error.Hint", (Throwable)fwke);
                }
                nServices = -1;
            }
            if (nServices <= 0) {
                JMenuItem mi = new JMenuItem();
                mi.setText(FwkPropertyBus.getProperty((String)"Text.NoServices"));
                mi.setEnabled(false);
                menu.add(mi);
            }
        }
        root.setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void createMenuItem(Container root, String[] elems, int index, JMenu menu, OdsxSessionInterface odsSession, String plumServiceName) {
        if (elems.length - 1 > index) {
            JMenu subMenu;
            boolean stop = false;
            int count = menu.getMenuComponentCount();
            JMenuItem child = null;
            while (count > 0 && !stop) {
                stop = elems[index].compareTo((child = menu.getItem(--count)).getText()) == 0;
            }
            if (stop && child != null && child instanceof JMenu) {
                subMenu = (JMenu)child;
            } else {
                subMenu = new JMenu(elems[index]);
                menu.add(subMenu);
            }
            this.createMenuItem(root, elems, index + 1, subMenu, odsSession, plumServiceName);
        } else {
            JMenuItem mi = new JMenuItem();
            mi.setText(elems[index]);
            OdsxNewSessionListener onsl = new OdsxNewSessionListener(this.controller, root);
            mi.addActionListener(onsl);
            OdsxSession session = new OdsxSession();
            session.setServiceOptions(odsSession.getServiceOptions());
            session.setSessionOptions(odsSession.getSessionOptions());
            session.setPlumName(odsSession.getPlumName());
            session.setServiceName(plumServiceName);
            onsl.putValue("OdsxSession", session);
            if (this.controller != null) {
                mi.putClientProperty("Controller", this.controller);
            }
            menu.add(mi);
        }
    }
}

