/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.listener;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.listener.FwkListener;
import com.highqsoft.interfaces.fwk.FwkCommandActionInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSelectorTreeNodeInterface;
import com.highqsoft.odsx.dialog.OdsxTranslateDialogPane;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JComponent;

public class OdsxTranslatePresentableListener
extends FwkListener
implements FwkCommandActionInterface,
ActionListener {
    public static final String version = "$Revision: 1.5 $";
    static OdsxTranslatePresentableListener singleInstance;
    static FwkDialogPaneValueInterface textValue;
    static OdsxTranslateDialogPane pane;

    public String getVersion() {
        return version;
    }

    private OdsxTranslatePresentableListener() {
    }

    public static synchronized FwkListener getInstance() {
        if (singleInstance == null) {
            singleInstance = new OdsxTranslatePresentableListener();
        }
        return singleInstance;
    }

    public void actionPerformed(FwkCommandInterface cmd) {
        Object obj = cmd.getProperty(OdsxSelectorTreeNodeInterface.class.getName());
        if (obj != null) {
            this.translate((OdsxSelectorTreeNodeInterface)obj, null);
        } else {
            OdsxPresentableElementInterface elem = (OdsxPresentableElementInterface)cmd.getController();
            try {
                this.translate(elem, null);
            }
            catch (Throwable t) {
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(elem.getSession()), null, null, (Throwable)t);
            }
        }
    }

    public void actionPerformed(ActionEvent ev) {
        Container parent = FwkGUIFactory.getDialogParent((EventObject)ev);
        Object obj = ((JComponent)ev.getSource()).getClientProperty(OdsxSelectorTreeNodeInterface.class.getName());
        if (obj != null) {
            this.translate((OdsxSelectorTreeNodeInterface)obj, ev);
        } else {
            OdsxPresentableElementInterface elem = (OdsxPresentableElementInterface)FwkContainer.getController((Object)((JComponent)ev.getSource()));
            try {
                this.translate(elem, ev);
            }
            catch (Throwable t) {
                if (parent == null) {
                    parent = OdsxSessionFactory.getDialogParent(elem.getSession());
                }
                FwkContainer.showErrorMessage((Container)parent, null, null, (Throwable)t);
            }
        }
    }

    protected void translate(OdsxSelectorTreeNodeInterface node, ActionEvent ev) {
        Container leader = FwkGUIFactory.getDialogParent((EventObject)ev);
        String newValue = this.showDialog(leader, node.getTranslatedName(), node.getPresentableElement().getShortName());
        if (newValue != null) {
            node.setTranslatedName(newValue);
        }
    }

    protected void translate(OdsxPresentableElementInterface node, ActionEvent ev) {
        Container leader = FwkGUIFactory.getDialogParent((EventObject)ev);
        String newValue = this.showDialog(leader, node.getOdsxFilter().getTranslatedName(node), node.getShortName());
        if (newValue != null) {
            node.getOdsxFilter().setTranslatedName(node, newValue);
        }
    }

    protected String showDialog(Component leader, String currentName, String orgName) {
        String title = FwkPropertyBus.getProperty((String)"OdsxTranslatePresentableListener.Text.GUITitle");
        if (pane == null) {
            pane = new OdsxTranslateDialogPane();
            textValue = pane.getSelectedValue();
        }
        textValue.setProperty("TextField", (Object)currentName);
        pane.setOriginalText(orgName);
        pane.setSelectedValue(textValue);
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog((Component)leader, (String)title, (String)"", (FwkDialogPaneInterface)pane);
        if (val != null) {
            textValue = val;
            return (String)textValue.getProperty("TextField");
        }
        return null;
    }

    static {
        textValue = null;
        pane = null;
    }
}

