/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.uml;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.ods.AoService;
import com.highqsoft.ods.AoServiceFactory;
import com.highqsoft.odsx.OdsxSession;
import com.highqsoft.uml.UMLBean;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.asam.ods.AoFactory;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationStructure;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class UML2ODS {
    public static final String version = "$Revision: 1.3 $";
    public static final String CLASSNAME = "UML2ODS ";
    public static final String AO_SERVICE_ATHOS = "com.highqsoft.ods.athos.AoService";
    public static final String AO_SERVICE_CORBA = "com.highqsoft.ods.corba.AoService";
    public static final String LOGON_USERPARM = "USER";
    public static final String LOGON_PASSWORDPARM = "PASSWORD";

    public String getVersion() {
        return version;
    }

    public static void main(String[] args) {
        int i;
        String serviceName = "";
        String serviceType = "athos";
        String atfFileName = "";
        String umlFileName = "";
        String userName = "markq";
        String password = "jane";
        String hostName = "";
        String portName = "";
        System.out.println("UML2ODS  input  args are " + args.length);
        for (i = 0; i < args.length; ++i) {
            System.out.println("Args" + i + " = " + args[i]);
        }
        for (i = 0; i < args.length - 1; ++i) {
            if (args[i].equalsIgnoreCase("-service")) {
                System.out.println("service is" + i + " = " + args[i + 1]);
                serviceName = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-atf")) {
                System.out.println("atf is" + i + " = " + args[i + 1]);
                atfFileName = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-type")) {
                System.out.println("type is" + i + " = " + args[i + 1]);
                serviceType = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-uml")) {
                System.out.println("uml is" + i + " = " + args[i + 1]);
                umlFileName = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-pwd")) {
                System.out.println("pwd is" + i + " = " + args[i + 1]);
                password = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-user")) {
                System.out.println("user is" + i + " = " + args[i + 1]);
                userName = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-port")) {
                System.out.println("port is" + i + " = " + args[i + 1]);
                portName = args[i + 1];
            }
            if (!args[i].equalsIgnoreCase("-host")) continue;
            System.out.println("host is" + i + " = " + args[i + 1]);
            hostName = args[i + 1];
        }
        if (args.length < 3) {
            UML2ODS.usage();
            return;
        }
        System.out.println("atfFileName  " + atfFileName);
        System.out.println("UMLFileName  " + umlFileName);
        System.out.println("asamOdsService  " + serviceName);
        if (args[0].equalsIgnoreCase("genUML")) {
            UML2ODS.publishAStoUML(serviceName, serviceType, atfFileName, umlFileName, userName, password, hostName, portName);
            System.out.println("genUML completed ");
            return;
        }
        if (args[0].equalsIgnoreCase("genODS")) {
            UML2ODS.publishUMLToATF(serviceName, serviceType, atfFileName, umlFileName);
            System.out.println("genODS completed ");
            return;
        }
        UML2ODS.usage();
    }

    private static String publishUMLToATF(String serviceName, String serviceType, String atfFileName, String umlFileName) {
        File atfxoFile;
        File atfxFile = new File(atfFileName);
        if (atfxFile.exists()) {
            System.out.println(CLASSNAME + atfxFile.getName() + " already exists");
            if (atfxFile.delete()) {
                System.out.println(CLASSNAME + atfxFile.getName() + " deleted");
            } else {
                System.out.println("UML2ODS unable to delete existing file " + atfxFile.getName());
            }
        }
        if ((atfxoFile = new File(atfFileName + "_O")).exists()) {
            System.out.println(CLASSNAME + atfxoFile.getName() + " already exists");
            if (atfxoFile.delete()) {
                System.out.println(CLASSNAME + atfxoFile.getName() + " deleted");
            } else {
                System.out.println("UML2ODS unable to delete existing file " + atfxoFile.getName());
            }
        }
        try {
            String asamOdsComponent = AO_SERVICE_ATHOS;
            AoService aoService = AoServiceFactory.newService(asamOdsComponent, null);
            AoFactory aoFactory = aoService.newFactory(serviceName, null);
            System.out.println("test have aofactory");
            AoSession aoSession = aoFactory.newSession("FILENAME=" + atfFileName + ",  OPENMODE=write");
            System.out.println("test have aoSession ");
            ApplicationStructure asTarget = aoSession.getApplicationStructure();
            Document doc = UML2ODS.readDocument(umlFileName);
            System.out.println("start trans ");
            aoSession.startTransaction();
            UMLBean umlBean = new UMLBean();
            umlBean.genASfromUML(doc, asTarget);
            aoSession.commitTransaction();
            System.out.println("UML2ODS  close session");
            aoSession.close();
            Runtime r = Runtime.getRuntime();
            aoSession = null;
            aoFactory = null;
            r.gc();
            System.out.println("UML2ODS  temp file " + atfxoFile.getName() + " created. ");
            System.out.println("UML2ODS  Path is " + atfxoFile.getPath());
            boolean success = atfxoFile.renameTo(new File(atfxoFile.getParent(), atfxFile.getName()));
            if (!success) {
                System.out.println(CLASSNAME + atfxoFile.getName() + "not renamed");
            } else {
                System.out.println(CLASSNAME + atfxoFile.getName() + " renamed to " + atfxFile.getName());
            }
        }
        catch (Exception e) {
            System.out.println(" exception in testATFWriter " + e.toString());
            e.printStackTrace();
        }
        return null;
    }

    private static String publishAStoUML(String serviceName, String serviceType, String atfFileName, String umlFileName, String userName, String password, String hostName, String portName) {
        System.out.println(" begin publishAStoUML ");
        ApplicationStructure as = null;
        if (serviceType.equalsIgnoreCase("ATF/FILE")) {
            System.out.println(" Process ATF file " + atfFileName);
            if (!UML2ODS.checkFileExists(atfFileName)) {
                System.out.println(" file " + atfFileName + " does not exist");
                return null;
            }
            System.out.println("UML2ODS obtaining app structure from " + atfFileName);
            as = UML2ODS.getAppStructure(atfFileName, "importer");
        } else {
            OdsxSession odsxSession = UML2ODS.CreateSession(userName, password, serviceType, serviceName, hostName, portName);
            if (odsxSession == null) {
                System.out.println("Connection failed ");
                return null;
            }
            try {
                as = odsxSession.getSession().getApplicationStructure();
            }
            catch (Exception e) {
                System.out.println("UML2ODS Exception authenticating user " + e.toString());
            }
        }
        UMLBean umlBean = new UMLBean();
        System.out.println("UML2ODS  begin creating UML output");
        int rc = umlBean.genUMLfromAS(as);
        System.out.println(" UMLbean rc " + umlBean.getRc());
        System.out.println("UML2ODS creating xmi file to hold output: " + umlFileName);
        if (rc == 0) {
            try {
                Document doc = umlBean.getOutputDoc();
                FileOutputStream out = new FileOutputStream(umlFileName);
                XMLOutputter serializer = new XMLOutputter();
                serializer.output(doc, (OutputStream)out);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        return null;
    }

    public static Document readDocument(String fileName) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document anotherDocument = builder.build(new File(fileName));
            return anotherDocument;
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean checkFileExists(String fullFileName) {
        boolean exists = new File(fullFileName).exists();
        return exists;
    }

    private static ApplicationStructure getAppStructure(String fullFileName, String serviceName) {
        AoSession aoSession = UML2ODS.getATFSession(serviceName, fullFileName);
        try {
            return aoSession.getApplicationStructure();
        }
        catch (Exception e) {
            System.out.println("UML2ODS .getAppStructure Exception " + e.toString());
            return null;
        }
    }

    public static OdsxSession CreateSession(String username, String password, String servicetype, String service, String hostName, String portName) {
        try {
            String[] args = new String[]{"-Odsx.NewSession.AskForPassword", "false", "-BatchMode", "true", "-NameServiceHost", hostName, "-NameServicePort", portName};
            System.out.println("UML2ODS initializing framework with args ");
            for (int i = 0; i < args.length; ++i) {
                System.out.println("UML2ODS  framework arg " + i + " = " + args[i]);
            }
            FwkContainer.initialize(args);
        }
        catch (Exception e) {
            System.out.println("UML2ODS  Framework initialization failed " + e.toString());
        }
        OdsxSession odsxSession = new OdsxSession();
        odsxSession.setServiceName(service);
        String plumname = AO_SERVICE_ATHOS;
        System.out.println("Requested servicetype " + servicetype);
        if (servicetype.equalsIgnoreCase("corba")) {
            plumname = AO_SERVICE_CORBA;
        }
        System.out.println("Plumname " + plumname + "- servicename " + service);
        odsxSession.setPlumName(plumname);
        String authstring = "USER=" + username + "," + LOGON_PASSWORDPARM + "=" + password;
        System.out.println("Setting authentication authstring " + authstring);
        odsxSession.setAuthentication(authstring);
        return odsxSession;
    }

    public static AoSession getATFSession(String serviceName, String fileName) {
        return UML2ODS.getATFSession(serviceName, fileName, "athos");
    }

    public static AoSession getATFSession(String serviceName, String fileName, String serviceType) {
        AoSession aoSession = null;
        try {
            OdsxSession session = new OdsxSession();
            session.setServiceName(serviceName);
            String plumName = serviceType.equalsIgnoreCase("corba") ? AO_SERVICE_CORBA : AO_SERVICE_ATHOS;
            session.setPlumName(plumName);
            session.setServiceOptions("INIFILE=ATHOS_INI");
            String authstring = "USER=karst, PASSWORD=pisoft, FILENAME=" + fileName;
            session.setAuthentication(authstring);
            aoSession = session.getSession();
        }
        catch (Exception aoException) {
            System.out.println(" getATFSession, newService failed:\n   " + aoException.toString());
            return null;
        }
        return aoSession;
    }

    private static void usage() {
        System.out.println("UML2ODS converts UML XMI files into ODS application structures");
        System.out.println(" Usage: UML2ODS  command [command-options-and-arguments]");
        System.out.println(" where command is genuml or genods.");
        System.out.println("where command-options-and-arguments depend on the specific command");
        System.out.println(" -service  \tthe service name from the athos.ini file");
        System.out.println(" -atf  \t\tthe name of the XATF file to which the tool should write the model");
        System.out.println(" -uml  \t\tthe name of the XMI file to which the tool should write the model");
        System.out.println(" -user  \t\tuser for authentification");
        System.out.println(" -pwd\t\t\tpassword for authentification");
        System.out.println("\n\n\n **required are at lease -service and -atf OR -uml option");
    }
}

