#  @(#) $Id: setupathos.csh,v 1.1 2003/07/25 08:23:32 karst Exp $
#  ****************************************************************************
#  * COPYRIGHT , 1996-2001,                                                  *
#  * Bothe, Hans-Joachim  hans.bothe@highqsoft.de                             *
#  * Hofmann, Andreas     andreas.hofmann@highqsoft.de                        *
#  * Schaap, Karst        karst.schaap@highqsoft.de                           *
#  * Schlossborner Weg 6b, D-61479 Glashtten/Taunus, Germany                 *
#  * Phone: +49 6174 62915, Fax: +49 6174 62935, Internet: www.highqsoft.com  *
#  ****************************************************************************
#  *                                                                          *
#  * All Rights Reserved.                                                     *
#  *                                                                          *
#  * This software is the confidential and proprietary information of         *
#  * the authors. It may be freely copied and distributed with the            *
#  * following stipulations:                                                  *
#  *                                                                          *
#  *      o No fee except to recover costs of media and delivery may          *
#  *        be charged for the use or possession of this software.            *
#  *      o Sources to this utility must be made available in machine-        *
#  *        readable form along with the executable form.                     *
#  *      o No portion of this program may be used in any program sold        *
#  *        for a fee or for production purposes.                             *
#  *      o This copyright notice must not be removed.                        *
#  *                                                                          *
#  * All brand names and product names used in this software are trademarks,  *
#  * registered trademarks, or trade names of their respective holders.       *
#  * The authors of this software are not associated with any product or      *
#  * vendor mentioned in the code or documentation.                           *
#  *                                                                          *
#  ****************************************************************************
# 
#  BEGIN DOCUMENTATION
#  ----------------------------------------------------------------------------
# 
#  NAME:
#       setupathos.csh
# 
#  PURPOSE:
#       This command procedure does the setup for the Athos system
#	in C Shells. Operating system dependent directories are
#	automatically created if they do not exist. This is especially
#	very handy when porting Athos to a new operating system.
#
#  INDEX KEYWORDS:
#       <athos setup>, <setup>, <C Shell>
# 
#  PACKAGE:
#       ATHOS
# 
#  CALLING SEQUENCE:
#       source setupathos.csh
# 
#  ARGUMENTS:
#       None
# 
#  KNOWN RESTRICTIONS AND SIDE EFFECTS:
#       C Shell specific.
#
#  SEE ALSO:
#	setupathos for Bourne Shell setup.
#	setupathos.bat for C Shell setup.
#	setupathos.com for VAX/VMS Shell setup.
#	setupathos.ksh for Korn VAX/VMS Shell setup.
# 
#  MODIFICATION HISTORY:
#	$Log: setupathos.csh,v $
#	Revision 1.1  2003/07/25 08:23:32  karst
#	Initial version 3.0.
#
#	Revision 2.17  2002/04/26 06:55:24  karst
#	Correct the set of the TMP environment variable.
#	
#	Revision 2.16  2002/01/18 16:06:37  karst
#	Set the environment variable TMP.
#	
#	Revision 2.15  2001/08/22 13:02:35  hans
#	LD_* set properly and copyright updated.
#	
#	Revision 2.14  2001/08/22 09:59:58  hans
#	Variable SEARCH_DIR added and old content of
#	LD_RUN_PATH and LD_LIBRARY_PATH preserved.
#	
#	Revision 2.13  2001/04/23 11:28:15  karst
#	Added allias for hpbuild.
#	
#	Revision 2.12  2000/01/11 12:26:12  karst
#	Changed copyright to current.
#	
#	Revision 2.11  1999/02/10 08:18:35  karst
#	Change copyright to current.
#	
#	Revision 2.10  1998-12-29 14:49:09+01  karst
#	Change copyright notice to current.
#
#	Revision 2.9  1998-09-28 17:06:45+02  karst
#	Set the environment variable LD_RUN_PATH and LD_LIBRARY_PATH.
#	Suppress the alias of ascoba.
#
#	Revision 2.8  1998-09-28 15:25:50+02  karst
#	Create also the generall directories and not only the system dependent
#	directories.
#
#	Revision 2.7  1998-09-28 11:54:06+02  hans
#	Insert definition of LD_RUN_PATH needed for the linker to get directory
#	location independent code.
#
#	Revision 2.6  1998-09-18 17:32:19+02  hans
#	Alias for abuild set to abuild.csh.
#
#	Revision 2.5  1998-09-18 17:10:35+02  hans
#	Moved abuild to etc directory.
#
#	Revision 2.4  1998-09-18 16:09:58+02  hans
#	Redesigned version.
#
#  ----------------------------------------------------------------------------
#  END DOCUMENTATION

# Set root directory, operating system type and path name.
setenv ATHOS_ROOT `pwd`
setenv OSTYPE `uname -s`
if ($?PATH == 1) then
   setenv PATH ${PATH}:$ATHOS_ROOT/bin/$OSTYPE
else
   setenv PATH $ATHOS_ROOT/bin/$OSTYPE
endif

if ($?TMP == 1) then
   type $TMP
else
   setenv TMP $ATHOS_ROOT/tmp
endif

# Create all generall directories if they do not exist.
if ( ! -d bin )          mkdir bin
if ( ! -d log )          mkdir log
if ( ! -d lib )          mkdir lib
if ( ! -d obj )          mkdir obj
if ( ! -d tmp )          mkdir tmp

# Create all operating system dependent directories if they do not exist.
if ( ! -d bin/$OSTYPE )          mkdir bin/$OSTYPE
if ( ! -d etc/$OSTYPE )          mkdir etc/$OSTYPE
if ( ! -d lib/$OSTYPE )          mkdir lib/$OSTYPE
if ( ! -d obj/$OSTYPE )          mkdir obj/$OSTYPE
if ( ! -d drivers/avl2/$OSTYPE ) mkdir drivers/avl2/$OSTYPE
if ( ! -d drivers/avl3/$OSTYPE ) mkdir drivers/avl3/$OSTYPE
if ( ! -d aop3server/$OSTYPE )   mkdir aop3server/$OSTYPE

# Set alias for build procedure.
alias abuild $ATHOS_ROOT/etc/abuild.csh
alias hpbuild $ATHOS_ROOT/etc/hpbuild.csh

# Set alias for Ascoba application.
setenv ASCOBA_INI $ATHOS_ROOT/ascoba/ascoba.ini
#alias  ascoba "$ATHOS_ROOT/bin/$OSTYPE/ascoba"

# Define some global Athos symbols.
setenv ATHOS_MEMCHECK no
setenv ATHOS_DEBUG no
setenv ATHOS_WARNINGS no
setenv ATHOS_MAKEFLAGS "-rs"

# Define link search path.
if ($?LD_RUN_PATH == 1) then
   setenv LD_RUN_PATH "${LD_RUN_PATH}:$ATHOS_ROOT/bin/$OSTYPE"
else
   setenv LD_RUN_PATH "$ATHOS_ROOT/bin/$OSTYPE"
endif
if ($?LD_LIBRARY_PATH == 1) then
   setenv LD_LIBRARY_PATH "${LD_LIBRARY_PATH}:$ATHOS_ROOT/bin/$OSTYPE"
else
   setenv LD_LIBRARY_PATH "$ATHOS_ROOT/bin/$OSTYPE"
endif
setenv SEARCH_DIR "$ATHOS_ROOT/bin/$OSTYPE/"
