#  @(#) $Id: setupathos.ksh,v 1.1 2003/07/25 08:23:32 karst Exp $
#  ****************************************************************************
#  * COPYRIGHT , 1996-2001,                                                  *
#  * Bothe, Hans-Joachim  hans.bothe@highqsoft.de                             *
#  * Hofmann, Andreas     andreas.hofmann@highqsoft.de                        *
#  * Schaap, Karst        karst.schaap@highqsoft.de                           *
#  * Schlossborner Weg 6b, D-61479 Glashtten/Taunus, Germany                 *
#  * Phone: +49 6174 62915, Fax: +49 6174 62935, Internet: www.highqsoft.com  *
#  ****************************************************************************
#  *                                                                          *
#  * All Rights Reserved.                                                     *
#  *                                                                          *
#  * This software is the confidential and proprietary information of         *
#  * the authors. It may be freely copied and distributed with the            *
#  * following stipulations:                                                  *
#  *                                                                          *
#  *      o No fee except to recover costs of media and delivery may          *
#  *        be charged for the use or possession of this software.            *
#  *      o Sources to this utility must be made available in machine-        *
#  *        readable form along with the executable form.                     *
#  *      o No portion of this program may be used in any program sold        *
#  *        for a fee or for production purposes.                             *
#  *      o This copyright notice must not be removed.                        *
#  *                                                                          *
#  * All brand names and product names used in this software are trademarks,  *
#  * registered trademarks, or trade names of their respective holders.       *
#  * The authors of this software are not associated with any product or      *
#  * vendor mentioned in the code or documentation.                           *
#  *                                                                          *
#  ****************************************************************************
# 
#  BEGIN DOCUMENTATION
#  ----------------------------------------------------------------------------
# 
#  NAME:
#       setupathos.ksh
# 
#  PURPOSE:
#       This command procedure does the setup for the Athos system
#	in Korn Shells. Operating system dependent directories
#	are automatically created if they do not exist. This is
#	especially very handy when porting Athos to a new operating
#	system.
#
#  INDEX KEYWORDS:
#       <athos setup>, <setup>, <Korn Shell>
# 
#  PACKAGE:
#       ATHOS
# 
#  CALLING SEQUENCE:
#       setupathos.ksh
# 
#  ARGUMENTS:
#       None
# 
#  KNOWN RESTRICTIONS AND SIDE EFFECTS:
#       Korn Shell specific.
#
#  SEE ALSO:
#	setupathos for Bourne Shell setup.
#	setupathos.bat for MS-DOS setup.
#	setupathos.com for VAX/VMS setup.
#	setupathos.csh for C Shell setup.
# 
#  MODIFICATION HISTORY:
#	$Log: setupathos.ksh,v $
#	Revision 1.1  2003/07/25 08:23:32  karst
#	Initial version 3.0.
#
#	Revision 2.1  2001/08/22 13:05:05  hans
#	Initial CVS revision (not yet tested).
#	
#  ----------------------------------------------------------------------------
#  END DOCUMENTATION

# Set root directory, operating system type and path name.
export ATHOS_ROOT=`pwd`
export OSTYPE=`uname -s`
export PATH=$PATH:$ATHOS_ROOT/bin/$OSTYPE

# Create all generall directories if they do not exist.
if [ ! -d log ];          then mkdir log; fi
if [ ! -d bin ];          then mkdir bin; fi
if [ ! -d lib ];          then mkdir lib; fi
if [ ! -d obj ];          then mkdir obj; fi

# Create all operating system dependent directories if they do not exist.
if [ ! -d bin/$OSTYPE ];          then mkdir bin/$OSTYPE; fi
if [ ! -d etc/$OSTYPE ];          then mkdir etc/$OSTYPE; fi
if [ ! -d lib/$OSTYPE ];          then mkdir lib/$OSTYPE; fi
if [ ! -d obj/$OSTYPE ];          then mkdir obj/$OSTYPE; fi
if [ ! -d drivers/avl2/$OSTYPE ]; then mkdir drivers/avl2/$OSTYPE; fi
if [ ! -d drivers/avl3/$OSTYPE ]; then mkdir drivers/avl3/$OSTYPE; fi
if [ ! -d aop3server/$OSTYPE ];   then mkdir aop3server/$OSTYPE; fi

# Set alias for build procedure.
alias abuild=$ATHOS_ROOT/etc/abuild
alias hpbuild=$ATHOS_ROOT/etc/hpbuild

# Set alias for Ascoba application.
export ASCOBA_INI=$ATHOS_ROOT/ascoba/ascoba.ini
#alias ascoba=$ATHOS_ROOT/bin/$OSTYPE/ascoba

# Define some global Athos symbols.
export ATHOS_MEMCHECK=no
export ATHOS_DEBUG=no
export ATHOS_WARNINGS=yes
export ATHOS_MAKEFLAGS="-rs"

# Define linker search path.
export LD_RUN_PATH=$LD_RUN_PATH:$ATHOS_ROOT/bin/$OSTYPE/
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ATHOS_ROOT/bin/$OSTYPE/
export SEARCH_DIR=$ATHOS_ROOT/bin/$OSTYPE/
